/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.utils;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.components.snack_bar.ISnackBarScreen;
import fzmm.zailer.me.utils.SnackBarManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5455;
import net.minecraft.class_5481;
import net.minecraft.class_634;
import net.minecraft.class_640;
import net.minecraft.class_746;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.jetbrains.annotations.Nullable;

public class FzmmUtils {
    public static final SuggestionProvider<FabricClientCommandSource> SUGGESTION_PLAYER = (context, builder) -> {
        class_746 clientPlayer = class_310.method_1551().field_1724;
        String playerInput = builder.getRemainingLowerCase();
        if (clientPlayer != null) {
            List<String> playerNamesList = clientPlayer.field_3944.method_2880().stream().map(class_640::method_2966).map(GameProfile::getName).toList();
            for (String playerName : playerNamesList) {
                if (!playerName.toLowerCase().contains(playerInput)) continue;
                builder.suggest(playerName);
            }
        }
        return CompletableFuture.completedFuture(builder.build());
    };

    public static class_5250 disableItalicConfig(class_5250 message) {
        class_2583 style = message.method_10866();
        if (FzmmClient.CONFIG.general.disableItalic() && !style.method_10966()) {
            message.method_10862(style.method_10978(Boolean.valueOf(false)));
        }
        return message;
    }

    public static class_5250 disableItalicConfig(String string, boolean useDisableItalicConfig) {
        return FzmmUtils.disableItalicConfig(class_2561.method_43470((String)string), useDisableItalicConfig);
    }

    public static class_5250 disableItalicConfig(class_5250 text, boolean useDisableItalicConfig) {
        if (useDisableItalicConfig) {
            return FzmmUtils.disableItalicConfig(text);
        }
        return text;
    }

    public static List<String> splitMessage(String message) {
        int codePoint;
        ArrayList<String> characters = new ArrayList<String>(message.length());
        for (int i = 0; i < message.length(); i += Character.charCount(codePoint)) {
            codePoint = message.codePointAt(i);
            characters.add(new String(Character.toChars(codePoint)));
        }
        return characters;
    }

    public static int getMaxWidth(Collection<class_5348> collection) {
        return FzmmUtils.getMaxWidth(collection, stringVisitable -> stringVisitable);
    }

    public static <T> int getMaxWidth(Collection<T> collection, Function<T, Object> widthGetter) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        int max = 0;
        for (T t : collection) {
            Object text = widthGetter.apply(t);
            int width = text instanceof class_5348 ? textRenderer.method_27525((class_5348)text) : textRenderer.method_30880((class_5481)text);
            max = Math.max(max, width);
        }
        return max;
    }

    public static class_1767[] getDyeColorsInOrder() {
        class_1767[] result = new class_1767[]{class_1767.field_7952, class_1767.field_7967, class_1767.field_7944, class_1767.field_7963, class_1767.field_7957, class_1767.field_7964, class_1767.field_7946, class_1767.field_7947, class_1767.field_7961, class_1767.field_7942, class_1767.field_7955, class_1767.field_7951, class_1767.field_7966, class_1767.field_7945, class_1767.field_7958, class_1767.field_7954};
        return FzmmUtils.addToArray(result, class_1767.values());
    }

    public static class_124[] getFormattingColorsInOrder() {
        class_124[] result = new class_124[]{class_124.field_1068, class_124.field_1080, class_124.field_1063, class_124.field_1074, class_124.field_1079, class_124.field_1061, class_124.field_1065, class_124.field_1054, class_124.field_1060, class_124.field_1077, class_124.field_1062, class_124.field_1075, class_124.field_1078, class_124.field_1058, class_124.field_1064, class_124.field_1076};
        return FzmmUtils.addToArray(result, class_124.values());
    }

    private static <T> T[] addToArray(T[] sortedArray, T[] allArray) {
        int lastIndex = sortedArray.length;
        sortedArray = Arrays.copyOf(sortedArray, allArray.length);
        ArrayList<T> notFound = new ArrayList<T>(Arrays.asList(allArray));
        notFound.removeAll(Arrays.asList(sortedArray));
        for (Object value : notFound) {
            sortedArray[lastIndex++] = value;
        }
        return sortedArray;
    }

    public static class_5455 getRegistryManager() {
        assert (class_310.method_1551().field_1724 != null);
        return class_310.method_1551().field_1724.method_56673();
    }

    public static <T extends class_437> void setScreen(T screen) {
        class_310 client = class_310.method_1551();
        class_437 class_4372 = client.field_1755;
        if (class_4372 instanceof ISnackBarScreen) {
            ISnackBarScreen snackBarScreen = (ISnackBarScreen)class_4372;
            snackBarScreen.setScreen(screen);
        } else {
            client.method_1507(screen);
            SnackBarManager.getInstance().moveToScreen((ISnackBarScreen)screen);
        }
    }

    public static CloseableHttpClient getHttpClient() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(3000).setSocketTimeout(3000).build();
        return HttpClients.custom().setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false)).disableAutomaticRetries().setDefaultRequestConfig(requestConfig).setUserAgent("FZMM/1.0").build();
    }

    @Nullable
    public static class_640 getOnlinePlayer(String username) {
        class_634 networkHandler = class_310.method_1551().method_1562();
        if (networkHandler == null) {
            return null;
        }
        Optional<String> onlineUsername = networkHandler.method_2880().stream().map(entry -> entry.method_2966().getName()).filter(name -> name.equalsIgnoreCase(username)).findFirst();
        return onlineUsername.map(arg_0 -> ((class_634)networkHandler).method_2874(arg_0)).orElse(null);
    }
}

