/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.compat.symbol_chat.components;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.compat.CompatMods;
import io.wispforest.owo.ui.component.VanillaWidgetComponent;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.replaceitem.symbolchat.gui.container.ScrollableGridContainer;
import net.replaceitem.symbolchat.gui.widget.DropDownWidget;
import net.replaceitem.symbolchat.resource.FontProcessor;
import org.jetbrains.annotations.Nullable;

public class FontComponentAdapter
extends VanillaWidgetComponent {
    protected final CustomDropDownWidget widget;
    protected final ScrollableGridContainer scrollGrid;
    private final int expandedHeight;

    public FontComponentAdapter(CustomDropDownWidget widget, int expandedHeight) {
        super((class_339)widget);
        this.widget = widget;
        this.widget.field_22764 = true;
        this.expandedHeight = expandedHeight;
        this.mouseDown().subscribe((mouseX, mouseY, button) -> {
            this.expand();
            return true;
        });
        this.zIndex(500);
        this.scrollGrid = this.getScrollableGrid();
        if (this.scrollGrid == null) {
            FzmmClient.LOGGER.warn("[FontComponentAdapter] Failed to get scrollable grid");
        }
        this.verticalSizing(Sizing.fixed((int)expandedHeight));
        this.expand();
    }

    protected void expand() {
        this.widget.expanded = true;
        if (this.scrollGrid != null) {
            this.scrollGrid.field_22764 = true;
        }
        this.widget.method_53533(this.expandedHeight);
    }

    public void processFont(class_342 widget, String text, Consumer<String> writeConsumer) {
        try {
            FontProcessor selectedFont = (FontProcessor)this.widget.getSelection();
            text = selectedFont.convertString(text);
            writeConsumer.accept(text);
            if (selectedFont.isReverseDirection()) {
                int pos = widget.method_1881() - text.length();
                widget.method_1875(pos);
                widget.method_1884(pos);
            }
        }
        catch (NoClassDefFoundError | NoSuchMethodError e) {
            CompatMods.SYMBOL_CHAT_PRESENT = false;
            FzmmClient.LOGGER.error("[FontComponentAdapter] Failed to process font", (Throwable)e);
        }
    }

    @Nullable
    private ScrollableGridContainer getScrollableGrid() {
        for (class_339 child : this.widget.method_25396()) {
            if (!(child instanceof ScrollableGridContainer)) continue;
            return (ScrollableGridContainer)child;
        }
        return null;
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        this.widget.method_48579((class_332)context, mouseX, mouseY, delta);
    }

    public static class CustomDropDownWidget
    extends DropDownWidget<FontProcessor> {
        public CustomDropDownWidget(int x, int y, int width, int height, List<FontProcessor> elementList, int defaultSelection) {
            super(x, y, width, height, elementList, defaultSelection);
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            super.method_48579(context, mouseX, mouseY, delta);
        }
    }
}

