/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.logic.head_generator.model;

import com.google.gson.JsonObject;
import fzmm.zailer.me.client.logic.head_generator.HeadResourcesLoader;
import fzmm.zailer.me.client.logic.head_generator.model.ModelPoint;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.IParameterEntry;
import fzmm.zailer.me.client.logic.head_generator.model.parameters.OffsetParameter;
import fzmm.zailer.me.utils.SkinPart;
import java.util.List;

public class ModelArea
extends ModelPoint {
    private static final ModelArea ALL_AREA = new ModelArea(SkinPart.HEAD, false, 0, 0, 64, 64);
    private static final ModelArea ALL_BODY = new ModelArea(SkinPart.HEAD, false, 0, 16, 64, 48);
    private static final ModelArea HEAD_LAYER = new ModelArea(SkinPart.HEAD, false, 0, 0, 32, 16);
    private static final ModelArea HAT_HEAD_LAYER = new ModelArea(SkinPart.HEAD, true, 0, 0, 32, 16);
    protected final byte width;
    protected final byte height;

    public ModelArea(SkinPart offset, boolean hatLayer, int x, int y, int width, int height) {
        super(offset, hatLayer, x, y);
        this.width = (byte)width;
        this.height = (byte)height;
    }

    public static ModelArea parse(JsonObject jsonObject) {
        int height;
        String offsetString = HeadResourcesLoader.get(jsonObject, "offset").getAsString();
        if (offsetString.equalsIgnoreCase("ALL")) {
            return ALL_AREA;
        }
        if (offsetString.equalsIgnoreCase("ALL_BODY")) {
            return ALL_BODY;
        }
        ModelPoint point = ModelPoint.parse(jsonObject);
        int width = HeadResourcesLoader.get(jsonObject, "width").getAsInt();
        ModelArea result = new ModelArea(point.offset, point.hatLayer, point.x, point.y, width, height = HeadResourcesLoader.get(jsonObject, "height").getAsInt());
        if (result.equals(HEAD_LAYER)) {
            result = HEAD_LAYER;
        } else if (result.equals(HAT_HEAD_LAYER)) {
            result = HAT_HEAD_LAYER;
        }
        return result;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public ModelArea copyWithOffset(List<IParameterEntry<OffsetParameter>> offsets) {
        ModelArea copy = new ModelArea(this.offset, this.hatLayer, this.x, this.y, this.width, this.height);
        for (IParameterEntry<OffsetParameter> offset : offsets) {
            offset.value().ifPresent(offsetParameter -> {
                if (!offsetParameter.enabled()) {
                    return;
                }
                if (offsetParameter.isXAxis()) {
                    copy.x = (byte)(copy.x + offsetParameter.value());
                } else {
                    copy.y = (byte)(copy.y + offsetParameter.value());
                }
            });
        }
        return copy;
    }

    public byte[][] optimize() {
        return this.optimize(this.hatLayer);
    }

    public byte[][] optimize(boolean hatLayer) {
        if (this == ALL_AREA) {
            byte[][] byArrayArray;
            if (hatLayer) {
                byte[][] byArrayArray2 = new byte[2][];
                byArrayArray2[0] = SkinPart.ALL_USED_AREAS[2];
                byArrayArray = byArrayArray2;
                byArrayArray2[1] = SkinPart.ALL_USED_AREAS[3];
            } else {
                byte[][] byArrayArray3 = new byte[2][];
                byArrayArray3[0] = SkinPart.ALL_USED_AREAS[0];
                byArrayArray = byArrayArray3;
                byArrayArray3[1] = SkinPart.ALL_USED_AREAS[1];
            }
            return byArrayArray;
        }
        if (this.x != 0 || this.y != 0 || this.width <= this.offset.emptyAreaSize() || this.height <= this.offset.emptyAreaSize() || this.width > this.offset.width() || this.height > this.offset.height()) {
            return this.asArray(hatLayer);
        }
        if (this.offset.width() == this.width && this.offset.height() == this.height) {
            byte[][] byArrayArray;
            byte[][] usedAreas = this.offset.usedAreas();
            if (hatLayer) {
                byte[][] byArrayArray4 = new byte[2][];
                byArrayArray4[0] = usedAreas[2];
                byArrayArray = byArrayArray4;
                byArrayArray4[1] = usedAreas[3];
            } else {
                byte[][] byArrayArray5 = new byte[2][];
                byArrayArray5[0] = usedAreas[0];
                byArrayArray = byArrayArray5;
                byArrayArray5[1] = usedAreas[1];
            }
            return byArrayArray;
        }
        byte xOffset = (byte)this.xWithOffset(hatLayer);
        byte yOffset = (byte)this.yWithOffset(hatLayer);
        return SkinPart.getUsedAreas(xOffset, yOffset, this.width, this.height, this.offset.width(), this.offset.height(), this.offset.emptyAreaSize());
    }

    public byte[][] asArray(boolean hatLayer) {
        byte xOffset = (byte)this.xWithOffset(hatLayer);
        byte yOffset = (byte)this.yWithOffset(hatLayer);
        return new byte[][]{{xOffset, yOffset, (byte)(xOffset + this.width), (byte)(yOffset + this.height)}};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModelArea)) {
            return false;
        }
        ModelArea modelArea = (ModelArea)o;
        return this.width == modelArea.width && this.height == modelArea.height && this.y == modelArea.y && this.x == modelArea.x && this.offset == modelArea.offset && this.hatLayer == modelArea.hatLayer;
    }
}

