/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.logic.head_gallery;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.logic.head_gallery.MinecraftHeadsData;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_156;
import org.apache.http.client.HttpResponseException;

public class HeadGalleryResources {
    public static final HashMap<String, ObjectArrayList<MinecraftHeadsData>> cache = new HashMap();
    public static final String MINECRAFT_HEADS_URL = "https://minecraft-heads.com";
    public static final String MINECRAFT_HEADS_API = "https://minecraft-heads.com/scripts/api.php";
    public static final List<String> CATEGORY_LIST = List.of("alphabet", "animals", "blocks", "decoration", "food-drinks", "humans", "humanoid", "miscellaneous", "monsters", "plants");

    public static CompletableFuture<ObjectArrayList<MinecraftHeadsData>> getCategory(String category) {
        CompletableFuture<ObjectArrayList<MinecraftHeadsData>> future = new CompletableFuture<ObjectArrayList<MinecraftHeadsData>>();
        if (!CATEGORY_LIST.contains(category)) {
            String categoryList = String.join((CharSequence)", ", CATEGORY_LIST);
            String message = "Invalid category. Please choose from the following list:\n" + categoryList;
            FzmmClient.LOGGER.error(message);
            future.completeExceptionally(new IllegalArgumentException(message));
            return future;
        }
        boolean cacheCategories = FzmmClient.CONFIG.headGallery.cacheCategories();
        if (cacheCategories && cache.containsKey(category)) {
            future.complete(cache.get(category));
            return future;
        }
        String url = HeadGalleryResources.getUrl(category);
        future.completeAsync(() -> {
            try {
                return HeadGalleryResources.fetchUrl(url, category, cacheCategories);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, (Executor)class_156.method_55473());
        return future;
    }

    private static String getUrl(String category) {
        return "https://minecraft-heads.com/scripts/api.php?cat=" + category + "&tags=true";
    }

    private static ObjectArrayList<MinecraftHeadsData> fetchUrl(String url, String category, boolean cacheCategories) throws Exception {
        URL obj = URI.create(url).toURL();
        HttpURLConnection conn = (HttpURLConnection)obj.openConnection();
        conn.setRequestProperty("User-Agent", "FZMM/1.0");
        conn.setRequestMethod("GET");
        conn.setConnectTimeout(8000);
        conn.setReadTimeout(8000);
        int responseCode = conn.getResponseCode();
        if (responseCode / 100 == 2) {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            ObjectArrayList<MinecraftHeadsData> headsData = HeadGalleryResources.parseJson(response.toString());
            if (cacheCategories) {
                cache.put(category, headsData);
            }
            FzmmClient.LOGGER.info("[HeadGalleryResources] category '{}' successfully loaded", (Object)category);
            return headsData;
        }
        String errorReason = conn.getResponseMessage();
        String message = "HTTP Error " + responseCode + " (" + (errorReason == null ? "Unknown reason" : errorReason) + ")";
        throw new HttpResponseException(responseCode, message);
    }

    private static ObjectArrayList<MinecraftHeadsData> parseJson(String json) {
        JsonArray jsonArray = JsonParser.parseString((String)json).getAsJsonArray();
        ObjectArrayList headsData = new ObjectArrayList();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject jsonObject = jsonArray.get(i).getAsJsonObject();
            headsData.add((Object)MinecraftHeadsData.parse(jsonObject));
        }
        return headsData;
    }
}

