/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.logic.enycrpt_book;

import com.google.gson.JsonObject;
import fzmm.zailer.me.config.FzmmConfigModel;
import io.wispforest.owo.config.annotation.RangeConstraint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Random;

public record TranslationEncryptProfile(int seed, @RangeConstraint(min=1.0, max=512.0) int length, String key, int asymmetricValue, @RangeConstraint(min=1.0, max=2.0) int algorithmVersion) {
    public static final int ALGORITHM_VERSION = 2;
    public static final int MAX_LENGTH = 512;

    public boolean isAsymmetric() {
        return this.asymmetricValue() != 0;
    }

    public boolean isOldAlgorithm() {
        return this.algorithmVersion() != 2;
    }

    public String translationKey() {
        return TranslationEncryptProfile.translationKey(this.key(), this.seed());
    }

    public static String translationKey(String key, int seed) {
        return key.replaceFirst("%s", String.valueOf(seed));
    }

    public int asymmetricSeed() {
        int result = this.seed();
        if (this.isAsymmetric()) {
            if (result == 0) {
                result = 1;
            }
            result *= this.asymmetricValue() + 423794224;
        }
        return result;
    }

    @Deprecated(since="0.2.14")
    private List<Short> oldShuffleIndex() {
        int messageLength = this.length();
        ArrayList<Short> encryptedKey = new ArrayList<Short>();
        Random number = new Random(this.asymmetricSeed());
        number.nextInt(messageLength);
        while (encryptedKey.size() < messageLength) {
            short nextInt = (short)number.nextInt(messageLength);
            if (encryptedKey.contains(nextInt)) continue;
            encryptedKey.add(nextInt);
        }
        return encryptedKey;
    }

    private List<Short> shuffleIndex() {
        short s = this.length();
        ArrayList<Short> indexList = new ArrayList<Short>(s);
        for (short i = 0; i < s; i = (short)(i + 1)) {
            indexList.add(i);
        }
        Random number = new Random(this.asymmetricSeed());
        Collections.shuffle(indexList, number);
        return indexList;
    }

    public List<Short> encryptIndexOrder() {
        return switch (this.algorithmVersion()) {
            case 1 -> this.oldShuffleIndex();
            case 2 -> this.shuffleIndex();
            default -> throw new IllegalArgumentException("Unknown algorithm version: " + this.algorithmVersion());
        };
    }

    public String decryptorValue() {
        StringBuilder result = new StringBuilder();
        Formatter formatter = new Formatter(result);
        int length = this.length();
        List<Short> encryptedIndex = this.encryptIndexOrder();
        for (int i = 0; i < length; ++i) {
            formatter.format("%%%1$s$s", encryptedIndex.get(i) + 1);
        }
        return result.toString();
    }

    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        result.addProperty(this.translationKey(), this.decryptorValue());
        return result;
    }

    public static TranslationEncryptProfile of(FzmmConfigModel.TranslationEncryptProfileModel model) {
        return new TranslationEncryptProfile(model.seed, model.length, model.key, model.asymmetricValue, model.algorithmVersion);
    }

    public static List<TranslationEncryptProfile> of(List<FzmmConfigModel.TranslationEncryptProfileModel> models) {
        return models.stream().map(TranslationEncryptProfile::of).toList();
    }

    public FzmmConfigModel.TranslationEncryptProfileModel toModel() {
        FzmmConfigModel.TranslationEncryptProfileModel model = new FzmmConfigModel.TranslationEncryptProfileModel();
        model.seed = this.seed();
        model.length = this.length();
        model.key = this.key();
        model.asymmetricValue = this.asymmetricValue();
        model.algorithmVersion = this.algorithmVersion();
        return model;
    }
}

