/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.player_statue;

import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.ContextMenuButton;
import fzmm.zailer.me.client.gui.components.row.ButtonRow;
import fzmm.zailer.me.client.gui.components.row.ContextMenuButtonRow;
import fzmm.zailer.me.client.gui.components.row.NumberRow;
import fzmm.zailer.me.client.gui.components.row.ScreenTabRow;
import fzmm.zailer.me.client.gui.components.row.TextBoxRow;
import fzmm.zailer.me.client.gui.options.HorizontalDirectionOption;
import fzmm.zailer.me.client.gui.player_statue.tabs.IPlayerStatueTab;
import fzmm.zailer.me.client.gui.player_statue.tabs.PlayerStatueTabs;
import fzmm.zailer.me.client.gui.utils.InvisibleEntityWarning;
import fzmm.zailer.me.client.gui.utils.memento.IMementoObject;
import fzmm.zailer.me.client.gui.utils.memento.IMementoScreen;
import io.wispforest.owo.config.ui.component.ConfigTextBox;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class PlayerStatueScreen
extends BaseFzmmScreen
implements IMementoScreen {
    private static final String HORIZONTAL_DIRECTION_ID = "horizontal-direction";
    private static final String POS_X_ID = "posX";
    private static final String POS_Y_ID = "posY";
    private static final String POS_Z_ID = "posZ";
    private static final String NAME_ID = "name";
    public static final String EXECUTE_ID = "execute";
    private static PlayerStatueTabs selectedTab = PlayerStatueTabs.CREATE;
    private static PlayerStatueMemento memento = null;
    private HorizontalDirectionOption direction;
    private ConfigTextBox posX;
    private ConfigTextBox posY;
    private ConfigTextBox posZ;
    private TextBoxComponent nameField;
    private class_4185 executeButton;

    public PlayerStatueScreen(@Nullable class_437 parent) {
        super("player_statue", "playerStatue", parent);
    }

    @Override
    protected void setup(FlowLayout rootComponent) {
        class_746 player = class_310.method_1551().field_1724;
        assert (player != null);
        ContextMenuButton directionButton = (ContextMenuButton)rootComponent.childById(ContextMenuButton.class, ContextMenuButtonRow.getButtonId(HORIZONTAL_DIRECTION_ID));
        BaseFzmmScreen.checkNull((Component)directionButton, "context-menu-button", ContextMenuButtonRow.getButtonId(HORIZONTAL_DIRECTION_ID));
        directionButton.setContextMenuOptions(dropdownComponent -> {
            for (HorizontalDirectionOption option : HorizontalDirectionOption.values()) {
                dropdownComponent.button((class_2561)class_2561.method_43471((String)option.getTranslationKey()), dropdownButton -> {
                    this.direction = option;
                    directionButton.method_25355((class_2561)class_2561.method_43471((String)option.getTranslationKey()));
                    dropdownButton.remove();
                });
            }
        });
        this.direction = HorizontalDirectionOption.getPlayerHorizontalDirection();
        directionButton.method_25355((class_2561)class_2561.method_43471((String)this.direction.getTranslationKey()));
        this.posX = NumberRow.setup(rootComponent, POS_X_ID, player.method_31477(), Float.class);
        this.posY = NumberRow.setup(rootComponent, POS_Y_ID, player.method_23318(), Float.class);
        this.posZ = NumberRow.setup(rootComponent, POS_Z_ID, player.method_31479(), Float.class);
        this.nameField = TextBoxRow.setup(rootComponent, NAME_ID, "", 65535);
        this.setTabs(selectedTab);
        ScreenTabRow.setup(rootComponent, "tabs", selectedTab);
        for (PlayerStatueTabs playerStatueTab : PlayerStatueTabs.values()) {
            IPlayerStatueTab tab = this.getTab(playerStatueTab, IPlayerStatueTab.class);
            tab.setupComponents(rootComponent);
            ButtonRow.setup(rootComponent, ScreenTabRow.getScreenTabButtonId(tab), !tab.getId().equals(selectedTab.getId()), button -> {
                selectedTab = this.selectScreenTab(rootComponent, tab, selectedTab);
                this.executeButton.field_22763 = this.getTab(selectedTab, IPlayerStatueTab.class).canExecute();
            });
        }
        this.selectScreenTab(rootComponent, selectedTab, selectedTab);
        ButtonRow.setup(rootComponent, ButtonRow.getButtonId("faq"), true, this::faqExecute);
        this.executeButton = ButtonRow.setup(rootComponent, ButtonRow.getButtonId(EXECUTE_ID), true, this::execute);
        this.executeButton.field_22763 = this.getTab(selectedTab, IPlayerStatueTab.class).canExecute();
        ButtonRow.setup(rootComponent, ButtonRow.getButtonId("difficult-to-remove-entity"), true, buttonComponent -> InvisibleEntityWarning.addOverlay(true, true, (class_2561)class_2561.method_43471((String)"fzmm.snack_bar.entityDifficultToRemove.entity.playerStatue"), "PlayerStatue"));
    }

    private void faqExecute(class_4185 buttonWidget) {
        assert (this.field_22787 != null);
        class_407.method_60866((class_437)this.field_22787.field_1755, (String)"https://github.com/Zailer43/FZMM-Mod/blob/1.21.4/dev/docs/en/wiki/player_statue/0.2.9_player_statue.md", (boolean)true);
    }

    private void execute(class_4185 buttonWidget) {
        float x = ((Float)this.posX.parsedValue()).floatValue();
        float y = ((Float)this.posY.parsedValue()).floatValue();
        float z = ((Float)this.posZ.parsedValue()).floatValue();
        String name = this.nameField.method_1882();
        this.getTab(selectedTab, IPlayerStatueTab.class).execute(this.direction, x, y, z, name);
    }

    @Override
    public void setMemento(IMementoObject memento) {
        PlayerStatueScreen.memento = (PlayerStatueMemento)memento;
    }

    @Override
    public Optional<IMementoObject> getMemento() {
        return Optional.ofNullable(memento);
    }

    @Override
    public IMementoObject createMemento() {
        return new PlayerStatueMemento(this.nameField.method_1882(), this.createMementoTabs());
    }

    @Override
    public void restoreMemento(IMementoObject mementoObject) {
        PlayerStatueMemento memento = (PlayerStatueMemento)mementoObject;
        this.nameField.text(memento.name());
        this.restoreMementoTabs(memento.mementoTabHashMap);
    }

    private record PlayerStatueMemento(String name, HashMap<String, IMementoObject> mementoTabHashMap) implements IMementoObject
    {
    }
}

