/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.imagetext.tabs;

import fzmm.zailer.me.builders.ContainerBuilder;
import fzmm.zailer.me.builders.DisplayBuilder;
import fzmm.zailer.me.builders.SignBuilder;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.ContextMenuButton;
import fzmm.zailer.me.client.gui.imagetext.algorithms.IImagetextAlgorithm;
import fzmm.zailer.me.client.gui.imagetext.tabs.IImagetextTab;
import fzmm.zailer.me.client.gui.imagetext.tabs.IImagetextTooltip;
import fzmm.zailer.me.client.gui.utils.memento.IMementoObject;
import fzmm.zailer.me.client.logic.imagetext.ImagetextData;
import fzmm.zailer.me.client.logic.imagetext.ImagetextLogic;
import fzmm.zailer.me.utils.ItemUtils;
import io.wispforest.owo.ui.component.SmallCheckboxComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2508;
import net.minecraft.class_2561;
import net.minecraft.class_2625;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4719;
import net.minecraft.class_7713;
import net.minecraft.class_7717;
import net.minecraft.class_7923;

public class ImagetextSignTab
implements IImagetextTab,
IImagetextTooltip {
    private static final String BASE_ITEMS_TRANSLATION_KEY = "fzmm.item.imagetext.sign.";
    private static final String SIGN_TYPE_ID = "signType";
    private static final String IS_HANGING_ID = "isHangingSign";
    private ContextMenuButton signTypeButton;
    private SmallCheckboxComponent isHangingSignButton;
    private String characters;
    private class_4719 woodType;

    @Override
    public void generate(IImagetextAlgorithm algorithm, ImagetextLogic logic, ImagetextData data, boolean isExecute) {
        this.characters = algorithm.getCharacters();
        if (isExecute) {
            logic.generateImagetext(algorithm, data, this.getLineSplitInterval(this.characters));
        } else {
            logic.generateImagetext(algorithm, data);
        }
    }

    @Override
    public void execute(ImagetextLogic logic) {
        int color = FzmmClient.CONFIG.colors.imagetextMessages().rgb();
        List<class_1799> signContainers = ContainerBuilder.builder().containerItem(class_1802.field_8627).maxItemByContainer(27).addAll(this.getSignItems(logic)).getAsList();
        class_1799 signMainContainer = ContainerBuilder.builder().containerItem(class_1802.field_8451).maxItemByContainer(27).add(DisplayBuilder.builder().item(class_1802.field_8407).setName((class_2561)class_2561.method_43469((String)"fzmm.item.imagetext.sign.details.name", (Object[])new Object[]{this.getHorizontalSigns(logic.getWidth(), this.getLineSplitInterval(this.characters)), this.getVerticalSigns(logic.getHeight())}), color).get()).addAll(signContainers).getAsList().get(0);
        signMainContainer = DisplayBuilder.of(signMainContainer).setName((class_2561)class_2561.method_43471((String)"fzmm.item.imagetext.sign.container.name"), color).addLore((class_2561)class_2561.method_43469((String)"fzmm.item.imagetext.sign.container.lore.1", (Object[])new Object[]{logic.getWidth(), logic.getHeight()}), color).get();
        ItemUtils.give(signMainContainer);
    }

    @Override
    public void setupComponents(FlowLayout rootComponent) {
        this.signTypeButton = (ContextMenuButton)rootComponent.childById(ContextMenuButton.class, SIGN_TYPE_ID);
        BaseFzmmScreen.checkNull((Component)this.signTypeButton, "context-menu-button", SIGN_TYPE_ID);
        this.signTypeButton.setContextMenuOptions(dropdownComponent -> {
            List<class_4719> optionList = class_4719.method_24026().sorted(Comparator.comparing(woodType1 -> this.getSignText((class_4719)woodType1).getString())).toList();
            for (class_4719 option : optionList) {
                dropdownComponent.button(this.getSignText(option), dropdownButton -> {
                    this.updateSignType(option);
                    dropdownButton.remove();
                });
            }
        });
        this.updateSignType(class_4719.field_21676);
        this.isHangingSignButton = (SmallCheckboxComponent)rootComponent.childById(SmallCheckboxComponent.class, "isHangingSign-checkbox");
        BaseFzmmScreen.checkNull((Component)this.isHangingSignButton, "small-checkbox", "isHangingSign-checkbox");
        this.isHangingSignButton.checked(false);
    }

    private void updateSignType(class_4719 option) {
        this.woodType = option;
        this.signTypeButton.method_25355(this.getSignText(this.woodType));
    }

    @Override
    public String getId() {
        return "sign";
    }

    private class_2561 getSignText(class_4719 type) {
        return class_2561.method_43471((String)("block.minecraft." + type.comp_1299() + "_sign"));
    }

    public List<class_1799> getSignItems(ImagetextLogic logic) {
        ArrayList<SignBuilder> signBuilders = new ArrayList<SignBuilder>();
        List<class_2561> imagetext = logic.getWrappedText();
        int width = logic.getWidth();
        int height = logic.getHeight();
        int lineSplitInterval = this.getLineSplitInterval(this.characters);
        int horizontalSigns = this.getHorizontalSigns(width, lineSplitInterval);
        int verticalSigns = this.getVerticalSigns(height);
        int maxTextWidth = this.getMaxTextWidth();
        class_1792 item = this.getItem();
        for (int y = 0; y != verticalSigns; ++y) {
            for (int x = 0; x != horizontalSigns; ++x) {
                int index = y * horizontalSigns + x;
                if (signBuilders.size() <= index) {
                    signBuilders.add(SignBuilder.builder().item(item));
                }
                SignBuilder signBuilder = (SignBuilder)signBuilders.get(index);
                for (int i = 0; i != 4; ++i) {
                    int imagetextIndex = (y * 4 + i) * horizontalSigns + x;
                    if (imagetext.size() <= imagetextIndex) continue;
                    signBuilder.addFrontLine(imagetext.get(imagetextIndex), maxTextWidth);
                }
            }
        }
        return this.formatSignItems(signBuilders, horizontalSigns);
    }

    public int getHorizontalSigns(int width, int lineSplitInterval) {
        int horizontalSigns = (int)Math.floor((double)width / (double)lineSplitInterval);
        if (width % lineSplitInterval != 0) {
            ++horizontalSigns;
        }
        return horizontalSigns;
    }

    public int getVerticalSigns(int height) {
        int verticalSigns = (int)Math.floor((double)height / 4.0);
        if (height % 4 != 0) {
            ++verticalSigns;
        }
        return verticalSigns;
    }

    public List<class_1799> formatSignItems(List<SignBuilder> signBuilders, int signsPerLine) {
        ArrayList<class_1799> signStackList = new ArrayList<class_1799>();
        int color = FzmmClient.CONFIG.colors.imagetextMessages().rgb();
        for (int i = 0; i != signBuilders.size(); ++i) {
            class_1799 sign = signBuilders.get(i).wax().get();
            sign = DisplayBuilder.of(sign).setName(String.format("X: %d - Y: %d", i % signsPerLine + 1, i / signsPerLine + 1), color).get();
            signStackList.add(sign);
        }
        return signStackList;
    }

    public int getLineSplitInterval(String characters) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        int textWidth = textRenderer.method_1727(characters);
        double numRepeats = (double)this.getMaxTextWidth() / (double)textWidth;
        return (int)Math.ceil(numRepeats * (double)characters.length());
    }

    public int getMaxTextWidth() {
        class_7717 signBlockEntity = this.isHangingSignButton.checked() ? new class_7717(new class_2338(0, 0, 0), class_2246.field_40262.method_9564()) : new class_2625(new class_2338(0, 0, 0), class_2246.field_10121.method_9564());
        return signBlockEntity.method_45470();
    }

    public class_1792 getItem() {
        boolean isHangingSign = this.isHangingSignButton.checked();
        for (class_2248 block : class_7923.field_41175.method_10220().toList()) {
            class_2508 signBlock;
            class_7713 hangingSignBlock;
            if (isHangingSign && block instanceof class_7713 && (hangingSignBlock = (class_7713)block).method_24025() == this.woodType) {
                return hangingSignBlock.method_8389();
            }
            if (isHangingSign || !(block instanceof class_2508) || (signBlock = (class_2508)block).method_24025() != this.woodType) continue;
            return signBlock.method_8389();
        }
        return class_1802.field_8788;
    }

    @Override
    public IMementoObject createMemento() {
        return new SignMementoTab(this.woodType, this.isHangingSignButton.checked());
    }

    @Override
    public void restoreMemento(IMementoObject mementoTab) {
        SignMementoTab memento = (SignMementoTab)mementoTab;
        this.updateSignType(memento.signType);
        this.isHangingSignButton.checked(memento.isHangingSign());
    }

    @Override
    public class_2561 getTooltip(ImagetextLogic logic) {
        int lineSplitInterval = this.getLineSplitInterval(this.characters);
        int horizontalSigns = this.getHorizontalSigns(logic.getWidth(), lineSplitInterval);
        int verticalSigns = this.getVerticalSigns(logic.getHeight());
        return class_2561.method_43469((String)"fzmm.gui.imagetext.tab.sign.tooltip", (Object[])new Object[]{horizontalSigns, verticalSigns});
    }

    private record SignMementoTab(class_4719 signType, boolean isHangingSign) implements IMementoObject
    {
    }
}

