/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.imagetext.tabs;

import fzmm.zailer.me.builders.BookBuilder;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.ContextMenuButton;
import fzmm.zailer.me.client.gui.imagetext.algorithms.IImagetextAlgorithm;
import fzmm.zailer.me.client.gui.imagetext.tabs.IImagetextTab;
import fzmm.zailer.me.client.gui.options.BookOption;
import fzmm.zailer.me.client.gui.utils.memento.IMementoObject;
import fzmm.zailer.me.client.logic.imagetext.ImagetextData;
import fzmm.zailer.me.client.logic.imagetext.ImagetextLogic;
import fzmm.zailer.me.utils.ItemUtils;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import org.jetbrains.annotations.Nullable;

public class ImagetextBookPageTab
implements IImagetextTab {
    private static final String BOOK_PAGE_MODE_ID = "bookPageMode";
    private ContextMenuButton bookPageButton;
    private BookOption bookMode;

    @Override
    public void generate(IImagetextAlgorithm algorithm, ImagetextLogic logic, ImagetextData data, boolean isExecute) {
        ImagetextData modifiedData = new ImagetextData(data.image(), this.getMaxImageWidthForBookPage(algorithm.getCharacters()), 15, data.smoothRescaling(), data.percentageOfSimilarityToCompress());
        logic.generateImagetext(algorithm, modifiedData);
    }

    @Override
    public void execute(ImagetextLogic logic) {
        BookBuilder bookBuilder = this.bookMode.getBookBuilder();
        bookBuilder.addPage(logic.getText());
        ItemUtils.give(bookBuilder.get());
    }

    @Override
    public void setupComponents(FlowLayout rootComponent) {
        this.bookPageButton = (ContextMenuButton)rootComponent.childById(ContextMenuButton.class, BOOK_PAGE_MODE_ID);
        BaseFzmmScreen.checkNull((Component)this.bookPageButton, "context-menu-button", BOOK_PAGE_MODE_ID);
        this.bookPageButton.setContextMenuOptions(dropdownComponent -> {
            for (BookOption option : BookOption.values()) {
                dropdownComponent.button((class_2561)class_2561.method_43471((String)option.getTranslationKey()), dropdownButton -> {
                    this.updateBookPage(option);
                    dropdownButton.remove();
                });
            }
        });
        this.updateBookPage(BookOption.ADD_PAGE);
    }

    private void updateBookPage(BookOption bookMode) {
        this.bookMode = bookMode;
        this.bookPageButton.method_25355((class_2561)class_2561.method_43471((String)this.bookMode.getTranslationKey()));
    }

    @Override
    public String getId() {
        return "bookPage";
    }

    private int getMaxImageWidthForBookPage(@Nullable String characters) {
        if (characters == null) {
            characters = "\u2588";
        }
        int maxTextWidth = 113;
        int width = 0;
        class_327 textRenderer = class_310.method_1551().field_1772;
        if (characters.length() == 1) {
            width = maxTextWidth / textRenderer.method_1727(characters);
        } else {
            Object message = "";
            int length = characters.length();
            do {
                message = (String)message + characters.charAt(width % length);
                ++width;
            } while (textRenderer.method_1727((String)message) < maxTextWidth);
        }
        return width;
    }

    @Override
    public IMementoObject createMemento() {
        return new BookPageMementoTab(this.bookMode);
    }

    @Override
    public void restoreMemento(IMementoObject mementoTab) {
        BookPageMementoTab memento = (BookPageMementoTab)mementoTab;
        this.updateBookPage(memento.mode);
    }

    private record BookPageMementoTab(BookOption mode) implements IMementoObject
    {
    }
}

