/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.encrypt_book;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.SuggestionTextBox;
import fzmm.zailer.me.client.gui.components.containers.ConfirmOverlay;
import fzmm.zailer.me.client.gui.components.row.ButtonRow;
import fzmm.zailer.me.client.gui.components.row.TextBoxRow;
import fzmm.zailer.me.client.gui.components.style.FzmmStyles;
import fzmm.zailer.me.client.gui.components.style.component.StyledLabelComponent;
import fzmm.zailer.me.client.gui.components.style.container.StyledFlowLayout;
import fzmm.zailer.me.client.gui.encrypt_book.components.AddEncryptProfileOverlay;
import fzmm.zailer.me.client.gui.encrypt_book.components.DecryptorSaverOverlay;
import fzmm.zailer.me.client.gui.utils.memento.IMementoObject;
import fzmm.zailer.me.client.gui.utils.memento.IMementoScreen;
import fzmm.zailer.me.client.logic.enycrpt_book.EncryptbookLogic;
import fzmm.zailer.me.client.logic.enycrpt_book.TranslationEncryptProfile;
import fzmm.zailer.me.config.FzmmConfig;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextAreaComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.util.FocusHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class EncryptBookScreen
extends BaseFzmmScreen
implements IMementoScreen {
    private static EncryptBookMemento memento = null;
    private TextAreaComponent messageTextArea;
    private TextBoxComponent paddingCharactersField;
    private TextBoxComponent authorField;
    private TextBoxComponent titleField;
    private FlowLayout decryptorProfileLayout;
    private LabelComponent decryptorStatus;
    @Nullable
    private TranslationEncryptProfile selectedProfile = null;
    private int selectedProfileIndex;

    public EncryptBookScreen(@Nullable class_437 parent) {
        super("encrypt_book", "encryptbook", parent);
    }

    @Override
    protected void setup(FlowLayout rootComponent) {
        assert (this.field_22787 != null);
        assert (this.field_22787.field_1724 != null);
        FzmmConfig.Encryptbook config = FzmmClient.CONFIG.encryptbook;
        this.messageTextArea = (TextAreaComponent)rootComponent.childById(TextAreaComponent.class, "message-text-area");
        BaseFzmmScreen.checkNull((Component)this.messageTextArea, "text-area", "message-text-area");
        this.messageTextArea.text(config.defaultBookMessage());
        this.authorField = TextBoxRow.setup(rootComponent, "author", this.field_22787.field_1724.method_5477().getString(), 512);
        this.titleField = TextBoxRow.setup(rootComponent, "title", config.defaultBookTitle(), 32);
        String configPadding = config.padding();
        this.paddingCharactersField = TextBoxRow.setup(rootComponent, "paddingCharacters", configPadding, 512);
        ButtonRow.setup(rootComponent, ButtonRow.getButtonId("add-profile"), true, this::addProfileOverlay);
        TextBoxComponent textBoxComponent = this.paddingCharactersField;
        if (textBoxComponent instanceof SuggestionTextBox) {
            SuggestionTextBox suggestionTextBox = (SuggestionTextBox)textBoxComponent;
            suggestionTextBox.setSuggestionProvider((context, builder) -> {
                String defaultValue = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_,.";
                builder.suggest(defaultValue);
                if (!defaultValue.equals(configPadding)) {
                    builder.suggest(configPadding);
                }
                return CompletableFuture.completedFuture(builder.build());
            });
        }
        this.decryptorStatus = (LabelComponent)rootComponent.childById(StyledLabelComponent.class, "profile-status");
        BaseFzmmScreen.checkNull((Component)this.decryptorStatus, "fzmm.styled-label", "profile-status");
        ButtonRow.setup(rootComponent, ButtonRow.getButtonId("get-decryptor"), true, buttonComponent -> this.decryptorSaverOverlay(this.selectedProfile));
        this.decryptorProfileLayout = (FlowLayout)rootComponent.childById(StyledFlowLayout.class, "profile-list");
        BaseFzmmScreen.checkNull((Component)this.decryptorProfileLayout, "fzmm.styled-flow-layout", "profile-list");
        this.updateDecryptorProfileList();
        this.selectProfile(0);
        ButtonRow.setup(rootComponent, ButtonRow.getButtonId("give"), true, buttonComponent -> this.giveBook(false));
        ButtonRow.setup(rootComponent, ButtonRow.getButtonId("add-page"), true, buttonComponent -> this.giveBook(true));
        ButtonRow.setup(rootComponent, ButtonRow.getButtonId("faq"), true, this::faqExecute);
    }

    @Override
    protected void initFocus(FocusHandler focusHandler) {
        focusHandler.focus((Component)this.messageTextArea, Component.FocusSource.MOUSE_CLICK);
    }

    private void updateDecryptorProfileList() {
        List<TranslationEncryptProfile> decryptorProfiles = EncryptBookScreen.getProfiles();
        ArrayList<StyledFlowLayout> componentList = new ArrayList<StyledFlowLayout>();
        int i = 0;
        while (i < decryptorProfiles.size()) {
            TranslationEncryptProfile profile = decryptorProfiles.get(i);
            int finalI = i++;
            StyledFlowLayout component = (StyledFlowLayout)((StyledFlowLayout)this.getModel().expandTemplate(StyledFlowLayout.class, "profile-option", Map.of())).configure(layout -> {
                StyledLabelComponent label = (StyledLabelComponent)layout.childById(StyledLabelComponent.class, "label");
                BaseFzmmScreen.checkNull((Component)label, "fzmm.styled-label", "label");
                label.text((class_2561)class_2561.method_43469((String)"fzmm.gui.encryptbook.label.profile", (Object[])new Object[]{profile.translationKey(), profile.length(), profile.isAsymmetric(), profile.isOldAlgorithm()}));
                layout.mouseDown().subscribe((mouseX, mouseY, button) -> this.profileSelect((FlowLayout)layout, profile, finalI));
                ButtonComponent removeButton = (ButtonComponent)layout.childById(ButtonComponent.class, "remove-button");
                BaseFzmmScreen.checkNull((Component)removeButton, "button", "remove-button");
                removeButton.onPress(button -> this.addOverlay((Component)new ConfirmOverlay((class_2561)class_2561.method_43471((String)"fzmm.gui.encryptbook.label.removeDecryptor"), aBoolean -> {
                    if (aBoolean.booleanValue()) {
                        FzmmClient.CONFIG.encryptbook.profiles().remove(profile.toModel());
                        FzmmClient.CONFIG.save();
                        layout.remove();
                        this.updateDecryptorStatus(this.selectedProfile);
                    }
                })));
            });
            componentList.add(component);
        }
        this.decryptorProfileLayout.clearChildren();
        this.decryptorProfileLayout.children(componentList);
    }

    private boolean profileSelect(FlowLayout profileLayout, TranslationEncryptProfile profile, int index) {
        this.selectedProfile = profile;
        this.selectedProfileIndex = index;
        for (Component child : this.decryptorProfileLayout.children()) {
            if (!(child instanceof FlowLayout)) continue;
            FlowLayout childLayout = (FlowLayout)child;
            Surface surface = Surface.flat((int)(childLayout == profileLayout ? 0x70000000 : 0x40000000));
            childLayout.surface(surface);
        }
        this.updateDecryptorStatus(profile);
        this.messageTextArea.method_44402(profile.length());
        return true;
    }

    public void addProfileOverlay(class_4185 buttonWidget) {
        this.addOverlay((Component)new AddEncryptProfileOverlay(profile -> {
            FzmmClient.CONFIG.encryptbook.profiles().add(profile.toModel());
            FzmmClient.CONFIG.save();
            this.updateDecryptorProfileList();
            this.selectProfile(this.decryptorProfileLayout.children().size() - 1);
            this.decryptorSaverOverlay((TranslationEncryptProfile)profile);
        }));
    }

    private void decryptorSaverOverlay(TranslationEncryptProfile profile) {
        this.addOverlay((Component)new DecryptorSaverOverlay(profile));
    }

    public void selectProfile(int index) {
        List profileLayout = this.decryptorProfileLayout.children();
        if (profileLayout.isEmpty()) {
            return;
        }
        int selectedProfileIndex = index < profileLayout.size() ? index : 0;
        ((Component)profileLayout.get(selectedProfileIndex)).onMouseDown(0.0, 0.0, 0);
    }

    public void updateDecryptorStatus(@Nullable TranslationEncryptProfile profile) {
        class_5250 result;
        boolean isValid = false;
        String translationValue = "fzmm.gui.encryptbook.label.profile.";
        if (profile != null && class_1074.method_4663((String)profile.translationKey())) {
            String decryptString = class_2561.method_43471((String)profile.translationKey()).getString();
            isValid = decryptString.equals(profile.decryptorValue());
            String status = isValid ? "loaded" : "outdated";
            result = class_2561.method_43471((String)(translationValue + status));
        } else {
            result = class_2561.method_43471((String)(translationValue + "notFound"));
        }
        result = result.method_27661().method_10862(class_2583.field_24360.method_36139((isValid ? FzmmStyles.TEXT_SUCCESS_COLOR : FzmmStyles.TEXT_ERROR_COLOR).rgb()));
        this.decryptorStatus.text((class_2561)result);
    }

    private void giveBook(boolean isAddPage) {
        String paddingChars;
        if (this.selectedProfile == null) {
            return;
        }
        FzmmConfig.Encryptbook config = FzmmClient.CONFIG.encryptbook;
        String message = this.messageTextArea.method_44405();
        if (message.isEmpty()) {
            message = config.defaultBookMessage();
        }
        if ((paddingChars = this.paddingCharactersField.method_1882()).isEmpty()) {
            paddingChars = " ";
        }
        String author = this.authorField.method_1882();
        String title = this.titleField.method_1882();
        EncryptbookLogic.give(message, author, paddingChars, title, this.selectedProfile, isAddPage);
    }

    private void faqExecute(class_4185 buttonWidget) {
        assert (this.field_22787 != null);
        class_407.method_60866((class_437)this.field_22787.field_1755, (String)"https://github.com/Zailer43/FZMM-Mod/blob/1.21.4/dev/docs/en/wiki/encrypt_book/0.2.14_encrypt_book.md", (boolean)true);
    }

    public static List<TranslationEncryptProfile> getProfiles() {
        return TranslationEncryptProfile.of(FzmmClient.CONFIG.encryptbook.profiles());
    }

    @Override
    public void setMemento(IMementoObject memento) {
        EncryptBookScreen.memento = (EncryptBookMemento)memento;
    }

    @Override
    public Optional<IMementoObject> getMemento() {
        return Optional.ofNullable(memento);
    }

    @Override
    public IMementoObject createMemento() {
        return new EncryptBookMemento(this.messageTextArea.method_44405(), this.authorField.method_1882(), this.titleField.method_1882(), this.paddingCharactersField.method_1882(), this.selectedProfileIndex);
    }

    @Override
    public void restoreMemento(IMementoObject mementoObject) {
        EncryptBookMemento memento = (EncryptBookMemento)mementoObject;
        this.messageTextArea.text(memento.message);
        this.authorField.text(memento.author);
        this.titleField.text(memento.title);
        this.paddingCharactersField.text(memento.paddingCharacters);
        this.selectProfile(memento.selectedProfileIndex);
    }

    private record EncryptBookMemento(String message, String author, String title, String paddingCharacters, int selectedProfileIndex) implements IMementoObject
    {
    }
}

