/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.components.row;

import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.style.FzmmStyles;
import fzmm.zailer.me.client.gui.components.style.StyledComponents;
import fzmm.zailer.me.client.gui.components.style.StyledContainers;
import fzmm.zailer.me.client.gui.components.style.container.StyledFlowLayout;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.parsing.UIParsing;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2561;
import org.w3c.dom.Element;

public abstract class AbstractRow
extends StyledFlowLayout {
    protected static final int NORMAL_WIDTH = 200;
    protected static final int TEXT_FIELD_WIDTH = 199;
    public static final int ROW_HEIGHT = 22;
    public static final int VERTICAL_MARGIN = 2;
    public static final int TOTAL_HEIGHT = 26;
    protected final String baseTranslationKey;
    private String id;
    private final boolean translate;

    public AbstractRow(String baseTranslationKey) {
        super(Sizing.fill((int)100), Sizing.fixed((int)26), FlowLayout.Algorithm.HORIZONTAL);
        this.baseTranslationKey = baseTranslationKey;
        this.translate = true;
        this.hoveredSurface(FzmmStyles.DEFAULT_HOVERED);
    }

    public AbstractRow(String baseTranslationKey, String id, String tooltipId, boolean hasResetButton) {
        this(baseTranslationKey, id, tooltipId, hasResetButton, true);
    }

    public AbstractRow(String baseTranslationKey, String id, String tooltipId, boolean hasResetButton, boolean translate) {
        super(Sizing.fill((int)100), Sizing.fixed((int)26), FlowLayout.Algorithm.HORIZONTAL);
        List rightComponents;
        this.baseTranslationKey = baseTranslationKey;
        this.id = id;
        this.translate = translate;
        this.hoveredSurface(FzmmStyles.DEFAULT_HOVERED);
        Component[] components = this.getComponents(id, tooltipId);
        FlowLayout rowLayout = (FlowLayout)StyledContainers.horizontalFlow(Sizing.fill((int)100), Sizing.fixed((int)22)).child(this.getLabel(id, tooltipId, components.length != 0)).gap(8).alignment(HorizontalAlignment.LEFT, VerticalAlignment.CENTER).margins(Insets.vertical((int)2)).id(AbstractRow.getRowContainerId(id));
        FlowLayout rightComponentsLayout = (FlowLayout)StyledContainers.horizontalFlow(Sizing.content(), Sizing.fill((int)100)).gap(8).verticalAlignment(VerticalAlignment.CENTER).positioning(Positioning.relative((int)100, (int)0)).id(AbstractRow.getRightLayoutId(id));
        for (Component component : components) {
            rightComponentsLayout.child(component);
        }
        if (hasResetButton) {
            rightComponentsLayout.child(this.getResetButton(id));
        }
        if (!(rightComponents = rightComponentsLayout.children()).isEmpty()) {
            ((Component)rightComponents.get(rightComponents.size() - 1)).margins(Insets.right((int)20));
        }
        this.child((Component)rowLayout.child((Component)rightComponentsLayout));
    }

    public abstract Component[] getComponents(String var1, String var2);

    public Component getResetButton(String id) {
        return Components.button((class_2561)class_2561.method_43471((String)"fzmm.gui.button.reset"), buttonComponent -> {}).id(AbstractRow.getResetButtonId(id));
    }

    public Component getLabel(String id, String tooltipId, boolean isOption) {
        String baseTranslationKey = isOption ? BaseFzmmScreen.getOptionBaseTranslationKey(this.baseTranslationKey) : BaseFzmmScreen.getTabTranslationKey(this.baseTranslationKey);
        return AbstractRow.getLabel(id, tooltipId, baseTranslationKey, this.translate);
    }

    public static Component getLabel(String id, String tooltipId, String baseTranslationKey, boolean translate) {
        LabelComponent label = (LabelComponent)StyledComponents.label((class_2561)(translate ? class_2561.method_43471((String)(baseTranslationKey + id)) : class_2561.method_43470((String)id))).margins(Insets.left((int)20)).id(AbstractRow.getLabelId(id));
        if (translate) {
            label.tooltip((class_2561)class_2561.method_43471((String)(baseTranslationKey + tooltipId + ".tooltip")));
        }
        return label;
    }

    public static String getRowContainerId(String id) {
        return id + "-row";
    }

    public static String getResetButtonId(String id) {
        return id + "-reset-button";
    }

    public static String getLabelId(String id) {
        return id + "-label";
    }

    public static String getRightLayoutId(String id) {
        return id + "-right-layout";
    }

    public static String getId(Element element) {
        return AbstractRow.getId(element, "id");
    }

    public static String getId(Element element, String id) {
        return UIParsing.parseText((Element)((Element)UIParsing.childElements((Element)element).get(id))).getString();
    }

    public static String getTooltipId(Element element, String defaultValue) {
        return AbstractRow.getTooltipId(element, defaultValue, "tooltipId");
    }

    public static String getTooltipId(Element element, String defaultValue, String id) {
        boolean containsTooltipId = UIParsing.childElements((Element)element).containsKey(id);
        return containsTooltipId ? UIParsing.parseText((Element)((Element)UIParsing.childElements((Element)element).get(id))).getString() : defaultValue;
    }

    public void removeResetButton() {
        FlowLayout rightLayout = (FlowLayout)this.childById(FlowLayout.class, AbstractRow.getRightLayoutId(this.id));
        if (rightLayout == null) {
            return;
        }
        ButtonComponent resetButton = (ButtonComponent)rightLayout.childById(ButtonComponent.class, AbstractRow.getResetButtonId(this.id));
        if (resetButton == null) {
            return;
        }
        rightLayout.removeChild((Component)resetButton);
    }

    public void removeHorizontalMargins() {
        LabelComponent label;
        Optional<FlowLayout> rightLayoutOptional = this.getRightLayout();
        if (rightLayoutOptional.isPresent() && !rightLayoutOptional.get().children().isEmpty()) {
            List rightLayoutChildren = rightLayoutOptional.get().children();
            Component lastElement = (Component)rightLayoutChildren.get(rightLayoutChildren.size() - 1);
            Insets previousMargins = (Insets)lastElement.margins().get();
            lastElement.margins(previousMargins.withRight(0));
        }
        if ((label = (LabelComponent)this.childById(LabelComponent.class, AbstractRow.getLabelId(this.id))) != null) {
            label.margins(Insets.left((int)0));
        }
    }

    public Optional<FlowLayout> getRightLayout() {
        return Optional.ofNullable((FlowLayout)this.childById(FlowLayout.class, AbstractRow.getRightLayoutId(this.id)));
    }

    public Optional<FlowLayout> getRowContainer() {
        return Optional.ofNullable((FlowLayout)this.childById(FlowLayout.class, AbstractRow.getRowContainerId(this.id)));
    }

    protected String getId() {
        return this.id;
    }
}

