/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.banner_editor.tabs;

import fzmm.zailer.me.builders.BannerBuilder;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.banner_editor.BannerEditorScreen;
import fzmm.zailer.me.client.gui.banner_editor.tabs.IBannerEditorTab;
import fzmm.zailer.me.client.gui.components.style.StyledComponents;
import fzmm.zailer.me.client.gui.components.style.component.StyledItemComponent;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.Sizing;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_9307;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractModifyPatternsTab
implements IBannerEditorTab {
    protected FlowLayout patternsLayout;

    @Override
    public void setupComponents(FlowLayout rootComponent) {
        this.patternsLayout = (FlowLayout)rootComponent.childById(FlowLayout.class, this.getGridId());
        BaseFzmmScreen.checkNull((Component)this.patternsLayout, "flow-layout", this.getGridId());
    }

    protected abstract String getGridId();

    public abstract boolean shouldAddBase();

    @Override
    public void update(BannerEditorScreen parent, BannerBuilder currentBanner, class_1767 color) {
        this.patternsLayout.clearChildren();
        ArrayList<Component> bannerList = new ArrayList<Component>();
        BannerBuilder builder = currentBanner.copy().clearPatterns();
        List<class_9307.class_9308> layers = currentBanner.layers();
        if (this.shouldAddBase()) {
            this.addPreview(parent, currentBanner, color, null, builder, bannerList);
        }
        for (class_9307.class_9308 layer : layers) {
            builder.addLayer(layer);
            this.addPreview(parent, currentBanner, color, layer, builder, bannerList);
        }
        this.patternsLayout.children(bannerList);
    }

    private void addPreview(BannerEditorScreen parent, BannerBuilder currentBanner, class_1767 color, @Nullable class_9307.class_9308 layer, BannerBuilder builder, List<Component> bannerList) {
        StyledItemComponent itemComponent = StyledComponents.item(builder.copy().get());
        itemComponent.sizing(Sizing.fixed((int)32), Sizing.fixed((int)32));
        this.onItemComponentCreated(parent, itemComponent, layer, currentBanner, color);
        itemComponent.cursorStyle(CursorStyle.HAND);
        class_2561 tooltip = this.getTooltip(layer, itemComponent.stack().method_7909());
        itemComponent.tooltip(tooltip);
        bannerList.add((Component)itemComponent);
    }

    protected abstract void onItemComponentCreated(BannerEditorScreen var1, ItemComponent var2, @Nullable class_9307.class_9308 var3, BannerBuilder var4, class_1767 var5);

    protected class_2561 getTooltip(@Nullable class_9307.class_9308 layer, class_1792 item) {
        if (layer == null) {
            return class_2561.method_43471((String)("block.minecraft.banner.base." + BannerBuilder.baseBannerColor(item).method_7792()));
        }
        return BannerBuilder.tooltipOf(layer);
    }
}

