/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui.banner_editor;

import fzmm.zailer.me.builders.BannerBuilder;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.banner_editor.tabs.BannerEditorTabs;
import fzmm.zailer.me.client.gui.banner_editor.tabs.IBannerEditorTab;
import fzmm.zailer.me.client.gui.components.BooleanButton;
import fzmm.zailer.me.client.gui.components.row.BooleanRow;
import fzmm.zailer.me.client.gui.components.row.ButtonRow;
import fzmm.zailer.me.client.gui.components.row.ScreenTabRow;
import fzmm.zailer.me.client.gui.components.style.StyledContainers;
import fzmm.zailer.me.client.gui.components.style.container.StyledFlowLayout;
import fzmm.zailer.me.client.gui.utils.select_item.RequestedItem;
import fzmm.zailer.me.client.gui.utils.select_item.SelectItemScreen;
import fzmm.zailer.me.utils.FzmmUtils;
import fzmm.zailer.me.utils.ItemUtils;
import io.wispforest.owo.ui.component.BoxComponent;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayDeque;
import java.util.ArrayList;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1819;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class BannerEditorScreen
extends BaseFzmmScreen {
    private static final String BANNER_PREVIEW_ID = "banner-preview";
    private static final String COLOR_LAYOUT_ID = "color-layout";
    private static final String GIVE_BUTTON_ID = "give-button";
    private static final String SELECT_BANNER_BUTTON_ID = "select-banner-button";
    private static final String IS_SHIELD_ID = "isShield";
    private static final String CONTENT_ID = "content";
    private static final String UNDO_BUTTON_ID = "undo";
    private static final String REDO_BUTTON_ID = "redo";
    private static BannerEditorTabs selectedTab = BannerEditorTabs.ADD_PATTERNS;
    private ItemComponent bannerPreview;
    private BooleanButton isShieldButton;
    private BannerBuilder bannerBuilder;
    private class_1767 selectedColor;
    private ButtonComponent undoButton;
    private ButtonComponent redoButton;
    private ArrayDeque<BannerBuilder> undoArray;
    private ArrayDeque<BannerBuilder> redoArray;

    public BannerEditorScreen(@Nullable class_437 parent) {
        super("banner_editor", "bannerEditor", parent);
    }

    @Override
    protected void setup(FlowLayout rootComponent) {
        class_1767[] dyeColorsInOrder;
        this.bannerPreview = (ItemComponent)rootComponent.childById(ItemComponent.class, BANNER_PREVIEW_ID);
        BannerEditorScreen.checkNull((Component)this.bannerPreview, "flow-layout", BANNER_PREVIEW_ID);
        this.bannerBuilder = BannerBuilder.of(class_1802.field_8539.method_7854());
        ButtonComponent giveButton = (ButtonComponent)rootComponent.childById(ButtonComponent.class, GIVE_BUTTON_ID);
        BannerEditorScreen.checkNull((Component)giveButton, "button", GIVE_BUTTON_ID);
        giveButton.onPress(buttonComponent -> ItemUtils.give(this.bannerBuilder.get()));
        ButtonComponent selectBannerButton = (ButtonComponent)rootComponent.childById(ButtonComponent.class, SELECT_BANNER_BUTTON_ID);
        BannerEditorScreen.checkNull((Component)selectBannerButton, "button", SELECT_BANNER_BUTTON_ID);
        selectBannerButton.onPress(buttonComponent -> this.selectBanner());
        this.undoArray = new ArrayDeque();
        this.undoButton = (ButtonComponent)rootComponent.childById(ButtonComponent.class, UNDO_BUTTON_ID);
        BannerEditorScreen.checkNull((Component)this.undoButton, "button", UNDO_BUTTON_ID);
        this.undoButton.onPress(buttonComponent -> this.undo());
        this.redoArray = new ArrayDeque();
        this.redoButton = (ButtonComponent)rootComponent.childById(ButtonComponent.class, REDO_BUTTON_ID);
        BannerEditorScreen.checkNull((Component)this.redoButton, "button", REDO_BUTTON_ID);
        this.redoButton.onPress(buttonComponent -> this.redo());
        this.clearUndo();
        FlowLayout contentLayout = (FlowLayout)rootComponent.childById(FlowLayout.class, CONTENT_ID);
        BannerEditorScreen.checkNull((Component)contentLayout, "flow-layout", CONTENT_ID);
        FlowLayout colorLayout = (FlowLayout)rootComponent.childById(FlowLayout.class, COLOR_LAYOUT_ID);
        BannerEditorScreen.checkNull((Component)colorLayout, "flow-layout", COLOR_LAYOUT_ID);
        ArrayList<StyledFlowLayout> colorList = new ArrayList<StyledFlowLayout>();
        for (class_1767 class_17672 : dyeColorsInOrder = FzmmUtils.getDyeColorsInOrder()) {
            BoxComponent colorBox = Components.box((Sizing)Sizing.fixed((int)16), (Sizing)Sizing.fixed((int)16));
            colorBox.margins(Insets.of((int)1));
            colorBox.color(Color.ofRgb((int)class_17672.method_7787()));
            colorBox.fill(true);
            colorBox.cursorStyle(CursorStyle.HAND);
            StyledFlowLayout colorSelectedLayout = StyledContainers.horizontalFlow(Sizing.fixed((int)18), Sizing.fixed((int)18));
            colorSelectedLayout.padding(Insets.of((int)1));
            colorSelectedLayout.alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
            colorBox.mouseDown().subscribe((mouseX, mouseY, button) -> {
                this.selectedColor = dyeColor;
                this.updatePreview(this.bannerBuilder, false);
                for (Component component : colorList) {
                    if (!(component instanceof FlowLayout)) continue;
                    FlowLayout layout = (FlowLayout)component;
                    layout.surface(Surface.BLANK);
                }
                colorSelectedLayout.surface(Surface.outline((int)-1));
                return true;
            });
            colorSelectedLayout.child((Component)colorBox);
            colorList.add(colorSelectedLayout);
        }
        this.selectedColor = dyeColorsInOrder[0];
        colorLayout.children(colorList);
        this.setTabs(selectedTab);
        ScreenTabRow.setup(rootComponent, "tabs", selectedTab);
        for (BannerEditorTabs bannerEditorTabs : BannerEditorTabs.values()) {
            IBannerEditorTab tab = this.getTab(bannerEditorTabs, IBannerEditorTab.class);
            tab.setupComponents(rootComponent);
            ButtonRow.setup(rootComponent, ScreenTabRow.getScreenTabButtonId(tab), !tab.getId().equals(selectedTab.getId()), button -> {
                selectedTab = this.selectScreenTab(rootComponent, tab, selectedTab);
                this.updatePreview(this.bannerBuilder);
            });
        }
        this.selectScreenTab(rootComponent, selectedTab, selectedTab);
        this.isShieldButton = BooleanRow.setup(rootComponent, IS_SHIELD_ID, false, button -> this.isShieldButtonExecute(this.isShieldButton.enabled(), true));
        this.clearUndo();
        this.updatePreview(this.bannerBuilder);
    }

    private void selectBanner() {
        ArrayList<class_1799> defaultItems = new ArrayList<class_1799>();
        for (class_1767 dye : FzmmUtils.getDyeColorsInOrder()) {
            defaultItems.add(BannerBuilder.getBannerByDye(dye).method_7854());
        }
        defaultItems.add(class_1802.field_8255.method_7854());
        RequestedItem requestedItem = new RequestedItem(itemStack -> itemStack.method_7909() instanceof class_1819 || itemStack.method_7909() instanceof class_1746, itemStack -> {
            if (itemStack.method_7960()) {
                return;
            }
            boolean isShield = itemStack.method_7909() instanceof class_1819;
            if (this.isShieldButton.enabled() != isShield) {
                this.isShieldButton.method_25306();
            }
            this.bannerBuilder = BannerBuilder.of(itemStack);
            this.updatePreview(this.bannerBuilder);
        }, defaultItems, this.bannerBuilder.get(), (class_2561)class_2561.method_43471((String)"fzmm.gui.bannerEditor.option.select.title"), true);
        assert (this.field_22787 != null);
        this.setScreen((class_437)new SelectItemScreen((class_437)this, requestedItem));
    }

    public void updatePreview(BannerBuilder builder) {
        this.updatePreview(builder, true);
    }

    private void updatePreview(BannerBuilder builder, boolean canClearRedo) {
        if (canClearRedo && !this.redoArray.isEmpty()) {
            this.clearRedo();
        }
        this.bannerPreview.stack(builder.get());
        this.getTab(selectedTab, IBannerEditorTab.class).update(this, builder, this.selectedColor);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 90 && (modifiers & 2) != 0 && (modifiers & 1) == 0) {
            this.undo();
            return true;
        }
        if (keyCode == 90 && (modifiers & 2) != 0 && (modifiers & 1) != 0 || keyCode == 89 && (modifiers & 2) != 0) {
            this.redo();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void isShieldButtonExecute(boolean value, boolean canClearRedo) {
        this.isShieldButton.enabledIgnoreCallback(value);
        this.updatePreview(this.bannerBuilder.isShield(value), canClearRedo);
    }

    private void undo() {
        BannerBuilder bannerBuilder;
        BannerBuilder currentBanner = this.bannerBuilder.copy();
        if (this.undoArray.isEmpty()) {
            if (!this.bannerBuilder.layers().isEmpty()) {
                this.bannerBuilder.layers().clear();
                this.updatePreview(this.bannerBuilder);
                this.redoArray.addFirst(currentBanner);
            }
            return;
        }
        this.bannerBuilder = bannerBuilder = this.undoArray.removeFirst();
        this.isShieldButtonExecute(bannerBuilder.isShield(), false);
        this.redoArray.addFirst(currentBanner);
        this.redoButton.field_22763 = true;
        if (this.undoArray.isEmpty() && bannerBuilder.layers().isEmpty()) {
            this.undoButton.field_22763 = false;
        }
    }

    private void redo() {
        if (this.redoArray.isEmpty()) {
            return;
        }
        BannerBuilder bannerBuilder = this.redoArray.removeFirst();
        BannerBuilder currentBanner = this.bannerBuilder.copy();
        this.bannerBuilder = bannerBuilder;
        this.isShieldButtonExecute(bannerBuilder.isShield(), false);
        this.undoArray.addFirst(currentBanner);
        this.undoButton.field_22763 = true;
        if (this.redoArray.isEmpty()) {
            this.redoButton.field_22763 = false;
        }
    }

    public void addUndo(BannerBuilder bannerBuilder) {
        this.undoArray.addFirst(bannerBuilder.copy());
        if (this.undoArray.size() > FzmmClient.CONFIG.itemEditorBanner.maxUndo()) {
            this.undoArray.removeLast();
        }
        this.redoArray.clear();
        this.redoButton.field_22763 = false;
        this.undoButton.field_22763 = true;
    }

    public void clearUndo() {
        this.undoArray.clear();
        this.undoButton.field_22763 = false;
        this.clearRedo();
    }

    public void clearRedo() {
        this.redoArray.clear();
        this.redoButton.field_22763 = false;
    }
}

