/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui;

import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.row.ButtonRow;
import fzmm.zailer.me.client.gui.components.style.StyledComponents;
import fzmm.zailer.me.client.logic.FzmmHistory;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class HistoryScreen
extends BaseFzmmScreen {
    private static final class_2561 GENERATED_ITEMS_EMPTY_TEXT = class_2561.method_43471((String)"fzmm.gui.history.label.generatedWithFzmm.empty");
    private static final String CONTENT_ID = "content";
    private static final String ITEM_GENERATED_ID = "itemGeneratedWithFzmm";
    private static final String HEAD_GENERATED_ID = "headGeneratedWithFzmm";
    private static final String ERROR_LABEL_ID = "error-label";
    private ButtonComponent itemGenerated;
    private ButtonComponent headGenerated;
    private FlowLayout contentLayout;
    private LabelComponent labelError;

    public HistoryScreen(@Nullable class_437 parent) {
        super("history", "history", parent);
    }

    @Override
    protected void setup(FlowLayout rootComponent) {
        this.contentLayout = (FlowLayout)rootComponent.childById(FlowLayout.class, CONTENT_ID);
        HistoryScreen.checkNull((Component)this.contentLayout, "flow-layout", CONTENT_ID);
        this.itemGenerated = ButtonRow.setup(rootComponent, ITEM_GENERATED_ID, true, this::itemGeneratedExecute);
        this.headGenerated = ButtonRow.setup(rootComponent, HEAD_GENERATED_ID, true, this::headGeneratedExecute);
        this.labelError = (LabelComponent)rootComponent.childById(LabelComponent.class, ERROR_LABEL_ID);
        HistoryScreen.checkNull((Component)this.labelError, "label", ERROR_LABEL_ID);
        this.itemGenerated.method_25306();
    }

    private void itemGeneratedExecute(ButtonComponent button) {
        this.addItems(FzmmHistory.getGeneratedItems());
        this.selectOption(button);
    }

    private void headGeneratedExecute(ButtonComponent button) {
        this.addItems(FzmmHistory.getGeneratedHeads());
        this.selectOption(button);
    }

    private void selectOption(ButtonComponent button) {
        this.itemGenerated.field_22763 = this.itemGenerated != button;
        this.headGenerated.field_22763 = this.headGenerated != button;
    }

    private void addItems(List<class_1799> stackList) {
        this.contentLayout.clearChildren();
        this.contentLayout.children(stackList.stream().map(itemStack -> StyledComponents.itemGive(itemStack)).toList());
        this.labelError.text((class_2561)(stackList.isEmpty() ? GENERATED_ITEMS_EMPTY_TEXT : class_2561.method_43473()));
    }
}

