/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.builders;

import fzmm.zailer.me.client.FzmmClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1819;
import net.minecraft.class_2185;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2582;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9307;
import net.minecraft.class_9323;
import net.minecraft.class_9334;

public class BannerBuilder {
    private final List<class_9307.class_9308> layers = new ArrayList<class_9307.class_9308>();
    private class_1792 item = class_1802.field_8539;
    private boolean isShield = false;

    private BannerBuilder() {
    }

    public static BannerBuilder builder() {
        return new BannerBuilder();
    }

    public static BannerBuilder of(class_1799 stack) {
        stack = stack.method_7972();
        class_9323 components = stack.method_57353();
        List layers = ((class_9307)components.method_57830(class_9334.field_49619, (Object)class_9307.field_49404)).comp_2428();
        class_1767 baseColor = (class_1767)components.method_57830(class_9334.field_49620, null);
        class_1792 item = stack.method_7909();
        boolean isShield = item instanceof class_1819;
        if (baseColor != null) {
            item = BannerBuilder.getBannerByDye(baseColor);
        }
        return BannerBuilder.builder().addLayers(layers).item(item instanceof class_1746 ? item : class_1802.field_8539).isShield(isShield);
    }

    public class_1799 get() {
        class_1799 stack = this.item.method_7854();
        if (this.isShield) {
            stack = class_1802.field_8255.method_7854();
            stack.method_57368(class_9334.field_49620, null, component -> this.baseBannerColor());
        }
        stack.method_57368(class_9334.field_49619, (Object)class_9307.field_49404, component -> new class_9307(new ArrayList<class_9307.class_9308>(this.layers)));
        return stack;
    }

    public BannerBuilder item(class_1792 item) {
        this.item = item;
        return this;
    }

    public BannerBuilder isShield(boolean isShield) {
        this.isShield = isShield;
        return this;
    }

    public boolean isShield() {
        return this.isShield;
    }

    public BannerBuilder addLayer(class_1767 color, class_6880<class_2582> pattern) {
        this.addLayer(new class_9307.class_9308(pattern, color));
        return this;
    }

    public void addLayer(class_9307.class_9308 layer) {
        this.layers.add(layer);
    }

    public BannerBuilder addLayers(List<class_9307.class_9308> layers) {
        this.layers.addAll(layers);
        return this;
    }

    public void removeLayer(class_9307.class_9308 layer) {
        this.layers.remove(layer);
    }

    public void replaceColor(class_9307.class_9308 layer, class_1767 color) {
        int index = this.indexOf(layer);
        if (index != -1) {
            this.layers.set(index, new class_9307.class_9308(layer.comp_2429(), color));
        }
    }

    public int indexOf(class_9307.class_9308 layer) {
        for (int i = 0; i != this.layers.size(); ++i) {
            if (this.layers.get(i) != layer) continue;
            return i;
        }
        return -1;
    }

    public void replaceColors(class_1767 colorToReplace, class_1767 newColor) {
        for (int i = 0; i != this.layers.size(); ++i) {
            if (this.layers.get(i).comp_2430() != colorToReplace) continue;
            this.layers.set(i, new class_9307.class_9308(this.layers.get(i).comp_2429(), newColor));
        }
    }

    public List<class_9307.class_9308> layers() {
        return this.layers;
    }

    public BannerBuilder clearPatterns() {
        this.layers.clear();
        return this;
    }

    public BannerBuilder copy() {
        BannerBuilder copy = BannerBuilder.builder().item(this.item).isShield(this.isShield);
        for (class_9307.class_9308 layer : this.layers) {
            copy.addLayer(new class_9307.class_9308(layer.comp_2429(), layer.comp_2430()));
        }
        return copy;
    }

    public static class_1792 getBannerByDye(class_1767 color) {
        for (class_2248 block : class_7923.field_41175.method_10220().toList()) {
            class_2185 bannerBlock;
            if (!(block instanceof class_2185) || (bannerBlock = (class_2185)block).method_9303() != color) continue;
            return block.method_8389();
        }
        return class_1802.field_8539;
    }

    public void baseBannerColor(class_1767 color) {
        this.item(BannerBuilder.getBannerByDye(color));
    }

    public class_1767 baseBannerColor() {
        return BannerBuilder.baseBannerColor(this.item);
    }

    public static class_1767 baseBannerColor(class_1792 item) {
        if (item instanceof class_1746) {
            class_1746 bannerItem = (class_1746)item;
            return bannerItem.method_7706();
        }
        return class_1767.field_7952;
    }

    public static class_2561 tooltipOf(class_9307.class_9308 layer) {
        Optional<String> patternKeyOptional = layer.comp_2429().method_40230().map(key -> key.method_29177().method_43903());
        if (patternKeyOptional.isEmpty()) {
            FzmmClient.LOGGER.error("[BannerBuilder] No banner pattern translation key found");
            return class_2561.method_43473();
        }
        String dyeId = layer.comp_2430().method_7792();
        return class_2561.method_43471((String)("block.minecraft.banner." + patternKeyOptional.get() + "." + dyeId)).method_27692(class_124.field_1080);
    }
}

