/*
 * Decompiled with CFR 0.152.
 */
package net.yeoxuhang.geodeplus.forge.biome_modifiers.nether.netherrack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.yeoxuhang.geodeplus.common.config.GeodePlusCommonConfigs;
import net.yeoxuhang.geodeplus.common.registry.GeodePlusTagRegistry;

public class AncientDebrisGeodeModifier
implements BiomeModifier {
    private final Holder<PlacedFeature> features;

    public AncientDebrisGeodeModifier(Holder<PlacedFeature> features) {
        this.features = features;
    }

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            this.biomeModificationAddPhase(biome, builder);
        }
    }

    private void biomeModificationAddPhase(Holder<Biome> biome, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (biome.m_203656_(GeodePlusTagRegistry.Biomes.HAS_NETHER_ANCIENT_DEBRIS_GEODE) && !biome.m_203656_(GeodePlusTagRegistry.Biomes.BLACKLIST_BIOMES) && ((Boolean)GeodePlusCommonConfigs.SHOULD_GENERATE_NETHER_ANCIENT_DEBRIS_GEODE.get()).booleanValue()) {
            builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.UNDERGROUND_DECORATION, this.features);
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return AncientDebrisGeodeModifier.makeCodec();
    }

    public static Codec<AncientDebrisGeodeModifier> makeCodec() {
        return RecordCodecBuilder.create(config -> config.group((App)PlacedFeature.f_191773_.fieldOf("feature").forGetter(otherConfig -> otherConfig.features)).apply((Applicative)config, AncientDebrisGeodeModifier::new));
    }
}

