/*
 * Decompiled with CFR 0.152.
 */
package net.yeoxuhang.geodeplus.common.world.feature;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GeodeBlockSettings;
import net.minecraft.world.level.levelgen.GeodeCrackSettings;
import net.minecraft.world.level.levelgen.GeodeLayerSettings;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.GeodeConfiguration;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.material.FluidState;
import net.yeoxuhang.geodeplus.common.registry.GeodePlusTagRegistry;

public class GeodeFeature
extends Feature<GeodeConfiguration> {
    private static final Direction[] DIRECTIONS = Direction.values();

    public GeodeFeature(Codec<GeodeConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<GeodeConfiguration> featurePlaceContext) {
        BlockState blockState;
        int o;
        int n;
        GeodeConfiguration geodeConfiguration = (GeodeConfiguration)featurePlaceContext.m_159778_();
        RandomSource randomSource = featurePlaceContext.m_225041_();
        BlockPos blockPos = featurePlaceContext.m_159777_();
        WorldGenLevel worldGenLevel = featurePlaceContext.m_159774_();
        int i = geodeConfiguration.f_160822_;
        int j = geodeConfiguration.f_160823_;
        LinkedList list = Lists.newLinkedList();
        int k = geodeConfiguration.f_160820_.m_214085_(randomSource);
        WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(worldGenLevel.m_7328_()));
        NormalNoise normalNoise = NormalNoise.m_230504_((RandomSource)worldgenRandom, (int)-4, (double[])new double[]{1.0});
        LinkedList list2 = Lists.newLinkedList();
        double d = (double)k / (double)geodeConfiguration.f_160819_.m_142737_();
        GeodeLayerSettings geodeLayerSettings = geodeConfiguration.f_160814_;
        GeodeBlockSettings geodeBlockSettings = geodeConfiguration.f_160813_;
        GeodeCrackSettings geodeCrackSettings = geodeConfiguration.f_160815_;
        double e = 1.0 / Math.sqrt(geodeLayerSettings.f_158342_);
        double f = 1.0 / Math.sqrt(geodeLayerSettings.f_158343_ + d);
        double g = 1.0 / Math.sqrt(geodeLayerSettings.f_158344_ + d);
        double h = 1.0 / Math.sqrt(geodeLayerSettings.f_158345_ + d);
        double l = 1.0 / Math.sqrt(geodeCrackSettings.f_158326_ + randomSource.m_188500_() / 2.0 + (k > 3 ? d : 0.0));
        boolean bl = (double)randomSource.m_188501_() < geodeCrackSettings.f_158325_;
        int m = 0;
        for (n = 0; n < k; ++n) {
            int q;
            int p;
            o = geodeConfiguration.f_160819_.m_214085_(randomSource);
            BlockPos blockPos2 = blockPos.m_7918_(o, p = geodeConfiguration.f_160819_.m_214085_(randomSource), q = geodeConfiguration.f_160819_.m_214085_(randomSource));
            blockState = worldGenLevel.m_8055_(blockPos2);
            if ((blockState.m_60795_() || blockState.m_204336_(GeodePlusTagRegistry.Blocks.GEODE_INVALID_BLOCKS)) && ++m > geodeConfiguration.f_160825_) {
                return false;
            }
            list.add(Pair.of((Object)blockPos2, (Object)geodeConfiguration.f_160821_.m_214085_(randomSource)));
        }
        if (bl) {
            n = randomSource.m_188503_(4);
            o = k * 2 + 1;
            if (n == 0) {
                list2.add(blockPos.m_7918_(o, 7, 0));
                list2.add(blockPos.m_7918_(o, 5, 0));
                list2.add(blockPos.m_7918_(o, 1, 0));
            } else if (n == 1) {
                list2.add(blockPos.m_7918_(0, 7, o));
                list2.add(blockPos.m_7918_(0, 5, o));
                list2.add(blockPos.m_7918_(0, 1, o));
            } else if (n == 2) {
                list2.add(blockPos.m_7918_(o, 7, o));
                list2.add(blockPos.m_7918_(o, 5, o));
                list2.add(blockPos.m_7918_(o, 1, o));
            } else {
                list2.add(blockPos.m_7918_(0, 7, 0));
                list2.add(blockPos.m_7918_(0, 5, 0));
                list2.add(blockPos.m_7918_(0, 1, 0));
            }
        }
        ArrayList list3 = Lists.newArrayList();
        Predicate predicate = GeodeFeature.m_204735_((TagKey)geodeConfiguration.f_160813_.f_158293_);
        Iterator var48 = BlockPos.m_121940_((BlockPos)blockPos.m_7918_(i, i, i), (BlockPos)blockPos.m_7918_(j, j, j)).iterator();
        block1: while (true) {
            if (!var48.hasNext()) {
                List list4 = geodeBlockSettings.f_158292_;
                block2: for (BlockPos blockPos2 : list3) {
                    blockState = (BlockState)Util.m_214621_((List)list4, (RandomSource)randomSource);
                    for (Direction direction2 : DIRECTIONS) {
                        if (blockState.m_61138_((Property)BlockStateProperties.f_61372_)) {
                            blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)direction2);
                        }
                        BlockPos blockPos6 = blockPos2.m_121945_(direction2);
                        BlockState blockState2 = worldGenLevel.m_8055_(blockPos6);
                        if (blockState.m_61138_((Property)BlockStateProperties.f_61362_)) {
                            blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(blockState2.m_60819_().m_76170_()));
                        }
                        if (!GeodeFeature.canClusterGrowAtState(blockState2)) continue;
                        this.m_159742_(worldGenLevel, blockPos6, blockState, predicate);
                        continue block2;
                    }
                }
                return true;
            }
            BlockPos blockPos3 = (BlockPos)var48.next();
            double r = normalNoise.m_75380_((double)blockPos3.m_123341_(), (double)blockPos3.m_123342_(), (double)blockPos3.m_123343_()) * geodeConfiguration.f_160824_;
            double s = 0.0;
            double t = 0.0;
            for (Pair pair : list) {
                s += Mth.m_14193_((double)(blockPos3.m_123331_((Vec3i)pair.getFirst()) + (double)((Integer)pair.getSecond()).intValue())) + r;
            }
            for (BlockPos blockPos4 : list2) {
                t += Mth.m_14193_((double)(blockPos3.m_123331_((Vec3i)blockPos4) + (double)geodeCrackSettings.f_158327_)) + r;
            }
            if (s < h) continue;
            if (bl && t >= l && s < e) {
                this.m_159742_(worldGenLevel, blockPos3, Blocks.f_50016_.m_49966_(), predicate);
                Direction[] var56 = DIRECTIONS;
                int var59 = var56.length;
                int var42 = 0;
                while (true) {
                    if (var42 >= var59) continue block1;
                    Direction direction = var56[var42];
                    BlockPos blockPos5 = blockPos3.m_121945_(direction);
                    FluidState fluidState = worldGenLevel.m_6425_(blockPos5);
                    if (!fluidState.m_76178_()) {
                        worldGenLevel.m_186469_(blockPos5, fluidState.m_76152_(), 0);
                    }
                    ++var42;
                }
            }
            if (s >= e) {
                this.m_159742_(worldGenLevel, blockPos3, geodeBlockSettings.f_158287_.m_213972_(randomSource, blockPos3), predicate);
                continue;
            }
            if (s >= f) {
                boolean bl2;
                boolean bl3 = bl2 = (double)randomSource.m_188501_() < geodeConfiguration.f_160817_;
                if (bl2) {
                    this.m_159742_(worldGenLevel, blockPos3, geodeBlockSettings.f_158289_.m_213972_(randomSource, blockPos3), predicate);
                } else {
                    this.m_159742_(worldGenLevel, blockPos3, geodeBlockSettings.f_158288_.m_213972_(randomSource, blockPos3), predicate);
                }
                if (geodeConfiguration.f_160818_ && !bl2 || !((double)randomSource.m_188501_() < geodeConfiguration.f_160816_)) continue;
                list3.add(blockPos3.m_7949_());
                continue;
            }
            if (s >= g) {
                this.m_159742_(worldGenLevel, blockPos3, geodeBlockSettings.f_158290_.m_213972_(randomSource, blockPos3), predicate);
                continue;
            }
            if (!(s >= h)) continue;
            this.m_159742_(worldGenLevel, blockPos3, geodeBlockSettings.f_158291_.m_213972_(randomSource, blockPos3), predicate);
        }
    }

    public static boolean canClusterGrowAtState(BlockState blockState) {
        return blockState.m_60795_() || blockState.m_60713_(Blocks.f_49990_) && blockState.m_60819_().m_76186_() == 8;
    }
}

