/*
 * Decompiled with CFR 0.152.
 */
package net.yeoxuhang.geodeplus.common.registry;

import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.yeoxuhang.geodeplus.common.registry.GeodePlusItemsRegistry;

public class GeodePlusTrimMaterialsAndPatternsRegistry {
    public static final ResourceKey<TrimMaterial> WRAPPIST = GeodePlusTrimMaterialsAndPatternsRegistry.createTrimMaterial("wrappist");
    public static final ResourceKey<TrimMaterial> CELESTITE = GeodePlusTrimMaterialsAndPatternsRegistry.createTrimMaterial("celestite");
    public static final ResourceKey<TrimMaterial> PINK_TOPAZ = GeodePlusTrimMaterialsAndPatternsRegistry.createTrimMaterial("pink_topaz");
    public static final ResourceKey<TrimPattern> WRAP = GeodePlusTrimMaterialsAndPatternsRegistry.createTrimPattern("wrap");
    public static final ResourceKey<TrimPattern> CELESTE = GeodePlusTrimMaterialsAndPatternsRegistry.createTrimPattern("celeste");
    public static final ResourceKey<TrimPattern> HEART = GeodePlusTrimMaterialsAndPatternsRegistry.createTrimPattern("heart");

    public static void createMaterials(BootstapContext<TrimMaterial> bootstapContext) {
        GeodePlusTrimMaterialsAndPatternsRegistry.createMaterial(bootstapContext, WRAPPIST, GeodePlusItemsRegistry.WRAPPIST_SHARD.get(), Style.f_131099_.m_178520_(6201294), 0.9f);
        GeodePlusTrimMaterialsAndPatternsRegistry.createMaterial(bootstapContext, CELESTITE, GeodePlusItemsRegistry.CELESTITE_SHARD.get(), Style.f_131099_.m_178520_(11719671), 0.8f);
        GeodePlusTrimMaterialsAndPatternsRegistry.createMaterial(bootstapContext, PINK_TOPAZ, GeodePlusItemsRegistry.PINK_TOPAZ.get(), Style.f_131099_.m_178520_(16496615), 0.1f);
    }

    public static void createPatterns(BootstapContext<TrimPattern> bootstapContext) {
        GeodePlusTrimMaterialsAndPatternsRegistry.createPattern(bootstapContext, GeodePlusItemsRegistry.WRAP_ARMOR_TRIM_SMITHING_TEMPLATE.get(), WRAP);
        GeodePlusTrimMaterialsAndPatternsRegistry.createPattern(bootstapContext, GeodePlusItemsRegistry.CELESTE_ARMOR_TRIM_SMITHING_TEMPLATE.get(), CELESTE);
        GeodePlusTrimMaterialsAndPatternsRegistry.createPattern(bootstapContext, GeodePlusItemsRegistry.HEART_ARMOR_TRIM_SMITHING_TEMPLATE.get(), HEART);
    }

    private static void createMaterial(BootstapContext<TrimMaterial> bootstapContext, ResourceKey<TrimMaterial> resourceKey, Item item, Style style, float f) {
        GeodePlusTrimMaterialsAndPatternsRegistry.createMaterial(bootstapContext, resourceKey, item, style, f, Map.of());
    }

    private static void createMaterial(BootstapContext<TrimMaterial> bootstapContext, ResourceKey<TrimMaterial> resourceKey, Item item, Style style, float f, Map<ArmorMaterials, String> map) {
        TrimMaterial trimMaterial = TrimMaterial.m_267605_((String)resourceKey.m_135782_().m_135815_(), (Item)item, (float)f, (Component)Component.m_237115_((String)Util.m_137492_((String)"trim_material", (ResourceLocation)resourceKey.m_135782_())).m_130948_(style), map);
        bootstapContext.m_255272_(resourceKey, (Object)trimMaterial);
    }

    private static void createPattern(BootstapContext<TrimPattern> bootstapContext, Item item, ResourceKey<TrimPattern> resourceKey) {
        TrimPattern trimPattern = new TrimPattern(resourceKey.m_135782_(), BuiltInRegistries.f_257033_.m_263177_((Object)item), (Component)Component.m_237115_((String)Util.m_137492_((String)"trim_pattern", (ResourceLocation)resourceKey.m_135782_())));
        bootstapContext.m_255272_(resourceKey, (Object)trimPattern);
    }

    private static ResourceKey<TrimMaterial> createTrimMaterial(String string) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_266076_, (ResourceLocation)new ResourceLocation("geode_plus", string));
    }

    private static ResourceKey<TrimPattern> createTrimPattern(String string) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_266063_, (ResourceLocation)new ResourceLocation("geode_plus", string));
    }

    public static void init() {
    }
}

