/*
 * Decompiled with CFR 0.152.
 */
package net.yeoxuhang.geodeplus.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.yeoxuhang.geodeplus.common.block.entity.WrappistPedestalBlockEntity;
import net.yeoxuhang.geodeplus.common.registry.GeodePlusBlocksRegistry;
import net.yeoxuhang.geodeplus.common.registry.GeodePlusTagRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrappistPedestalBlock
extends BaseEntityBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);

    public WrappistPedestalBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public boolean mayPlaceOn(BlockState groundState, BlockGetter worldIn, BlockPos pos) {
        return !groundState.m_60713_((Block)GeodePlusBlocksRegistry.WRAPPIST_PEDESTAL.get()) || groundState.m_204336_(GeodePlusTagRegistry.Blocks.WRAPPIST_PEDESTAL_CANNOT_PLACE_ON);
    }

    public boolean m_7898_(BlockState state, LevelReader levelReader, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState groundState = levelReader.m_8055_(blockpos);
        return this.mayPlaceOn(groundState, (BlockGetter)levelReader, blockpos);
    }

    public InteractionResult m_6227_(@NotNull BlockState state, Level worldIn, @NotNull BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(handIn);
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof WrappistPedestalBlockEntity) {
            WrappistPedestalBlockEntity wrappistPedestalBlock = (WrappistPedestalBlockEntity)blockEntity;
            if (!player.m_6144_() && heldItem.m_41720_() != this.m_5456_()) {
                ItemStack stack = heldItem.m_41777_();
                stack.m_41764_(1);
                if (wrappistPedestalBlock.m_8020_(0).m_41619_()) {
                    wrappistPedestalBlock.m_6836_(0, stack);
                    if (!player.m_7500_()) {
                        heldItem.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (wrappistPedestalBlock.m_8020_(0).m_150930_(stack.m_41720_()) && wrappistPedestalBlock.m_8020_(0).m_41741_() > wrappistPedestalBlock.m_8020_(0).m_41613_() + stack.m_41613_()) {
                    wrappistPedestalBlock.m_8020_(0).m_41769_(1);
                    if (!player.m_7500_()) {
                        heldItem.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                WrappistPedestalBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)wrappistPedestalBlock.m_8020_(0).m_41777_());
                wrappistPedestalBlock.m_6836_(0, ItemStack.f_41583_);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new WrappistPedestalBlockEntity(pos, state);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof WrappistPedestalBlockEntity) {
            Containers.m_19002_((Level)worldIn, (BlockPos)pos, (Container)((WrappistPedestalBlockEntity)tileentity));
            worldIn.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }
}

