/*
 * Decompiled with CFR 0.152.
 */
package net.yeoxuhang.geodeplus.common.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.yeoxuhang.geodeplus.common.registry.GeodePlusBlocksRegistry;

public class RedstoneOresClusterBlock
extends RedStoneOreBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static BooleanProperty LIT = RedstoneTorchBlock.f_55674_;
    protected final VoxelShape northAabb;
    protected final VoxelShape southAabb;
    protected final VoxelShape eastAabb;
    protected final VoxelShape westAabb;
    protected final VoxelShape upAabb;
    protected final VoxelShape downAabb;

    public RedstoneOresClusterBlock(int box, int i, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.UP));
        this.upAabb = Block.m_49796_((double)i, (double)0.0, (double)i, (double)(16 - i), (double)box, (double)(16 - i));
        this.downAabb = Block.m_49796_((double)i, (double)(16 - box), (double)i, (double)(16 - i), (double)16.0, (double)(16 - i));
        this.northAabb = Block.m_49796_((double)i, (double)i, (double)(16 - box), (double)(16 - i), (double)(16 - i), (double)16.0);
        this.southAabb = Block.m_49796_((double)i, (double)i, (double)0.0, (double)(16 - i), (double)(16 - i), (double)box);
        this.eastAabb = Block.m_49796_((double)0.0, (double)i, (double)i, (double)box, (double)(16 - i), (double)(16 - i));
        this.westAabb = Block.m_49796_((double)(16 - box), (double)i, (double)i, (double)16.0, (double)(16 - i), (double)(16 - i));
    }

    public VoxelShape m_5940_(BlockState p_152021_, BlockGetter p_152022_, BlockPos p_152023_, CollisionContext p_152024_) {
        Direction direction = (Direction)p_152021_.m_61143_((Property)FACING);
        switch (direction) {
            case NORTH: {
                return this.northAabb;
            }
            case SOUTH: {
                return this.southAabb;
            }
            case EAST: {
                return this.eastAabb;
            }
            case WEST: {
                return this.westAabb;
            }
            case DOWN: {
                return this.downAabb;
            }
        }
        return this.upAabb;
    }

    public void m_6256_(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        RedstoneOresClusterBlock.interact(blockState, level, blockPos);
        super.m_6256_(blockState, level, blockPos, player);
    }

    public void m_141947_(Level level, BlockPos blockPos, BlockState blockState, Entity entity) {
        if (!entity.m_20161_()) {
            RedstoneOresClusterBlock.interact(blockState, level, blockPos);
        }
        super.m_141947_(level, blockPos, blockState, entity);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (level.f_46443_) {
            RedstoneOresClusterBlock.spawnParticles(level, blockPos);
        } else {
            RedstoneOresClusterBlock.interact(blockState, level, blockPos);
        }
        ItemStack itemStack = player.m_21120_(interactionHand);
        return itemStack.m_41720_() instanceof BlockItem && new BlockPlaceContext(player, interactionHand, itemStack, blockHitResult).m_7059_() ? InteractionResult.PASS : InteractionResult.SUCCESS;
    }

    private static void interact(BlockState blockState, Level level, BlockPos blockPos) {
        RedstoneOresClusterBlock.spawnParticles(level, blockPos);
        if (!((Boolean)blockState.m_61143_((Property)LIT)).booleanValue()) {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public boolean m_6724_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)LIT);
    }

    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)blockState.m_61143_((Property)LIT)).booleanValue()) {
            serverLevel.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)blockState.m_61143_((Property)LIT)).booleanValue()) {
            RedstoneOresClusterBlock.spawnParticles(level, blockPos);
        }
    }

    private static void spawnParticles(Level level, BlockPos blockPos) {
        double d = 0.5625;
        RandomSource randomSource = level.f_46441_;
        for (Direction direction : Direction.values()) {
            BlockPos blockPos2 = blockPos.m_121945_(direction);
            if (level.m_8055_(blockPos2).m_60804_((BlockGetter)level, blockPos2)) continue;
            Direction.Axis axis = direction.m_122434_();
            double e = axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.m_122429_() : (double)randomSource.m_188501_();
            double f = axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.m_122430_() : (double)randomSource.m_188501_();
            double g = axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.m_122431_() : (double)randomSource.m_188501_();
            level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, (double)blockPos.m_123341_() + e, (double)blockPos.m_123342_() + f, (double)blockPos.m_123343_() + g, 0.0, 0.0, 0.0);
        }
    }

    public void m_213646_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, ItemStack itemStack, boolean bl) {
        int i;
        super.m_213646_(blockState, serverLevel, blockPos, itemStack, bl);
        if (bl && !EnchantmentHelper.m_272262_((ItemStack)itemStack) && blockState.m_60713_((Block)GeodePlusBlocksRegistry.SMALL_REDSTONE_BUD.get())) {
            i = 1;
            this.m_49805_(serverLevel, blockPos, i);
        }
        if (bl && !EnchantmentHelper.m_272262_((ItemStack)itemStack) && blockState.m_60713_((Block)GeodePlusBlocksRegistry.MEDIUM_REDSTONE_BUD.get())) {
            i = 1 + serverLevel.f_46441_.m_188503_(2);
            this.m_49805_(serverLevel, blockPos, i);
        }
        if (bl && !EnchantmentHelper.m_272262_((ItemStack)itemStack) && blockState.m_60713_((Block)GeodePlusBlocksRegistry.LARGE_REDSTONE_BUD.get())) {
            i = 1 + serverLevel.f_46441_.m_188503_(5);
            this.m_49805_(serverLevel, blockPos, i);
        }
        if (bl && !EnchantmentHelper.m_272262_((ItemStack)itemStack) && blockState.m_60713_((Block)GeodePlusBlocksRegistry.REDSTONE_CRYSTAL.get())) {
            i = 1 + serverLevel.f_46441_.m_188503_(10);
            this.m_49805_(serverLevel, blockPos, i);
        }
    }

    public boolean m_7898_(BlockState p_152026_, LevelReader p_152027_, BlockPos p_152028_) {
        Direction direction = (Direction)p_152026_.m_61143_((Property)FACING);
        BlockPos blockpos = p_152028_.m_121945_(direction.m_122424_());
        return p_152027_.m_8055_(blockpos).m_60783_((BlockGetter)p_152027_, blockpos, direction);
    }

    public BlockState m_7417_(BlockState p_152036_, Direction p_152037_, BlockState p_152038_, LevelAccessor p_152039_, BlockPos p_152040_, BlockPos p_152041_) {
        if (((Boolean)p_152036_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            p_152039_.m_186469_(p_152040_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)p_152039_));
        }
        return p_152037_ == ((Direction)p_152036_.m_61143_((Property)FACING)).m_122424_() && !p_152036_.m_60710_((LevelReader)p_152039_, p_152040_) ? Blocks.f_50016_.m_49966_() : super.m_7417_(p_152036_, p_152037_, p_152038_, p_152039_, p_152040_, p_152041_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_152019_) {
        Level levelaccessor = p_152019_.m_43725_();
        BlockPos blockpos = p_152019_.m_8083_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.m_6425_(blockpos).m_76152_() == Fluids.f_76193_))).m_61124_((Property)FACING, (Comparable)p_152019_.m_43719_());
    }

    public BlockState m_6843_(BlockState p_152033_, Rotation p_152034_) {
        return (BlockState)p_152033_.m_61124_((Property)FACING, (Comparable)p_152034_.m_55954_((Direction)p_152033_.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState p_152030_, Mirror p_152031_) {
        return p_152030_.m_60717_(p_152031_.m_54846_((Direction)p_152030_.m_61143_((Property)FACING)));
    }

    public FluidState m_5888_(BlockState p_152045_) {
        return (Boolean)p_152045_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_152045_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_152043_) {
        p_152043_.m_61104_(new Property[]{WATERLOGGED, FACING, LIT});
    }

    public PushReaction getPistonPushReaction(BlockState p_152047_) {
        return PushReaction.DESTROY;
    }
}

