/*
 * Decompiled with CFR 0.152.
 */
package net.yeoxuhang.geodeplus.common.block;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.Vec3;
import net.yeoxuhang.geodeplus.common.block.PinkTopazCrystalBlock;
import net.yeoxuhang.geodeplus.common.config.GeodePlusCommonConfigs;
import net.yeoxuhang.geodeplus.common.registry.GeodePlusBlocksRegistry;

public class BuddingPinkTopazBlock
extends AmethystBlock {
    public static final int GROWTH_CHANCE = 5;
    private static final Direction[] DIRECTIONS = Direction.values();

    public BuddingPinkTopazBlock(BlockBehaviour.Properties p_152726_) {
        super(p_152726_);
    }

    public PushReaction getPistonPushReaction(BlockState p_152733_) {
        return PushReaction.DESTROY;
    }

    public void m_213898_(BlockState p_220898_, ServerLevel p_220899_, BlockPos p_220900_, RandomSource p_220901_) {
        if (p_220901_.m_188503_(20) == 0) {
            Direction direction = DIRECTIONS[p_220901_.m_188503_(DIRECTIONS.length)];
            BlockPos blockpos = p_220900_.m_121945_(direction);
            BlockState blockstate = p_220899_.m_8055_(blockpos);
            Block block = null;
            if (BuddingPinkTopazBlock.canClusterGrowAtState(blockstate)) {
                block = (Block)GeodePlusBlocksRegistry.SMALL_PINK_TOPAZ_BUD.get();
                BuddingPinkTopazBlock.applyLuckAround(p_220899_, Vec3.m_82512_((Vec3i)p_220900_), null, 5);
            } else if (blockstate.m_60713_((Block)GeodePlusBlocksRegistry.SMALL_PINK_TOPAZ_BUD.get()) && blockstate.m_61143_((Property)PinkTopazCrystalBlock.FACING) == direction) {
                block = (Block)GeodePlusBlocksRegistry.MEDIUM_PINK_TOPAZ_BUD.get();
                BuddingPinkTopazBlock.applyLuckAround(p_220899_, Vec3.m_82512_((Vec3i)p_220900_), null, 10);
            } else if (blockstate.m_60713_((Block)GeodePlusBlocksRegistry.MEDIUM_PINK_TOPAZ_BUD.get()) && blockstate.m_61143_((Property)PinkTopazCrystalBlock.FACING) == direction) {
                block = (Block)GeodePlusBlocksRegistry.LARGE_PINK_TOPAZ_BUD.get();
                BuddingPinkTopazBlock.applyLuckAround(p_220899_, Vec3.m_82512_((Vec3i)p_220900_), null, 15);
            } else if (blockstate.m_60713_((Block)GeodePlusBlocksRegistry.LARGE_PINK_TOPAZ_BUD.get()) && blockstate.m_61143_((Property)PinkTopazCrystalBlock.FACING) == direction) {
                block = (Block)GeodePlusBlocksRegistry.PINK_TOPAZ_CRYSTAL.get();
                BuddingPinkTopazBlock.applyLuckAround(p_220899_, Vec3.m_82512_((Vec3i)p_220900_), null, 20);
            }
            if (block != null) {
                BlockState blockstate1 = (BlockState)((BlockState)block.m_49966_().m_61124_((Property)PinkTopazCrystalBlock.FACING, (Comparable)direction)).m_61124_((Property)PinkTopazCrystalBlock.WATERLOGGED, (Comparable)Boolean.valueOf(blockstate.m_60819_().m_76152_() == Fluids.f_76193_));
                p_220899_.m_46597_(blockpos, blockstate1);
            }
        }
    }

    public static void applyLuckAround(ServerLevel serverLevel, Vec3 vec3, @Nullable Entity entity, int i) {
        MobEffectInstance mobEffectInstance = new MobEffectInstance(MobEffects.f_19621_, 260, 0, false, false);
        MobEffectUtil.m_216946_((ServerLevel)serverLevel, (Entity)entity, (Vec3)vec3, (double)i, (MobEffectInstance)mobEffectInstance, (int)200);
    }

    public static boolean canClusterGrowAtState(BlockState p_152735_) {
        return p_152735_.m_60795_() || p_152735_.m_60713_(Blocks.f_49990_) && p_152735_.m_60819_().m_76186_() == 8;
    }

    public List<ItemStack> m_49635_(BlockState blockState, LootParams.Builder builder) {
        ItemStack pickaxe = ((ServerPlayer)builder.m_287258_().m_6907_().get(0)).m_21205_();
        ItemStack budding = new ItemStack((ItemLike)GeodePlusBlocksRegistry.BUDDING_PINK_TOPAZ.get());
        if (EnchantmentHelper.m_272262_((ItemStack)pickaxe) && ((Boolean)GeodePlusCommonConfigs.SHOULD_SILK_TOUCH_BUDDING_BLOCKS.get()).booleanValue()) {
            return Collections.singletonList(budding);
        }
        return super.m_49635_(blockState, builder);
    }
}

