/*
 * Decompiled with CFR 0.152.
 */
package net.yeoxuhang.geodeplus.common.block;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.yeoxuhang.geodeplus.common.block.QuartzCrystalBlock;
import net.yeoxuhang.geodeplus.common.config.GeodePlusCommonConfigs;
import net.yeoxuhang.geodeplus.common.registry.GeodePlusBlocksRegistry;

public class BuddingNetherQuartzBlock
extends AmethystBlock {
    public static final int GROWTH_CHANCE = 5;
    private static final Direction[] DIRECTIONS = Direction.values();

    public BuddingNetherQuartzBlock(BlockBehaviour.Properties p_152726_) {
        super(p_152726_);
    }

    public PushReaction getPistonPushReaction(BlockState p_152733_) {
        return PushReaction.DESTROY;
    }

    public void m_213898_(BlockState p_220898_, ServerLevel p_220899_, BlockPos p_220900_, RandomSource p_220901_) {
        if (p_220901_.m_188503_(5) == 0) {
            Direction direction = DIRECTIONS[p_220901_.m_188503_(DIRECTIONS.length)];
            BlockPos blockpos = p_220900_.m_121945_(direction);
            BlockState blockstate = p_220899_.m_8055_(blockpos);
            Block block = null;
            if (BuddingNetherQuartzBlock.canClusterGrowAtState(blockstate)) {
                block = GeodePlusBlocksRegistry.SMALL_QUARTZ_BUD.get();
            } else if (blockstate.m_60713_(GeodePlusBlocksRegistry.SMALL_QUARTZ_BUD.get()) && blockstate.m_61143_((Property)QuartzCrystalBlock.FACING) == direction) {
                block = GeodePlusBlocksRegistry.MEDIUM_QUARTZ_BUD.get();
            } else if (blockstate.m_60713_(GeodePlusBlocksRegistry.MEDIUM_QUARTZ_BUD.get()) && blockstate.m_61143_((Property)QuartzCrystalBlock.FACING) == direction) {
                block = GeodePlusBlocksRegistry.LARGE_QUARTZ_BUD.get();
            } else if (blockstate.m_60713_(GeodePlusBlocksRegistry.LARGE_QUARTZ_BUD.get()) && blockstate.m_61143_((Property)QuartzCrystalBlock.FACING) == direction) {
                block = GeodePlusBlocksRegistry.QUARTZ_CRYSTAL.get();
            }
            if (block != null) {
                BlockState blockstate1 = (BlockState)((BlockState)block.m_49966_().m_61124_((Property)QuartzCrystalBlock.FACING, (Comparable)direction)).m_61124_((Property)QuartzCrystalBlock.WATERLOGGED, (Comparable)Boolean.valueOf(blockstate.m_60819_().m_76152_() == Fluids.f_76193_));
                p_220899_.m_46597_(blockpos, blockstate1);
            }
        }
    }

    public void m_213646_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, ItemStack itemStack, boolean bl) {
        super.m_213646_(blockState, serverLevel, blockPos, itemStack, bl);
        if (bl && !EnchantmentHelper.m_272262_((ItemStack)itemStack)) {
            int i = 1 + serverLevel.f_46441_.m_188503_(5);
            this.m_49805_(serverLevel, blockPos, i);
        }
    }

    public static boolean canClusterGrowAtState(BlockState p_152735_) {
        return p_152735_.m_60795_() || p_152735_.m_60713_(Blocks.f_49990_) && p_152735_.m_60819_().m_76186_() == 8;
    }

    public List<ItemStack> m_49635_(BlockState blockState, LootParams.Builder builder) {
        ItemStack pickaxe = ((ServerPlayer)builder.m_287258_().m_6907_().get(0)).m_21205_();
        ItemStack nether = new ItemStack((ItemLike)GeodePlusBlocksRegistry.BUDDING_NETHER_QUARTZ.get());
        ItemStack basalt = new ItemStack((ItemLike)GeodePlusBlocksRegistry.BUDDING_BASALT_QUARTZ.get());
        ItemStack blackstone = new ItemStack((ItemLike)GeodePlusBlocksRegistry.BUDDING_BLACKSTONE_QUARTZ.get());
        if (EnchantmentHelper.m_272262_((ItemStack)pickaxe) && ((Boolean)GeodePlusCommonConfigs.SHOULD_SILK_TOUCH_BUDDING_BLOCKS.get()).booleanValue() && blockState.m_60713_(GeodePlusBlocksRegistry.BUDDING_NETHER_QUARTZ.get())) {
            return Collections.singletonList(nether);
        }
        if (EnchantmentHelper.m_272262_((ItemStack)pickaxe) && ((Boolean)GeodePlusCommonConfigs.SHOULD_SILK_TOUCH_BUDDING_BLOCKS.get()).booleanValue() && blockState.m_60713_(GeodePlusBlocksRegistry.BUDDING_BASALT_QUARTZ.get())) {
            return Collections.singletonList(basalt);
        }
        if (EnchantmentHelper.m_272262_((ItemStack)pickaxe) && ((Boolean)GeodePlusCommonConfigs.SHOULD_SILK_TOUCH_BUDDING_BLOCKS.get()).booleanValue() && blockState.m_60713_(GeodePlusBlocksRegistry.BUDDING_BLACKSTONE_QUARTZ.get())) {
            return Collections.singletonList(blackstone);
        }
        return super.m_49635_(blockState, builder);
    }
}

