/*
 * Decompiled with CFR 0.152.
 */
package net.yeoxuhang.geodeplus.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.yeoxuhang.geodeplus.common.block.EchoCrystalBlock;
import net.yeoxuhang.geodeplus.common.registry.GeodePlusBlocksRegistry;

public class BuddingEchoBlock
extends AmethystBlock {
    public static final int GROWTH_CHANCE = 5;
    private static final Direction[] DIRECTIONS = Direction.values();

    public BuddingEchoBlock(BlockBehaviour.Properties p_152726_) {
        super(p_152726_);
    }

    public PushReaction getPistonPushReaction(BlockState p_152733_) {
        return PushReaction.DESTROY;
    }

    public void m_213898_(BlockState p_220898_, ServerLevel p_220899_, BlockPos p_220900_, RandomSource p_220901_) {
        if (p_220901_.m_188503_(15) == 0) {
            Direction direction = DIRECTIONS[p_220901_.m_188503_(DIRECTIONS.length)];
            BlockPos blockpos = p_220900_.m_121945_(direction);
            BlockState blockstate = p_220899_.m_8055_(blockpos);
            Block block = null;
            if (BuddingEchoBlock.canClusterGrowAtState(blockstate)) {
                block = (Block)GeodePlusBlocksRegistry.SMALL_ECHO_BUD.get();
                Warden.m_219375_((ServerLevel)p_220899_, (Vec3)Vec3.m_82512_((Vec3i)p_220900_), null, (int)5);
            } else if (blockstate.m_60713_((Block)GeodePlusBlocksRegistry.SMALL_ECHO_BUD.get()) && blockstate.m_61143_((Property)EchoCrystalBlock.FACING) == direction) {
                block = (Block)GeodePlusBlocksRegistry.MEDIUM_ECHO_BUD.get();
                Warden.m_219375_((ServerLevel)p_220899_, (Vec3)Vec3.m_82512_((Vec3i)p_220900_), null, (int)10);
            } else if (blockstate.m_60713_((Block)GeodePlusBlocksRegistry.MEDIUM_ECHO_BUD.get()) && blockstate.m_61143_((Property)EchoCrystalBlock.FACING) == direction) {
                block = (Block)GeodePlusBlocksRegistry.LARGE_ECHO_BUD.get();
                Warden.m_219375_((ServerLevel)p_220899_, (Vec3)Vec3.m_82512_((Vec3i)p_220900_), null, (int)15);
            } else if (blockstate.m_60713_((Block)GeodePlusBlocksRegistry.LARGE_ECHO_BUD.get()) && blockstate.m_61143_((Property)EchoCrystalBlock.FACING) == direction) {
                block = GeodePlusBlocksRegistry.ECHO_CRYSTAL.get();
                Warden.m_219375_((ServerLevel)p_220899_, (Vec3)Vec3.m_82512_((Vec3i)p_220900_), null, (int)20);
            }
            if (block != null) {
                BlockState blockstate1 = (BlockState)((BlockState)block.m_49966_().m_61124_((Property)EchoCrystalBlock.FACING, (Comparable)direction)).m_61124_((Property)EchoCrystalBlock.WATERLOGGED, (Comparable)Boolean.valueOf(blockstate.m_60819_().m_76152_() == Fluids.f_76193_));
                p_220899_.m_46597_(blockpos, blockstate1);
            }
        }
    }

    public static boolean canClusterGrowAtState(BlockState p_152735_) {
        return p_152735_.m_60795_() || p_152735_.m_60713_(Blocks.f_49990_) && p_152735_.m_60819_().m_76186_() == 8;
    }

    public void m_213646_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, ItemStack itemStack, boolean bl) {
        super.m_213646_(blockState, serverLevel, blockPos, itemStack, bl);
        if (bl && !EnchantmentHelper.m_272262_((ItemStack)itemStack)) {
            int i = 1 + serverLevel.f_46441_.m_188503_(5);
            this.m_49805_(serverLevel, blockPos, i);
        }
    }
}

