/*
 * Decompiled with CFR 0.152.
 */
package net.yeoxuhang.geodeplus.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Calendar;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.Level;
import net.yeoxuhang.geodeplus.GeodePlus;
import net.yeoxuhang.geodeplus.client.GeodePlusClient;
import net.yeoxuhang.geodeplus.client.model.WrappistPedestalBlockEntityModel;
import net.yeoxuhang.geodeplus.common.block.entity.WrappistPedestalBlockEntity;

public class WrappistPedestalBlockEntityRenderer<T extends WrappistPedestalBlockEntity>
implements BlockEntityRenderer<T> {
    public static final ResourceLocation TEXTURE = GeodePlus.createID("textures/entity/wrappist_pedestal/wrappist_pedestal.png");
    public static final ResourceLocation XMAS = GeodePlus.createID("textures/entity/wrappist_pedestal/christmas.png");
    private final ItemRenderer itemRenderer;
    private final EntityRenderDispatcher entityRenderer;
    private boolean xmasTextures;
    private static WrappistPedestalBlockEntityModel wrappistPedestal;

    public WrappistPedestalBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.m_234447_();
        this.entityRenderer = context.m_234446_();
        wrappistPedestal = new WrappistPedestalBlockEntityModel(context.m_173582_(GeodePlusClient.WRAPPIST_PEDESTAL));
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.xmasTextures = true;
        }
    }

    public void render(T entity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j) {
        Level world = entity.m_58904_();
        assert (world != null);
        long gameTime = world.m_46467_();
        float offsetY = (float)Math.sin((float)gameTime / 8.0f) * 0.025f;
        float crystalTick = (float)gameTime / 35.0f;
        float tick = (float)gameTime / 10.0f;
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-180.0f));
        if (this.xmasTextures) {
            wrappistPedestal.m_7695_(poseStack, multiBufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)XMAS)), i, j, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            wrappistPedestal.m_7695_(poseStack, multiBufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE)), i, j, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        WrappistPedestalBlockEntityRenderer.wrappistPedestal.wrappist_pedestal.m_104227_(8.0f, -2.0f, -8.0f);
        WrappistPedestalBlockEntityRenderer.wrappistPedestal.crystals.m_171327_(0.0f, -crystalTick % 360.0f, 0.0f);
        if (entity.m_58898_() && !((WrappistPedestalBlockEntity)((Object)entity)).m_7983_()) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, (double)offsetY - 1.0, -0.5);
            poseStack.m_85841_(0.35f, 0.35f, 0.35f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(tick % 360.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-180.0f));
            this.itemRenderer.m_269128_(((WrappistPedestalBlockEntity)((Object)entity)).m_8020_(0), ItemDisplayContext.FIXED, i, OverlayTexture.f_118083_, poseStack, multiBufferSource, entity.m_58904_(), j);
            poseStack.m_85849_();
        }
    }
}

