/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goldenhopper.world.level.item;

import com.mrcrayfish.goldenhopper.platform.Services;
import com.mrcrayfish.goldenhopper.world.entity.vehicle.GoldenHopperMinecart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;

public class GoldenHopperMinecartItem
extends Item {
    private static final DispenseItemBehavior MINECART_DISPENSER_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior behaviourDefaultDispenseItem = new DefaultDispenseItemBehavior();

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            double yOffset;
            ServerLevel level = source.m_7727_();
            Direction facing = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            BlockPos railPos = source.m_7961_().m_121945_(facing);
            BlockState railState = level.m_8055_(railPos);
            RailShape railShape = this.getRailShape(railState, (Level)level, railPos);
            double d = yOffset = railShape.m_61745_() ? 0.6 : 0.1;
            if (!railState.m_204336_(BlockTags.f_13034_)) {
                if (!railState.m_60795_() || !level.m_8055_(railPos.m_7495_()).m_204336_(BlockTags.f_13034_)) {
                    return this.behaviourDefaultDispenseItem.m_6115_(source, stack);
                }
                railState = level.m_8055_(railPos.m_7495_());
                railShape = this.getRailShape(railState, (Level)level, railPos.m_7495_());
                yOffset = facing != Direction.DOWN && railShape.m_61745_() ? -0.4 : -0.9;
            }
            double posX = source.m_7096_() + (double)facing.m_122429_() * 1.125;
            double posY = Math.floor(source.m_7098_()) + (double)facing.m_122430_();
            double posZ = source.m_7094_() + (double)facing.m_122431_() * 1.125;
            GoldenHopperMinecart minecart = Services.PLATFORM.createGoldenHopperMinecart((Level)level, posX, posY + yOffset, posZ);
            if (stack.m_41788_()) {
                minecart.m_6593_(stack.m_41786_());
            }
            level.m_7967_((Entity)minecart);
            stack.m_41774_(1);
            return stack;
        }

        private RailShape getRailShape(BlockState state, Level level, BlockPos pos) {
            Block block = state.m_60734_();
            if (block instanceof BaseRailBlock) {
                BaseRailBlock railBlock = (BaseRailBlock)block;
                return Services.PLATFORM.getRailDirection(railBlock, state, level, pos);
            }
            return RailShape.NORTH_SOUTH;
        }

        protected void m_6823_(BlockSource source) {
            source.m_7727_().m_46796_(1000, source.m_7961_(), 0);
        }
    };

    public GoldenHopperMinecartItem(Item.Properties builder) {
        super(builder);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)MINECART_DISPENSER_BEHAVIOR);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        Level level = context.m_43725_();
        BlockState state = level.m_8055_(pos = context.m_8083_());
        if (!state.m_204336_(BlockTags.f_13034_)) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = context.m_43722_();
        if (!level.f_46443_) {
            RailShape railShape;
            Block block = state.m_60734_();
            if (block instanceof BaseRailBlock) {
                BaseRailBlock railBlock = (BaseRailBlock)block;
                railShape = Services.PLATFORM.getRailDirection(railBlock, state, level, pos);
            } else {
                railShape = RailShape.NORTH_SOUTH;
            }
            RailShape shape = railShape;
            double yOffset = shape.m_61745_() ? 0.5 : 0.0;
            GoldenHopperMinecart minecart = Services.PLATFORM.createGoldenHopperMinecart(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.0625 + yOffset, (double)pos.m_123343_() + 0.5);
            if (stack.m_41788_()) {
                minecart.m_6593_(stack.m_41786_());
            }
            level.m_7967_((Entity)minecart);
        }
        stack.m_41774_(1);
        return InteractionResult.SUCCESS;
    }
}

