/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goldenhopper.world.level.block.entity;

import com.mrcrayfish.goldenhopper.platform.Services;
import com.mrcrayfish.goldenhopper.util.HopperHelper;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractHopperBlockEntity
extends RandomizableContainerBlockEntity
implements Hopper {
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    protected final int transferSpeed;
    protected int transferCooldown = -1;
    protected long tickedGameTime;

    protected AbstractHopperBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int transferSpeed) {
        super(type, pos, state);
        this.transferSpeed = transferSpeed;
    }

    protected abstract Component m_6820_();

    protected abstract AbstractContainerMenu m_6555_(int var1, Inventory var2);

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public double m_6343_() {
        return (double)this.f_58858_.m_123341_() + 0.5;
    }

    public double m_6358_() {
        return (double)this.f_58858_.m_123342_() + 0.5;
    }

    public double m_6446_() {
        return (double)this.f_58858_.m_123343_() + 0.5;
    }

    public int m_6643_() {
        return 5;
    }

    public void setTransferCooldown(int transferCooldown) {
        this.transferCooldown = transferCooldown;
    }

    public int getTransferSpeed() {
        return this.transferSpeed;
    }

    public boolean isCoolingDown() {
        return this.transferCooldown > 0;
    }

    public boolean isCustomCooldown() {
        return this.transferCooldown > this.transferSpeed;
    }

    public long getLastUpdateTime() {
        return this.tickedGameTime;
    }

    public boolean isInventoryFull() {
        return this.items.stream().noneMatch(stack -> stack.m_41619_() || stack.m_41613_() != stack.m_41741_());
    }

    public int[] getTransferableSlots() {
        return IntStream.range(0, this.items.size()).toArray();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(tag)) {
            ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        }
        this.transferCooldown = tag.m_128451_("TransferCooldown");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.m_59634_(tag)) {
            ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        }
        tag.m_128405_("TransferCooldown", this.transferCooldown);
    }

    public ItemStack m_7407_(int index, int count) {
        this.m_59640_(null);
        return ContainerHelper.m_18969_(this.m_7086_(), (int)index, (int)count);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.m_59640_(null);
        this.m_7086_().set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    public void onEntityCollide(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (entity instanceof ItemEntity && Shapes.m_83157_((VoxelShape)Shapes.m_83064_((AABB)entity.m_20191_().m_82386_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_()))), (VoxelShape)this.m_59300_(), (BooleanOp)BooleanOp.f_82689_)) {
            this.attemptTransferItems(level, pos, state, () -> HopperBlockEntity.m_59331_((Container)this, (ItemEntity)((ItemEntity)entity)));
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AbstractHopperBlockEntity hopper) {
        hopper.serverTick(level, pos, state);
    }

    protected void serverTick(Level level, BlockPos pos, BlockState state) {
        --this.transferCooldown;
        this.tickedGameTime = level.m_46467_();
        if (!this.isCoolingDown()) {
            this.setTransferCooldown(0);
            this.attemptTransferItems(level, pos, state, () -> HopperBlockEntity.m_155552_((Level)level, (Hopper)this));
        }
    }

    protected void attemptTransferItems(Level level, BlockPos pos, BlockState state, Supplier<Boolean> pullItem) {
        if (!level.m_5776_() && !this.isCoolingDown() && ((Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61431_)).booleanValue()) {
            boolean transferred = !this.m_7983_() && this.pushItems(level, pos, state);
            if (transferred |= !this.isInventoryFull() && pullItem.get() != false) {
                this.setTransferCooldown(this.transferSpeed);
                this.m_6596_();
            }
        }
    }

    protected boolean pushItems(Level level, BlockPos pos, BlockState state) {
        Container container = AbstractHopperBlockEntity.getTargetContainer(level, pos, state);
        if (container == null) {
            return false;
        }
        Direction direction = ((Direction)state.m_61143_((Property)BlockStateProperties.f_61373_)).m_122424_();
        if (Services.PLATFORM.isFullContainer(container, direction)) {
            return false;
        }
        for (int slotIndex : this.getTransferableSlots()) {
            ItemStack stack = this.m_8020_(slotIndex);
            if (stack.m_41619_()) continue;
            ItemStack copyStack = stack.m_41777_();
            ItemStack resultStack = HopperBlockEntity.m_59326_((Container)this, (Container)container, (ItemStack)this.m_7407_(slotIndex, 1), (Direction)direction);
            if (resultStack.m_41619_()) {
                container.m_6596_();
                return true;
            }
            this.m_6836_(slotIndex, copyStack);
        }
        return false;
    }

    @Nullable
    private static Container getTargetContainer(Level level, BlockPos pos, BlockState state) {
        return HopperBlockEntity.m_59390_((Level)level, (BlockPos)pos.m_121945_((Direction)state.m_61143_((Property)BlockStateProperties.f_61373_)));
    }

    public static void applyTransferCooldown(Container source, Container target) {
        if (!HopperHelper.isOnCustomCooldown(target)) {
            long targetLastUpdate = HopperHelper.getLastUpdate(target);
            long sourceLastUpdate = HopperHelper.getLastUpdate(source);
            int offset = sourceLastUpdate > 0L && targetLastUpdate >= sourceLastUpdate ? 1 : 0;
            int cooldown = HopperHelper.getTransferCooldown(target) - offset;
            HopperHelper.setCooldown(target, cooldown);
        }
    }
}

