/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goldenhopper.world.entity.vehicle;

import com.mrcrayfish.goldenhopper.core.ModBlocks;
import com.mrcrayfish.goldenhopper.core.ModEntities;
import com.mrcrayfish.goldenhopper.core.ModItems;
import com.mrcrayfish.goldenhopper.world.inventory.GoldenHopperMenu;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public abstract class GoldenHopperMinecart
extends AbstractMinecartContainer
implements Hopper,
WorldlyContainer {
    private boolean blocked = true;
    private int transferTicker = -1;
    private final BlockPos lastPosition = BlockPos.f_121853_;

    public GoldenHopperMinecart(EntityType<?> type, Level level) {
        super(type, level);
    }

    public GoldenHopperMinecart(Level level, double x, double y, double z) {
        super((EntityType)ModEntities.GOLDEN_HOPPER_MINECART.get(), x, y, z, level);
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public void setTransferTicker(int transferTicker) {
        this.transferTicker = transferTicker;
    }

    public boolean canTransfer() {
        return this.transferTicker > 0;
    }

    protected AbstractContainerMenu m_7402_(int windowId, Inventory playerInventory) {
        return new GoldenHopperMenu(windowId, playerInventory, (Container)this);
    }

    public BlockState m_6390_() {
        return ((Block)ModBlocks.GOLDEN_HOPPER.get()).m_49966_();
    }

    public int m_7144_() {
        return 1;
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ModItems.GOLDEN_HOPPER_MINECART.get());
    }

    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.HOPPER;
    }

    public double m_6343_() {
        return this.m_20185_();
    }

    public double m_6358_() {
        return this.m_20186_() + 0.5;
    }

    public double m_6446_() {
        return this.m_20189_();
    }

    public int m_6643_() {
        return 6;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return index != 0 && (this.m_8020_(0).m_41619_() || stack.m_41720_() == this.m_8020_(0).m_41720_());
    }

    public int[] m_7071_(Direction side) {
        return IntStream.range(1, this.m_6643_()).toArray();
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        return index != 0 && (this.m_8020_(0).m_41619_() || stack.m_41720_() == this.m_8020_(0).m_41720_());
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return index != 0;
    }

    public boolean m_271862_(Container container, int index, ItemStack stack) {
        return index != 0;
    }

    public void m_6025_(int x, int y, int z, boolean receivingPower) {
        if (receivingPower == this.isBlocked()) {
            this.setBlocked(!receivingPower);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.isBlocked()) {
            BlockPos pos = this.m_20183_();
            if (pos.equals((Object)this.lastPosition)) {
                --this.transferTicker;
            } else {
                this.setTransferTicker(0);
            }
            if (!this.canTransfer()) {
                this.setTransferTicker(0);
                if (this.captureDroppedItems()) {
                    this.setTransferTicker(4);
                    this.m_6596_();
                }
            }
        }
    }

    protected boolean captureDroppedItems() {
        List list;
        if (!HopperBlockEntity.m_155552_((Level)this.m_9236_(), (Hopper)this) && !(list = this.m_9236_().m_6443_(ItemEntity.class, this.m_20191_().m_82377_(0.25, 0.0, 0.25), EntitySelector.f_20402_)).isEmpty()) {
            return HopperBlockEntity.m_59331_((Container)this, (ItemEntity)((ItemEntity)list.get(0)));
        }
        return false;
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("TransferCooldown", this.transferTicker);
        compound.m_128379_("Enabled", this.blocked);
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.transferTicker = compound.m_128451_("TransferCooldown");
        this.blocked = !compound.m_128441_("Enabled") || compound.m_128471_("Enabled");
    }

    public void m_7617_(DamageSource source) {
        super.m_7617_(source);
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_19998_((ItemLike)ModBlocks.GOLDEN_HOPPER.get());
        }
    }
}

