/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.trades;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.trades.ModItemListing;
import net.mehvahdjukaar.moonlight.api.trades.RemoveNonDataListingListing;
import net.mehvahdjukaar.moonlight.api.trades.SimpleItemListing;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.trading.MerchantOffer;
import org.jetbrains.annotations.Nullable;

public class ItemListingRegistry
extends SimpleJsonResourceReloadListener {
    public static final ItemListingRegistry INSTANCE = new ItemListingRegistry();
    private final BiMap<ResourceLocation, Codec<ModItemListing>> serializers = HashBiMap.create();
    private final Map<EntityType<?>, Int2ObjectArrayMap<List<ModItemListing>>> specialCustomTrades = new HashMap();
    private final Map<VillagerProfession, Int2ObjectArrayMap<List<ModItemListing>>> customTrades = new HashMap<VillagerProfession, Int2ObjectArrayMap<List<ModItemListing>>>();
    private final Map<EntityType<?>, Int2ObjectArrayMap<ModItemListing[]>> oldSpecialTrades = new HashMap();
    private final Map<VillagerProfession, Int2ObjectArrayMap<ModItemListing[]>> oldTrades = new HashMap<VillagerProfession, Int2ObjectArrayMap<ModItemListing[]>>();
    private int count = 0;

    public ItemListingRegistry() {
        super(new Gson(), "moonlight/villager_trades");
        this.serializers.put((Object)new ResourceLocation("simple"), SimpleItemListing.CODEC);
        this.serializers.put((Object)new ResourceLocation("remove_all_non_data"), RemoveNonDataListingListing.CODEC);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.mergeProfessionAndSpecial(false);
        this.count = 0;
        this.customTrades.clear();
        this.specialCustomTrades.clear();
        for (Map.Entry<ResourceLocation, JsonElement> e : jsons.entrySet()) {
            JsonElement j = e.getValue();
            ResourceLocation id = e.getKey();
            try {
                if (!id.m_135815_().contains("/")) continue;
                ResourceLocation targetId = id.m_247266_(p -> p.substring(0, p.lastIndexOf(47)));
                Optional profession = BuiltInRegistries.f_256735_.m_6612_(targetId);
                if (profession.isPresent()) {
                    ModItemListing trade = ItemListingRegistry.parseOrThrow(j, id);
                    ((List)this.customTrades.computeIfAbsent((VillagerProfession)profession.get(), t -> new Int2ObjectArrayMap()).computeIfAbsent(trade.getLevel(), a -> new ArrayList())).add(trade);
                    continue;
                }
                Optional entityType = BuiltInRegistries.f_256780_.m_6612_(targetId);
                if (entityType.isPresent()) {
                    ModItemListing trade = ItemListingRegistry.parseOrThrow(j, id);
                    ((List)this.specialCustomTrades.computeIfAbsent((EntityType)entityType.get(), t -> new Int2ObjectArrayMap()).computeIfAbsent(trade.getLevel(), a -> new ArrayList())).add(trade);
                    continue;
                }
                Moonlight.LOGGER.warn("Unknown villager type: {}", (Object)targetId);
            }
            catch (Exception err) {
                Moonlight.LOGGER.error("Something went wrong while parsing custom villager trades", (Throwable)err);
            }
        }
        this.mergeProfessionAndSpecial(true);
        if (this.count != 0) {
            Moonlight.LOGGER.info("Applied {} data villager trades", (Object)this.count);
        }
    }

    private void mergeAll(Int2ObjectMap<VillagerTrades.ItemListing[]> originalValues, Int2ObjectArrayMap<List<ModItemListing>> newValues, boolean add) {
        for (Int2ObjectMap.Entry e : newValues.int2ObjectEntrySet()) {
            int level = e.getIntKey();
            VillagerTrades.ItemListing[] elements = (VillagerTrades.ItemListing[])originalValues.get(level);
            ArrayList original = new ArrayList(elements == null ? List.of() : List.of(elements));
            List value = (List)e.getValue();
            if (add) {
                original.addAll(value);
                this.count += value.size();
            } else {
                original.removeAll(value);
            }
            originalValues.put(level, (Object)((VillagerTrades.ItemListing[])original.toArray(VillagerTrades.ItemListing[]::new)));
        }
    }

    private void mergeProfessionAndSpecial(boolean add) {
        for (Map.Entry<VillagerProfession, Int2ObjectArrayMap<List<ModItemListing>>> p : this.customTrades.entrySet()) {
            VillagerProfession profession = p.getKey();
            Int2ObjectMap map = VillagerTrades.f_35627_.computeIfAbsent(profession, k -> new Int2ObjectArrayMap());
            Int2ObjectArrayMap<List<ModItemListing>> value = p.getValue();
            this.mergeAll((Int2ObjectMap<VillagerTrades.ItemListing[]>)map, value, add);
        }
        Int2ObjectArrayMap<List<ModItemListing>> wanderingStuff = this.specialCustomTrades.get(EntityType.f_20494_);
        if (wanderingStuff != null) {
            this.mergeAll((Int2ObjectMap<VillagerTrades.ItemListing[]>)VillagerTrades.f_35628_, wanderingStuff, add);
        }
    }

    private static ModItemListing parseOrThrow(JsonElement j, ResourceLocation id) {
        return (ModItemListing)((Pair)ModItemListing.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)j).getOrThrow(false, errorMsg -> Moonlight.LOGGER.warn("Failed to parse custom trade with id {} - error: {}", (Object)id, errorMsg))).getFirst();
    }

    public static List<? extends VillagerTrades.ItemListing> getVillagerListings(VillagerProfession profession, int level) {
        VillagerTrades.ItemListing[] array = (VillagerTrades.ItemListing[])((Int2ObjectMap)VillagerTrades.f_35627_.get(profession)).get(level);
        if (array == null) {
            return List.of();
        }
        return Arrays.stream(array).toList();
    }

    public static List<? extends VillagerTrades.ItemListing> getSpecialListings(EntityType<?> entityType, int level) {
        if (entityType == EntityType.f_20494_) {
            VillagerTrades.ItemListing[] array = (VillagerTrades.ItemListing[])VillagerTrades.f_35628_.get(level);
            if (array == null) {
                return List.of();
            }
            return Arrays.stream(array).toList();
        }
        Int2ObjectArrayMap<List<ModItemListing>> special = ItemListingRegistry.INSTANCE.specialCustomTrades.get(entityType);
        if (special == null) {
            return List.of();
        }
        return (List)special.getOrDefault(level, List.of());
    }

    public static void registerSerializer(ResourceLocation id, Codec<? extends ModItemListing> trade) {
        ItemListingRegistry.INSTANCE.serializers.put((Object)id, trade);
    }

    public static void registerSimple(ResourceLocation id, VillagerTrades.ItemListing instance, int level) {
        SpecialListing specialListing = new SpecialListing(instance, level);
        ItemListingRegistry.registerSerializer(id, specialListing.getCodec());
    }

    public static Codec<ModItemListing> getSerializer(ResourceLocation id) {
        return (Codec)ItemListingRegistry.INSTANCE.serializers.get((Object)id);
    }

    public static ResourceLocation getSerializerKey(Codec<ModItemListing> object) {
        return (ResourceLocation)ItemListingRegistry.INSTANCE.serializers.inverse().get(object);
    }

    private static class SpecialListing
    implements ModItemListing {
        private final Codec<ModItemListing> codec = Codec.unit((Object)this);
        private final VillagerTrades.ItemListing listing;
        private final int level;

        public SpecialListing(VillagerTrades.ItemListing listing, int level) {
            this.listing = listing;
            this.level = level;
        }

        @Override
        public Codec<? extends ModItemListing> getCodec() {
            return this.codec;
        }

        @Nullable
        public MerchantOffer m_213663_(Entity trader, RandomSource random) {
            return this.listing.m_213663_(trader, random);
        }

        @Override
        public int getLevel() {
            return this.level;
        }
    }
}

