/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.modhelper;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.majruszlibrary.MajruszLibrary;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.events.OnPlayerLoggedIn;
import com.majruszlibrary.modhelper.ModHelper;
import com.majruszlibrary.platform.Integration;
import com.majruszlibrary.platform.Side;
import com.majruszlibrary.text.TextHelper;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.loot.Deserializers;

class VersionChecker {
    static final Pattern VERSION = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)");
    static final List<Component> COMPONENTS = Collections.synchronizedList(new ArrayList());
    static boolean IS_ENABLED = true;
    final ModHelper helper;
    final Gson gson;
    String currentVersion;
    String latestVersion;
    String homepage;
    Map<String, String> versions = new HashMap<String, String>();

    public VersionChecker(ModHelper helper) {
        this.helper = helper;
        this.gson = Deserializers.m_78799_().registerTypeAdapter(VersionChecker.class, new TypeAdapter<VersionChecker>(() -> this)).setPrettyPrinting().create();
    }

    public void register() {
        Optional<URL> update = Integration.getUpdateURL(this.helper.getModId());
        if (update.isEmpty()) {
            this.helper.logError("Missing update url", new Object[0]);
            return;
        }
        Matcher matcher = VERSION.matcher(Integration.getVersion(this.helper.getModId()));
        if (!matcher.find()) {
            this.helper.logError("Not supported version format", new Object[0]);
            return;
        }
        try {
            InputStreamReader reader = new InputStreamReader(update.get().openStream());
            this.gson.fromJson((Reader)reader, VersionChecker.class);
        }
        catch (Exception exception) {
            this.helper.logError("Failed to retrieve the latest mod versions from %s".formatted(update.get()), new Object[0]);
            return;
        }
        String id = "%s-recommended".formatted(Integration.getMinecraftVersion());
        if (!this.versions.containsKey(id)) {
            return;
        }
        this.currentVersion = matcher.group();
        this.latestVersion = this.versions.get(id);
        if (!this.isUpdateAvailable()) {
            return;
        }
        MutableComponent name = TextHelper.literal(" [%s %s]", Integration.getName(this.helper.getModId()), this.latestVersion).m_130940_(ChatFormatting.YELLOW).m_130938_(TextHelper.createURL(this.homepage));
        MutableComponent versions = TextHelper.translatable("majruszlibrary.update_versions", name, this.currentVersion).m_130940_(ChatFormatting.GRAY);
        COMPONENTS.add((Component)versions);
    }

    private boolean isUpdateAvailable() {
        Matcher current = VERSION.matcher(this.currentVersion);
        Matcher latest = VERSION.matcher(this.latestVersion);
        if (!current.find() || !latest.find()) {
            this.helper.logError("Not supported version format (current: %s, latest: %s)".formatted(this.currentVersion, this.latestVersion), new Object[0]);
            return false;
        }
        int currentMajor = Integer.parseInt(current.group(1));
        int currentMinor = Integer.parseInt(current.group(2));
        int currentPatch = Integer.parseInt(current.group(3));
        int latestMajor = Integer.parseInt(latest.group(1));
        int latestMinor = Integer.parseInt(latest.group(2));
        int latestPatch = Integer.parseInt(latest.group(3));
        return latestMajor > currentMajor || latestMajor == currentMajor && latestMinor > currentMinor || latestMajor == currentMajor && latestMinor == currentMinor && latestPatch > currentPatch;
    }

    private static void sendUpdateMessages(OnPlayerLoggedIn data) {
        data.player.m_213846_((Component)TextHelper.translatable("majruszlibrary.update_available", new Object[0]));
        COMPONENTS.forEach(arg_0 -> ((ServerPlayer)data.player).m_213846_(arg_0));
    }

    static {
        Serializables.getStatic(MajruszLibrary.Config.class).define("send_new_available_updates_message", com.majruszlibrary.data.Reader.bool(), () -> IS_ENABLED, v -> {
            IS_ENABLED = v;
        });
        Serializables.get(VersionChecker.class).define("homepage", com.majruszlibrary.data.Reader.string(), s -> s.homepage, (s, v) -> {
            s.homepage = v;
        }).define("promos", com.majruszlibrary.data.Reader.map(com.majruszlibrary.data.Reader.string()), s -> s.versions, (s, v) -> {
            s.versions = v;
        });
        OnPlayerLoggedIn.listen(VersionChecker::sendUpdateMessages).addCondition(data -> IS_ENABLED).addCondition(data -> COMPONENTS.size() > 0).addCondition(data -> Side.isLogicalServer() && !Side.isDedicatedServer() || data.player.m_20310_(4));
    }

    private record TypeAdapter<Type>(Supplier<Type> instance) implements JsonDeserializer<Type>
    {
        public Type deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return Serializables.read(this.instance.get(), json);
        }
    }
}

