/*
 * Decompiled with CFR 0.152.
 */
package dev.limonblaze.originsclasses.core.mixin.common.minecraft;

import dev.limonblaze.originsclasses.common.registry.OriginsClassesPowers;
import dev.limonblaze.originsclasses.util.MerchantHelper;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.power.DummyPower;
import java.util.Collection;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractVillager.class})
public abstract class AbstractVillagerMixin
extends AgeableMob {
    @Shadow
    protected MerchantOffers f_35261_;
    @Shadow
    private Player f_35263_;
    @Unique
    private int offerCountWithoutAdditional;
    @Unique
    private MerchantOffers additionalOffers;

    protected AbstractVillagerMixin(EntityType<? extends AgeableMob> type, Level world) {
        super(type, world);
    }

    @Inject(method={"notifyTrade"}, at={@At(value="TAIL")})
    private void originsClasses$infiniteTrade(MerchantOffer offer, CallbackInfo ci) {
        if (IPowerContainer.hasPower((Entity)this.f_35263_, (PowerFactory)((DummyPower)OriginsClassesPowers.INFINITE_TRADE.get()))) {
            --offer.f_45313_;
        }
    }

    @Inject(method={"setTradingPlayer"}, at={@At(value="HEAD")})
    private void originsClasses$addAdditionalOffers(Player customer, CallbackInfo ci) {
        if (this instanceof WanderingTrader) {
            if (IPowerContainer.hasPower((Entity)customer, (PowerFactory)((DummyPower)OriginsClassesPowers.RARE_WANDERING_LOOT.get()))) {
                if (this.additionalOffers == null) {
                    this.offerCountWithoutAdditional = this.f_35261_.size();
                    this.additionalOffers = this.buildAdditionalOffers();
                }
                this.f_35261_.addAll((Collection)this.additionalOffers);
            } else if (this.additionalOffers != null) {
                while (this.f_35261_.size() > this.offerCountWithoutAdditional) {
                    this.f_35261_.remove(this.f_35261_.size() - 1);
                }
            }
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void originsClasses$writeAdditionalOffersToTag(CompoundTag tag, CallbackInfo ci) {
        if (this.additionalOffers != null) {
            tag.m_128365_("AdditionalOffers", (Tag)this.additionalOffers.m_45388_());
            tag.m_128405_("OfferCountNoAdditional", this.offerCountWithoutAdditional);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void originsClasses$readAdditionalOffersFromTag(CompoundTag tag, CallbackInfo ci) {
        if (tag.m_128441_("AdditionalOffers")) {
            this.additionalOffers = new MerchantOffers(tag.m_128469_("AdditionalOffers"));
            this.offerCountWithoutAdditional = tag.m_128451_("OfferCountNoAdditional");
        }
    }

    @Unique
    private MerchantOffers buildAdditionalOffers() {
        MerchantOffers offers = new MerchantOffers();
        MerchantHelper helper = MerchantHelper.instance();
        RandomSource random = RandomSource.m_216327_();
        Item desireditem = helper.randomObtainableItem(random, helper.blacklistItems);
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, random.m_188503_(12) + 6), MerchantHelper.randomEnchantedItemStack(helper.randomObtainableItem(random, helper.blacklistItems), random, 0.5f, 30), 1, 5, 0.05f));
        offers.add((Object)new MerchantOffer(new ItemStack((ItemLike)desireditem, 1 + random.m_188503_(Math.min(16, desireditem.m_7968_().m_41741_()))), MerchantHelper.randomEnchantedItemStack(helper.randomObtainableItem(random, helper.blacklistItems), random, 0.5f, 30), 1, 5, 0.05f));
        return offers;
    }
}

