/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.mutantmonsters.client.animation.Animator;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import java.util.Arrays;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class MutantEndermanModel
extends EntityModel<MutantEnderman> {
    private final ModelPart pelvis;
    private final ModelPart abdomen;
    private final ModelPart chest;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart mouth;
    private final Arm rightArm;
    private final Arm leftArm;
    private final Arm lowerRightArm;
    private final Arm lowerLeftArm;
    private final ModelPart legJoint1;
    private final ModelPart legJoint2;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart foreLeg1;
    private final ModelPart foreLeg2;
    private float partialTick;

    public MutantEndermanModel(ModelPart modelPart) {
        this.pelvis = modelPart.m_171324_("pelvis");
        this.abdomen = this.pelvis.m_171324_("abdomen");
        this.chest = this.abdomen.m_171324_("chest");
        this.neck = this.chest.m_171324_("neck");
        this.head = this.neck.m_171324_("head");
        this.mouth = this.head.m_171324_("mouth");
        this.rightArm = new Arm("right_", this.chest, true);
        this.leftArm = new Arm("left_", this.chest, false);
        this.lowerRightArm = new Arm("lower_right_", this.chest, true);
        this.lowerLeftArm = new Arm("lower_left_", this.chest, false);
        this.legJoint1 = this.abdomen.m_171324_("leg_joint1");
        this.legJoint2 = this.abdomen.m_171324_("leg_joint2");
        this.leg1 = this.legJoint1.m_171324_("leg1");
        this.leg2 = this.legJoint2.m_171324_("leg2");
        this.foreLeg1 = this.leg1.m_171324_("fore_leg1");
        this.foreLeg2 = this.leg2.m_171324_("fore_leg2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition pelvis = root.m_171599_("pelvis", CubeListBuilder.m_171558_().m_171514_(0, 0), PartPose.m_171419_((float)0.0f, (float)-15.5f, (float)8.0f));
        PartDefinition abdomen = pelvis.m_171599_("abdomen", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171481_(-4.0f, -10.0f, -2.0f, 8.0f, 10.0f, 4.0f), PartPose.f_171404_);
        PartDefinition chest = abdomen.m_171599_("chest", CubeListBuilder.m_171558_().m_171514_(50, 8).m_171481_(-5.0f, -16.0f, -3.0f, 10.0f, 16.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition neck = chest.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(32, 14).m_171481_(-1.5f, -4.0f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)-15.0f, (float)0.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.0f, -8.0f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.5f)).m_171514_(0, 14).m_171488_(-4.0f, 3.0f, -8.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)3.0f));
        head.m_171599_("mouth", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171481_(-4.0f, 3.0f, -8.0f, 8.0f, 2.0f, 8.0f), PartPose.f_171404_);
        Arm.createArmLayer("right_", chest, true, false);
        Arm.createArmLayer("left_", chest, false, false);
        Arm.createArmLayer("lower_right_", chest, true, true);
        Arm.createArmLayer("lower_left_", chest, false, true);
        PartDefinition legJoint1 = abdomen.m_171599_("leg_joint1", CubeListBuilder.m_171558_().m_171514_(0, 0), PartPose.m_171419_((float)-1.5f, (float)0.0f, (float)0.75f));
        PartDefinition legJoint2 = abdomen.m_171599_("leg_joint2", CubeListBuilder.m_171558_().m_171514_(0, 0), PartPose.m_171419_((float)1.5f, (float)0.0f, (float)0.75f));
        PartDefinition leg1 = legJoint1.m_171599_("leg1", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 24.0f, 3.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition leg2 = legJoint2.m_171599_("leg2", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171480_().m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 24.0f, 3.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        leg1.m_171599_("fore_leg1", CubeListBuilder.m_171558_().m_171514_(12, 34).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 24.0f, 3.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)23.0f, (float)0.0f));
        leg2.m_171599_("fore_leg2", CubeListBuilder.m_171558_().m_171514_(12, 34).m_171480_().m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 24.0f, 3.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)23.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)64);
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.pelvis.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    public void setupAnim(MutantEnderman entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setAngles();
        this.animate(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float armScale = entityIn.getArmScale(this.partialTick);
        MutantEndermanModel.setModelPartScale(this.lowerRightArm.arm, armScale);
        MutantEndermanModel.setModelPartScale(this.lowerLeftArm.arm, armScale);
    }

    private static void setModelPartScale(ModelPart modelPart, float scale) {
        if (scale != 0.0f) {
            modelPart.f_104207_ = true;
            modelPart.f_233554_ = modelPart.f_233555_ = scale;
            modelPart.f_233553_ = modelPart.f_233555_;
        } else {
            modelPart.f_104207_ = false;
        }
    }

    private void setAngles() {
        this.pelvis.f_104201_ = -15.5f;
        this.abdomen.f_104203_ = 0.31415927f;
        this.chest.f_104203_ = 0.3926991f;
        this.chest.f_104204_ = 0.0f;
        this.chest.f_104205_ = 0.0f;
        this.neck.f_104203_ = 0.19634955f;
        this.neck.f_104205_ = 0.0f;
        this.head.f_104203_ = -0.7853982f;
        this.head.f_104204_ = 0.0f;
        this.head.f_104205_ = 0.0f;
        this.mouth.f_104203_ = 0.0f;
        this.rightArm.setAngles();
        this.leftArm.setAngles();
        this.lowerRightArm.setAngles();
        this.lowerRightArm.arm.f_104203_ += 0.1f;
        this.lowerRightArm.arm.f_104205_ -= 0.2f;
        this.lowerLeftArm.setAngles();
        this.lowerLeftArm.arm.f_104203_ += 0.1f;
        this.lowerLeftArm.arm.f_104205_ += 0.2f;
        this.legJoint1.f_104203_ = 0.0f;
        this.legJoint2.f_104203_ = 0.0f;
        this.leg1.f_104203_ = -0.8975979f;
        this.leg1.f_104204_ = 0.0f;
        this.leg1.f_104205_ = 0.2617994f;
        this.leg2.f_104203_ = -0.8975979f;
        this.leg2.f_104204_ = 0.0f;
        this.leg2.f_104205_ = -0.2617994f;
        this.foreLeg1.f_104203_ = 0.7853982f;
        this.foreLeg1.f_104205_ = -0.1308997f;
        this.foreLeg2.f_104203_ = 0.7853982f;
        this.foreLeg2.f_104205_ = 0.1308997f;
    }

    private void animate(MutantEnderman enderman, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float scale;
        int arm;
        float walkSpeed = 0.3f;
        float walkAnim1 = (Mth.m_14031_((float)((limbSwing - 0.8f) * walkSpeed)) + 0.8f) * limbSwingAmount;
        float walkAnim2 = -(Mth.m_14031_((float)((limbSwing + 0.8f) * walkSpeed)) - 0.8f) * limbSwingAmount;
        float walkAnim3 = (Mth.m_14031_((float)((limbSwing + 0.8f) * walkSpeed)) - 0.8f) * limbSwingAmount;
        float walkAnim4 = -(Mth.m_14031_((float)((limbSwing - 0.8f) * walkSpeed)) + 0.8f) * limbSwingAmount;
        float[] walkAnim = new float[5];
        Arrays.fill(walkAnim, Mth.m_14031_((float)(limbSwing * walkSpeed)) * limbSwingAmount);
        float breatheAnim = Mth.m_14031_((float)(ageInTicks * 0.15f));
        float faceYaw = netHeadYaw * (float)Math.PI / 180.0f;
        float facePitch = headPitch * (float)Math.PI / 180.0f;
        for (arm = 0; arm < 4; ++arm) {
            if (enderman.getHeldBlock(arm) <= 0) continue;
            this.animateHoldBlock(enderman.getHeldBlockTick(arm), arm, enderman.hasTarget > 0);
            int n = arm;
            walkAnim[n] = walkAnim[n] * 0.4f;
        }
        if (enderman.getAnimation() == MutantEnderman.MELEE_ANIMATION) {
            arm = enderman.getActiveArm();
            this.animateMelee(enderman.getAnimationTick(), arm);
            walkAnim[arm] = 0.0f;
        }
        if (enderman.getAnimation() == MutantEnderman.THROW_ANIMATION) {
            this.animateThrowBlock(enderman.getAnimationTick(), enderman.getActiveArm());
        }
        if (enderman.getAnimation() == MutantEnderman.SCREAM_ANIMATION) {
            this.animateScream(enderman.getAnimationTick());
            scale = 1.0f - Mth.m_14036_((float)((float)enderman.getAnimationTick() / 6.0f), (float)0.0f, (float)1.0f);
            faceYaw *= scale;
            facePitch *= scale;
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            walkAnim3 *= scale;
            walkAnim4 *= scale;
            Arrays.fill(walkAnim, 0.0f);
        }
        if (enderman.getAnimation() == MutantEnderman.TELESMASH_ANIMATION) {
            this.animateTeleSmash(enderman.getAnimationTick());
        }
        if (enderman.getAnimation() == MutantEnderman.DEATH_ANIMATION) {
            this.animateDeath(enderman.f_20919_);
            scale = 1.0f - Mth.m_14036_((float)((float)enderman.f_20919_ / 6.0f), (float)0.0f, (float)1.0f);
            faceYaw *= scale;
            facePitch *= scale;
            walkAnim1 *= scale;
            walkAnim2 *= scale;
            walkAnim3 *= scale;
            walkAnim4 *= scale;
            Arrays.fill(walkAnim, 0.0f);
        }
        this.head.f_104203_ += facePitch * 0.5f;
        this.head.f_104204_ += faceYaw * 0.7f;
        this.head.f_104205_ -= faceYaw * 0.7f;
        this.neck.f_104203_ += facePitch * 0.3f;
        this.chest.f_104203_ += facePitch * 0.2f;
        this.mouth.f_104203_ += breatheAnim * 0.02f + 0.02f;
        this.neck.f_104203_ -= breatheAnim * 0.02f;
        this.rightArm.arm.f_104205_ += breatheAnim * 0.004f;
        this.leftArm.arm.f_104205_ -= breatheAnim * 0.004f;
        for (ModelPart finger : this.rightArm.finger) {
            finger.f_104205_ += breatheAnim * 0.05f;
        }
        this.rightArm.thumb.f_104205_ -= breatheAnim * 0.05f;
        for (ModelPart finger : this.leftArm.finger) {
            finger.f_104205_ -= breatheAnim * 0.05f;
        }
        this.leftArm.thumb.f_104205_ += breatheAnim * 0.05f;
        this.lowerRightArm.arm.f_104205_ += breatheAnim * 0.002f;
        this.lowerLeftArm.arm.f_104205_ -= breatheAnim * 0.002f;
        for (ModelPart finger : this.lowerRightArm.finger) {
            finger.f_104205_ += breatheAnim * 0.02f;
        }
        this.lowerRightArm.thumb.f_104205_ -= breatheAnim * 0.02f;
        for (ModelPart finger : this.lowerLeftArm.finger) {
            finger.f_104205_ -= breatheAnim * 0.02f;
        }
        this.lowerLeftArm.thumb.f_104205_ += breatheAnim * 0.02f;
        this.pelvis.f_104201_ -= Math.abs(walkAnim[4]);
        this.chest.f_104204_ -= walkAnim[4] * 0.06f;
        this.rightArm.arm.f_104203_ -= walkAnim[0] * 0.6f;
        this.leftArm.arm.f_104203_ += walkAnim[1] * 0.6f;
        this.rightArm.foreArm.f_104203_ -= walkAnim[0] * 0.2f;
        this.leftArm.foreArm.f_104203_ += walkAnim[1] * 0.2f;
        this.lowerRightArm.arm.f_104203_ -= walkAnim[2] * 0.3f;
        this.lowerLeftArm.arm.f_104203_ += walkAnim[3] * 0.3f;
        this.lowerRightArm.foreArm.f_104203_ -= walkAnim[2] * 0.1f;
        this.lowerLeftArm.foreArm.f_104203_ += walkAnim[3] * 0.1f;
        this.legJoint1.f_104203_ += walkAnim1 * 0.6f;
        this.legJoint2.f_104203_ += walkAnim2 * 0.6f;
        this.foreLeg1.f_104203_ += walkAnim3 * 0.3f;
        this.foreLeg2.f_104203_ += walkAnim4 * 0.3f;
    }

    private void animateHoldBlock(int fullTick, int armID, boolean hasTarget) {
        float tick = ((float)fullTick + this.partialTick) / 10.0f;
        if (!hasTarget) {
            tick = fullTick == 0 ? 0.0f : ((float)fullTick - this.partialTick) / 10.0f;
        }
        float f = Mth.m_14031_((float)(tick * (float)Math.PI / 2.0f));
        if (armID == 0) {
            this.rightArm.arm.f_104205_ += f * 0.8f;
            this.rightArm.foreArm.f_104205_ += f * 0.6f;
            this.rightArm.hand.f_104204_ += f * 0.8f;
            this.rightArm.finger[0].f_104203_ += -f * 0.2f;
            this.rightArm.finger[2].f_104203_ += f * 0.2f;
            for (ModelPart finger : this.rightArm.finger) {
                finger.f_104205_ += f * 0.6f;
            }
            this.rightArm.thumb.f_104205_ += -f * 0.4f;
        } else if (armID == 1) {
            this.leftArm.arm.f_104205_ += -f * 0.8f;
            this.leftArm.foreArm.f_104205_ += -f * 0.6f;
            this.leftArm.hand.f_104204_ += -f * 0.8f;
            this.leftArm.finger[0].f_104203_ += -f * 0.2f;
            this.leftArm.finger[2].f_104203_ += f * 0.2f;
            for (ModelPart finger : this.leftArm.finger) {
                finger.f_104205_ += -f * 0.6f;
            }
            this.leftArm.thumb.f_104205_ += f * 0.4f;
        } else if (armID == 2) {
            this.lowerRightArm.arm.f_104205_ += f * 0.5f;
            this.lowerRightArm.foreArm.f_104205_ += f * 0.4f;
            this.lowerRightArm.hand.f_104204_ += f * 0.4f;
            this.lowerRightArm.finger[0].f_104203_ += -f * 0.2f;
            this.lowerRightArm.finger[2].f_104203_ += f * 0.2f;
            for (ModelPart finger : this.lowerRightArm.finger) {
                finger.f_104205_ += f * 0.6f;
            }
            this.lowerRightArm.thumb.f_104205_ += -f * 0.4f;
        } else if (armID == 3) {
            this.lowerLeftArm.arm.f_104205_ += -f * 0.5f;
            this.lowerLeftArm.foreArm.f_104205_ += -f * 0.4f;
            this.lowerLeftArm.hand.f_104204_ += -f * 0.4f;
            this.lowerLeftArm.finger[0].f_104203_ += -f * 0.2f;
            this.lowerLeftArm.finger[2].f_104203_ += f * 0.2f;
            for (ModelPart finger : this.lowerLeftArm.finger) {
                finger.f_104205_ += -f * 0.6f;
            }
            this.lowerLeftArm.thumb.f_104205_ += f * 0.4f;
        }
    }

    private void animateMelee(int fullTick, int armID) {
        int right = (armID & 1) == 0 ? 1 : -1;
        Arm arm = this.getArmFromID(armID);
        if (fullTick < 2) {
            float tick = ((float)fullTick + this.partialTick) / 2.0f;
            float f = Mth.m_14031_((float)(tick * (float)Math.PI / 2.0f));
            ModelPart var10000 = arm.arm;
            var10000.f_104203_ += f * 0.2f;
            ModelPart var8 = arm.finger[0];
            var8.f_104205_ += f * 0.3f * (float)right;
            var8 = arm.finger[1];
            var8.f_104205_ += f * 0.3f * (float)right;
            var8 = arm.finger[2];
            var8.f_104205_ += f * 0.3f * (float)right;
            var8 = arm.foreFinger[0];
            var8.f_104205_ += -f * 0.5f * (float)right;
            var8 = arm.foreFinger[1];
            var8.f_104205_ += -f * 0.5f * (float)right;
            var8 = arm.foreFinger[2];
            var8.f_104205_ += -f * 0.5f * (float)right;
        } else if (fullTick < 5) {
            float tick = ((float)(fullTick - 2) + this.partialTick) / 3.0f;
            float f = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
            float f1 = Mth.m_14031_((float)(tick * (float)Math.PI / 2.0f));
            this.chest.f_104204_ += -f1 * 0.1f * (float)right;
            ModelPart var10000 = arm.arm;
            var10000.f_104203_ += f * 1.1f - 1.1f;
            ModelPart var8 = arm.foreArm;
            var8.f_104203_ += -f * 0.4f;
            var8 = arm.finger[0];
            var8.f_104205_ += 0.3f * (float)right;
            var8 = arm.finger[1];
            var8.f_104205_ += 0.3f * (float)right;
            var8 = arm.finger[2];
            var8.f_104205_ += 0.3f * (float)right;
            var8 = arm.foreFinger[0];
            var8.f_104205_ += -0.5f * (float)right;
            var8 = arm.foreFinger[1];
            var8.f_104205_ += -0.5f * (float)right;
            var8 = arm.foreFinger[2];
            var8.f_104205_ += -0.5f * (float)right;
        } else if (fullTick < 6) {
            this.chest.f_104204_ += -0.1f * (float)right;
            ModelPart var10000 = arm.arm;
            var10000.f_104203_ += -1.1f;
            ModelPart var8 = arm.foreArm;
            var8.f_104203_ += -0.4f;
            var8 = arm.finger[0];
            var8.f_104205_ += 0.3f * (float)right;
            var8 = arm.finger[1];
            var8.f_104205_ += 0.3f * (float)right;
            var8 = arm.finger[2];
            var8.f_104205_ += 0.3f * (float)right;
            var8 = arm.foreFinger[0];
            var8.f_104205_ += -0.5f * (float)right;
            var8 = arm.foreFinger[1];
            var8.f_104205_ += -0.5f * (float)right;
            var8 = arm.foreFinger[2];
            var8.f_104205_ += -0.5f * (float)right;
        } else if (fullTick < 10) {
            float tick = ((float)(fullTick - 6) + this.partialTick) / 4.0f;
            float f = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
            this.chest.f_104204_ += -f * 0.1f * (float)right;
            ModelPart var10000 = arm.arm;
            var10000.f_104203_ += -f * 1.1f;
            ModelPart var8 = arm.foreArm;
            var8.f_104203_ += -f * 0.4f;
            var8 = arm.finger[0];
            var8.f_104205_ += f * 0.3f * (float)right;
            var8 = arm.finger[1];
            var8.f_104205_ += f * 0.3f * (float)right;
            var8 = arm.finger[2];
            var8.f_104205_ += f * 0.3f * (float)right;
            var8 = arm.foreFinger[0];
            var8.f_104205_ += -f * 0.5f * (float)right;
            var8 = arm.foreFinger[1];
            var8.f_104205_ += -f * 0.5f * (float)right;
            var8 = arm.foreFinger[2];
            var8.f_104205_ += -f * 0.5f * (float)right;
        }
    }

    private void animateThrowBlock(int fullTick, int armID) {
        if (armID == 0) {
            if (fullTick < 4) {
                float tick = ((float)fullTick + this.partialTick) / 4.0f;
                float f = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
                float f1 = Mth.m_14031_((float)(tick * (float)Math.PI / 2.0f));
                this.rightArm.arm.f_104203_ += -f1 * 1.5f;
                this.rightArm.arm.f_104205_ += f * 0.8f;
                this.rightArm.foreArm.f_104205_ += f * 0.6f;
                this.rightArm.hand.f_104204_ += f * 0.8f;
                this.rightArm.finger[0].f_104203_ += -f * 0.2f;
                this.rightArm.finger[2].f_104203_ += f * 0.2f;
                for (ModelPart finger : this.rightArm.finger) {
                    finger.f_104205_ += f * 0.6f;
                }
                this.rightArm.thumb.f_104205_ += -f * 0.4f;
            } else if (fullTick < 7) {
                this.rightArm.arm.f_104203_ += -1.5f;
            } else if (fullTick < 14) {
                float tick = ((float)(fullTick - 7) + this.partialTick) / 7.0f;
                float f = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
                this.rightArm.arm.f_104203_ += -f * 1.5f;
            }
        } else if (armID == 1) {
            if (fullTick < 4) {
                float tick = ((float)fullTick + this.partialTick) / 4.0f;
                float f = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
                float f1 = Mth.m_14031_((float)(tick * (float)Math.PI / 2.0f));
                this.leftArm.arm.f_104203_ += -f1 * 1.5f;
                this.leftArm.arm.f_104205_ += -f * 0.8f;
                this.leftArm.foreArm.f_104205_ += -f * 0.6f;
                this.leftArm.hand.f_104204_ += -f * 0.8f;
                this.leftArm.finger[0].f_104203_ += -f * 0.2f;
                this.leftArm.finger[2].f_104203_ += f * 0.2f;
                for (int var8 = 0; var8 < this.leftArm.finger.length; ++var8) {
                    ModelPart finger = this.leftArm.finger[var8];
                    finger.f_104205_ += -f * 0.6f;
                }
                this.leftArm.thumb.f_104205_ += f * 0.4f;
            } else if (fullTick < 7) {
                this.leftArm.arm.f_104203_ += -1.5f;
            } else if (fullTick < 14) {
                float tick = ((float)(fullTick - 7) + this.partialTick) / 7.0f;
                float f = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
                this.leftArm.arm.f_104203_ += -f * 1.5f;
            }
        } else if (armID == 2) {
            if (fullTick < 4) {
                float tick = ((float)fullTick + this.partialTick) / 4.0f;
                float f = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
                float f1 = Mth.m_14031_((float)(tick * (float)Math.PI / 2.0f));
                this.lowerRightArm.arm.f_104203_ += -f1 * 1.5f;
                this.lowerRightArm.arm.f_104205_ += f * 0.5f;
                this.lowerRightArm.foreArm.f_104205_ += f * 0.4f;
                this.lowerRightArm.hand.f_104204_ += f * 0.4f;
                this.lowerRightArm.finger[0].f_104203_ += -f * 0.2f;
                this.lowerRightArm.finger[2].f_104203_ += f * 0.2f;
                for (ModelPart finger : this.lowerRightArm.finger) {
                    finger.f_104205_ += f * 0.6f;
                }
                this.lowerRightArm.thumb.f_104205_ += -f * 0.4f;
            } else if (fullTick < 7) {
                this.lowerRightArm.arm.f_104203_ += -1.5f;
            } else if (fullTick < 14) {
                float tick = ((float)(fullTick - 7) + this.partialTick) / 7.0f;
                float f = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
                this.lowerRightArm.arm.f_104203_ += -f * 1.5f;
            }
        } else if (armID == 3) {
            if (fullTick < 4) {
                float tick = ((float)fullTick + this.partialTick) / 4.0f;
                float f = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
                float f1 = Mth.m_14031_((float)(tick * (float)Math.PI / 2.0f));
                this.lowerLeftArm.arm.f_104203_ += -f1 * 1.5f;
                this.lowerLeftArm.arm.f_104205_ += -f * 0.5f;
                this.lowerLeftArm.foreArm.f_104205_ += -f * 0.4f;
                this.lowerLeftArm.hand.f_104204_ += -f * 0.4f;
                this.lowerLeftArm.finger[0].f_104203_ += -f * 0.2f;
                this.lowerLeftArm.finger[2].f_104203_ += f * 0.2f;
                for (ModelPart finger : this.lowerLeftArm.finger) {
                    finger.f_104205_ += -f * 0.6f;
                }
                this.lowerLeftArm.thumb.f_104205_ += f * 0.4f;
            } else if (fullTick < 7) {
                this.lowerLeftArm.arm.f_104203_ += -1.5f;
            } else if (fullTick < 14) {
                float tick = ((float)(fullTick - 7) + this.partialTick) / 7.0f;
                float f = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
                this.lowerLeftArm.arm.f_104203_ += -f * 1.5f;
            }
        }
    }

    private void animateScream(int fullTick) {
        if (fullTick < 35) {
            int i;
            float tick = ((float)fullTick + this.partialTick) / 35.0f;
            float f = Mth.m_14031_((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.f_104203_ += f * 0.3f;
            this.chest.f_104203_ += f * 0.4f;
            this.neck.f_104203_ += f * 0.2f;
            this.head.f_104203_ += f * 0.3f;
            this.rightArm.arm.f_104203_ += -f * 0.6f;
            this.rightArm.arm.f_104204_ += f * 0.4f;
            this.rightArm.foreArm.f_104203_ += -f * 0.8f;
            this.rightArm.hand.f_104205_ += -f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.rightArm.finger[i].f_104205_ += f * 0.3f;
                this.rightArm.foreFinger[i].f_104205_ += -f * 0.5f;
            }
            this.leftArm.arm.f_104203_ += -f * 0.6f;
            this.leftArm.arm.f_104204_ += -f * 0.4f;
            this.leftArm.foreArm.f_104203_ += -f * 0.8f;
            this.leftArm.hand.f_104205_ += f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.leftArm.finger[i].f_104205_ += -f * 0.3f;
                this.leftArm.foreFinger[i].f_104205_ += f * 0.5f;
            }
            this.lowerRightArm.arm.f_104203_ += -f * 0.4f;
            this.lowerRightArm.arm.f_104204_ += f * 0.2f;
            this.lowerRightArm.foreArm.f_104203_ += -f * 0.8f;
            this.lowerRightArm.hand.f_104205_ += -f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerRightArm.finger[i].f_104205_ += f * 0.3f;
                this.lowerRightArm.foreFinger[i].f_104205_ += -f * 0.5f;
            }
            this.lowerLeftArm.arm.f_104203_ += -f * 0.4f;
            this.lowerLeftArm.arm.f_104204_ += -f * 0.2f;
            this.lowerLeftArm.foreArm.f_104203_ += -f * 0.8f;
            this.lowerLeftArm.hand.f_104205_ += f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerLeftArm.finger[i].f_104205_ += -f * 0.3f;
                this.lowerLeftArm.foreFinger[i].f_104205_ += f * 0.5f;
            }
        } else if (fullTick < 40) {
            int i;
            this.abdomen.f_104203_ += 0.3f;
            this.chest.f_104203_ += 0.4f;
            this.neck.f_104203_ += 0.2f;
            this.head.f_104203_ += 0.3f;
            this.rightArm.arm.f_104203_ += -0.6f;
            this.rightArm.arm.f_104204_ += 0.4f;
            this.rightArm.foreArm.f_104203_ += -0.8f;
            this.rightArm.hand.f_104205_ += -0.4f;
            for (i = 0; i < 3; ++i) {
                this.rightArm.finger[i].f_104205_ += 0.3f;
                this.rightArm.foreFinger[i].f_104205_ += -0.5f;
            }
            this.leftArm.arm.f_104203_ += -0.6f;
            this.leftArm.arm.f_104204_ += -0.4f;
            this.leftArm.foreArm.f_104203_ += -0.8f;
            this.leftArm.hand.f_104205_ += 0.4f;
            for (i = 0; i < 3; ++i) {
                this.leftArm.finger[i].f_104205_ += -0.3f;
                this.leftArm.foreFinger[i].f_104205_ += 0.5f;
            }
            this.lowerRightArm.arm.f_104203_ += -0.4f;
            this.lowerRightArm.arm.f_104204_ += 0.2f;
            this.lowerRightArm.foreArm.f_104203_ += -0.8f;
            this.lowerRightArm.hand.f_104205_ += -0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerRightArm.finger[i].f_104205_ += 0.3f;
                this.lowerRightArm.foreFinger[i].f_104205_ += -0.5f;
            }
            this.lowerLeftArm.arm.f_104203_ += -0.4f;
            this.lowerLeftArm.arm.f_104204_ += -0.2f;
            this.lowerLeftArm.foreArm.f_104203_ += -0.8f;
            this.lowerLeftArm.hand.f_104205_ += 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerLeftArm.finger[i].f_104205_ += -0.3f;
                this.lowerLeftArm.foreFinger[i].f_104205_ += 0.5f;
            }
        } else if (fullTick < 44) {
            int i;
            float tick = ((float)(fullTick - 40) + this.partialTick) / 4.0f;
            float f = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
            float f1 = Mth.m_14031_((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.f_104203_ += -f * 0.1f + 0.4f;
            this.chest.f_104203_ += f * 0.1f + 0.3f;
            this.chest.f_104205_ += f1 * 0.5f;
            this.neck.f_104203_ += f * 0.2f;
            this.neck.f_104205_ += f1 * 0.2f;
            this.head.f_104203_ += f * 1.2f - 0.8f;
            this.head.f_104205_ += f1 * 0.4f;
            this.mouth.f_104203_ += f1 * 0.6f;
            this.rightArm.arm.f_104203_ += -f * 0.6f;
            this.rightArm.arm.f_104204_ += 0.4f;
            this.rightArm.foreArm.f_104203_ += -f * 0.8f;
            this.rightArm.hand.f_104205_ += -f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.rightArm.finger[i].f_104205_ += f * 0.3f;
                this.rightArm.foreFinger[i].f_104205_ += -f * 0.5f;
            }
            this.leftArm.arm.f_104203_ += -f * 0.6f;
            this.leftArm.arm.f_104204_ += -0.4f;
            this.leftArm.foreArm.f_104203_ += -f * 0.8f;
            this.leftArm.hand.f_104205_ += f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.leftArm.finger[i].f_104205_ += -f * 0.3f;
                this.leftArm.foreFinger[i].f_104205_ += f * 0.5f;
            }
            this.lowerRightArm.arm.f_104203_ += -f * 0.4f;
            this.lowerRightArm.arm.f_104204_ += -f * 0.1f + 0.3f;
            this.lowerRightArm.foreArm.f_104203_ += -f * 0.8f;
            this.lowerRightArm.hand.f_104205_ += -f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerRightArm.finger[i].f_104205_ += f * 0.3f;
                this.lowerRightArm.foreFinger[i].f_104205_ += -f * 0.5f;
            }
            this.lowerLeftArm.arm.f_104203_ += -f * 0.4f;
            this.lowerLeftArm.arm.f_104204_ += f * 0.1f - 0.3f;
            this.lowerLeftArm.foreArm.f_104203_ += -f * 0.8f;
            this.lowerLeftArm.hand.f_104205_ += f * 0.4f;
            for (i = 0; i < 3; ++i) {
                this.lowerLeftArm.finger[i].f_104205_ += -f * 0.3f;
                this.lowerLeftArm.foreFinger[i].f_104205_ += f * 0.5f;
            }
            this.leg1.f_104205_ += f1 * 0.1f;
            this.leg2.f_104205_ += -f1 * 0.1f;
        } else if (fullTick < 155) {
            float tick = ((float)(fullTick - 44) + this.partialTick) / 111.0f;
            float f = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.f_104203_ += 0.4f;
            this.chest.f_104203_ += 0.3f;
            this.chest.f_104205_ += f - 0.5f;
            this.neck.f_104205_ += f * 0.4f - 0.2f;
            this.head.f_104203_ += -0.8f;
            this.head.f_104205_ += f * 0.8f - 0.4f;
            this.mouth.f_104203_ += 0.6f;
            this.rightArm.arm.f_104204_ += 0.4f;
            this.leftArm.arm.f_104204_ += -0.4f;
            this.lowerRightArm.arm.f_104204_ += 0.3f;
            this.lowerLeftArm.arm.f_104204_ += -0.3f;
            this.leg1.f_104205_ += 0.1f;
            this.leg2.f_104205_ += -0.1f;
        } else if (fullTick < 160) {
            float tick = ((float)(fullTick - 155) + this.partialTick) / 5.0f;
            float f = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.f_104203_ += f * 0.4f;
            this.chest.f_104203_ += f * 0.3f;
            this.chest.f_104205_ += -f * 0.5f;
            this.neck.f_104205_ += -f * 0.2f;
            this.head.f_104203_ += -f * 0.8f;
            this.head.f_104205_ += -f * 0.4f;
            this.mouth.f_104203_ += f * 0.6f;
            this.rightArm.arm.f_104204_ += f * 0.4f;
            this.leftArm.arm.f_104204_ += -f * 0.4f;
            this.lowerRightArm.arm.f_104204_ += f * 0.3f;
            this.lowerLeftArm.arm.f_104204_ += -f * 0.3f;
            this.leg1.f_104205_ += f * 0.1f;
            this.leg2.f_104205_ += -f * 0.1f;
        }
    }

    private void animateTeleSmash(int fullTick) {
        if (fullTick < 18) {
            float tick = ((float)fullTick + this.partialTick) / 18.0f;
            float f = Mth.m_14031_((float)(tick * (float)Math.PI / 2.0f));
            this.chest.f_104203_ += -f * 0.3f;
            this.rightArm.arm.f_104204_ += f * 0.2f;
            this.rightArm.arm.f_104205_ += f * 0.8f;
            this.rightArm.hand.f_104204_ += f * 1.7f;
            this.leftArm.arm.f_104204_ += -f * 0.2f;
            this.leftArm.arm.f_104205_ += -f * 0.8f;
            this.leftArm.hand.f_104204_ += -f * 1.7f;
            this.lowerRightArm.arm.f_104204_ += f * 0.2f;
            this.lowerRightArm.arm.f_104205_ += f * 0.6f;
            this.lowerRightArm.hand.f_104204_ += f * 1.7f;
            this.lowerLeftArm.arm.f_104204_ += -f * 0.2f;
            this.lowerLeftArm.arm.f_104205_ += -f * 0.6f;
            this.lowerLeftArm.hand.f_104204_ += -f * 1.7f;
        } else if (fullTick < 20) {
            float tick = ((float)(fullTick - 18) + this.partialTick) / 2.0f;
            float f = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
            float f1 = Mth.m_14031_((float)(tick * (float)Math.PI / 2.0f));
            this.chest.f_104203_ += -f * 0.3f;
            this.rightArm.arm.f_104203_ += -f1 * 0.8f;
            this.rightArm.arm.f_104204_ += 0.2f;
            this.rightArm.arm.f_104205_ += 0.8f;
            this.rightArm.hand.f_104204_ += 1.0f;
            this.leftArm.arm.f_104203_ += -f1 * 0.8f;
            this.leftArm.arm.f_104204_ += -0.2f;
            this.leftArm.arm.f_104205_ += -0.8f;
            this.leftArm.hand.f_104204_ += -1.7f;
            this.lowerRightArm.arm.f_104203_ += -f1 * 0.9f;
            this.lowerRightArm.arm.f_104204_ += 0.2f;
            this.lowerRightArm.arm.f_104205_ += 0.6f;
            this.lowerRightArm.hand.f_104204_ += 1.0f;
            this.lowerLeftArm.arm.f_104203_ += -f1 * 0.9f;
            this.lowerLeftArm.arm.f_104204_ += -0.2f;
            this.lowerLeftArm.arm.f_104205_ += -0.6f;
            this.lowerLeftArm.hand.f_104204_ += -1.7f;
        } else if (fullTick < 24) {
            this.rightArm.arm.f_104203_ += -0.8f;
            this.rightArm.arm.f_104204_ += 0.2f;
            this.rightArm.arm.f_104205_ += 0.8f;
            this.rightArm.hand.f_104204_ += 1.0f;
            this.leftArm.arm.f_104203_ += -0.8f;
            this.leftArm.arm.f_104204_ += -0.2f;
            this.leftArm.arm.f_104205_ += -0.8f;
            this.leftArm.hand.f_104204_ += -1.7f;
            this.lowerRightArm.arm.f_104203_ += -0.9f;
            this.lowerRightArm.arm.f_104204_ += 0.2f;
            this.lowerRightArm.arm.f_104205_ += 0.6f;
            this.lowerRightArm.hand.f_104204_ += 1.0f;
            this.lowerLeftArm.arm.f_104203_ += -0.9f;
            this.lowerLeftArm.arm.f_104204_ += -0.2f;
            this.lowerLeftArm.arm.f_104205_ += -0.6f;
            this.lowerLeftArm.hand.f_104204_ += -1.7f;
        } else if (fullTick < 30) {
            float tick = ((float)(fullTick - 24) + this.partialTick) / 6.0f;
            float f = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
            this.rightArm.arm.f_104203_ += -f * 0.8f;
            this.rightArm.arm.f_104204_ += f * 0.2f;
            this.rightArm.arm.f_104205_ += f * 0.8f;
            this.rightArm.hand.f_104204_ += f * 1.7f;
            this.leftArm.arm.f_104203_ += -f * 0.8f;
            this.leftArm.arm.f_104204_ += -f * 0.2f;
            this.leftArm.arm.f_104205_ += -f * 0.8f;
            this.leftArm.hand.f_104204_ += -f * 1.7f;
            this.lowerRightArm.arm.f_104203_ += -f * 0.9f;
            this.lowerRightArm.arm.f_104204_ += f * 0.2f;
            this.lowerRightArm.arm.f_104205_ += f * 0.6f;
            this.lowerRightArm.hand.f_104204_ += f * 1.7f;
            this.lowerLeftArm.arm.f_104203_ += -f * 0.9f;
            this.lowerLeftArm.arm.f_104204_ += -f * 0.2f;
            this.lowerLeftArm.arm.f_104205_ += -f * 0.6f;
            this.lowerLeftArm.hand.f_104204_ += -f * 1.7f;
        }
    }

    private void animateDeath(int deathTick) {
        if (deathTick < 80) {
            float tick = ((float)deathTick + this.partialTick) / 80.0f;
            float f = Mth.m_14031_((float)(tick * (float)Math.PI / 2.0f));
            this.head.f_104203_ += f * 0.4f;
            this.neck.f_104203_ += f * 0.3f;
            this.pelvis.f_104201_ += -f * 12.0f;
            this.rightArm.arm.f_104203_ += -f * 0.4f;
            this.rightArm.arm.f_104204_ += f * 0.4f;
            this.rightArm.arm.f_104205_ += f * 0.6f;
            this.rightArm.foreArm.f_104203_ += -f * 1.2f;
            this.leftArm.arm.f_104203_ += -f * 0.4f;
            this.leftArm.arm.f_104204_ += -f * 0.2f;
            this.leftArm.arm.f_104205_ += -f * 0.6f;
            this.leftArm.foreArm.f_104203_ += -f * 1.2f;
            this.lowerRightArm.arm.f_104203_ += -f * 0.4f;
            this.lowerRightArm.arm.f_104204_ += f * 0.4f;
            this.lowerRightArm.arm.f_104205_ += f * 0.6f;
            this.lowerRightArm.foreArm.f_104203_ += -f * 1.2f;
            this.lowerLeftArm.arm.f_104203_ += -f * 0.4f;
            this.lowerLeftArm.arm.f_104204_ += -f * 0.2f;
            this.lowerLeftArm.arm.f_104205_ += -f * 0.6f;
            this.lowerLeftArm.foreArm.f_104203_ += -f * 1.2f;
            this.leg1.f_104203_ += -f * 0.9f;
            this.leg1.f_104204_ += f * 0.3f;
            this.leg2.f_104203_ += -f * 0.9f;
            this.leg2.f_104204_ += -f * 0.3f;
            this.foreLeg1.f_104203_ += f * 1.6f;
            this.foreLeg2.f_104203_ += f * 1.6f;
        } else if (deathTick < 84) {
            float tick = ((float)(deathTick - 80) + this.partialTick) / 4.0f;
            float f = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
            float f1 = Mth.m_14031_((float)(tick * (float)Math.PI / 2.0f));
            this.head.f_104203_ += f * 0.4f;
            this.mouth.f_104203_ += f1 * 0.6f;
            this.neck.f_104203_ += f * 0.4f - 0.1f;
            this.chest.f_104203_ += -f1 * 0.8f;
            this.abdomen.f_104203_ += -f1 * 0.2f;
            this.pelvis.f_104201_ += -12.0f;
            this.rightArm.arm.f_104203_ += -f * 0.4f;
            this.rightArm.arm.f_104204_ += -f * 1.4f + 1.8f;
            this.rightArm.arm.f_104205_ += f * 0.6f;
            this.rightArm.foreArm.f_104203_ += -f * 1.2f;
            this.leftArm.arm.f_104203_ += -f * 0.4f;
            this.leftArm.arm.f_104204_ += f * 1.6f - 1.8f;
            this.leftArm.arm.f_104205_ += -f * 0.6f;
            this.leftArm.foreArm.f_104203_ += -f * 1.2f;
            this.lowerRightArm.arm.f_104203_ += -f * 0.5f + 0.1f;
            this.lowerRightArm.arm.f_104204_ += -f * 1.1f + 1.5f;
            this.lowerRightArm.arm.f_104205_ += f * 0.6f;
            this.lowerRightArm.foreArm.f_104203_ += -f * 1.2f;
            this.lowerLeftArm.arm.f_104203_ += -f * 0.5f + 0.1f;
            this.lowerLeftArm.arm.f_104204_ += f * 1.1f - 1.5f;
            this.lowerLeftArm.arm.f_104205_ += -f * 0.6f;
            this.lowerLeftArm.foreArm.f_104203_ += -f * 1.2f;
            this.leg1.f_104203_ += -f * 1.7f + 0.8f;
            this.leg1.f_104204_ += f * 0.3f;
            this.leg1.f_104205_ += f1 * 0.2f;
            this.leg2.f_104203_ += -f * 1.7f + 0.8f;
            this.leg2.f_104204_ += -f * 0.3f;
            this.leg2.f_104205_ += -f1 * 0.2f;
            this.foreLeg1.f_104203_ += f * 1.6f;
            this.foreLeg2.f_104203_ += f * 1.6f;
        } else {
            this.mouth.f_104203_ += 0.6f;
            this.neck.f_104203_ += -0.1f;
            this.chest.f_104203_ += -0.8f;
            this.abdomen.f_104203_ += -0.2f;
            this.pelvis.f_104201_ += -12.0f;
            this.rightArm.arm.f_104204_ += 1.0f;
            this.leftArm.arm.f_104204_ += -1.8f;
            this.lowerRightArm.arm.f_104203_ += 0.1f;
            this.lowerRightArm.arm.f_104204_ += 1.0f;
            this.lowerLeftArm.arm.f_104203_ += 0.1f;
            this.lowerLeftArm.arm.f_104204_ += -1.5f;
            this.leg1.f_104203_ += 0.8f;
            this.leg1.f_104205_ += 0.2f;
            this.leg2.f_104203_ += 0.8f;
            this.leg2.f_104205_ += -0.2f;
        }
    }

    private Arm getArmFromID(int armID) {
        return armID == 0 ? this.rightArm : (armID == 1 ? this.leftArm : (armID == 2 ? this.lowerRightArm : this.lowerLeftArm));
    }

    public void translateRotateArm(PoseStack matrixStackIn, int armID) {
        this.pelvis.m_104299_(matrixStackIn);
        this.abdomen.m_104299_(matrixStackIn);
        this.chest.m_104299_(matrixStackIn);
        this.getArmFromID(armID).translateRotate(matrixStackIn);
    }

    public void prepareMobModel(MutantEnderman entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.partialTick = partialTick;
    }

    static class Arm {
        private final ModelPart arm;
        private final ModelPart foreArm;
        private final ModelPart hand;
        private final ModelPart[] finger = new ModelPart[3];
        private final ModelPart[] foreFinger = new ModelPart[3];
        private final ModelPart thumb;
        private final boolean right;

        private Arm(String prefix, ModelPart modelPart, boolean right) {
            this.right = right;
            this.arm = modelPart.m_171324_(prefix + "arm");
            this.foreArm = this.arm.m_171324_(prefix + "fore_arm");
            this.hand = this.foreArm.m_171324_(prefix + "hand");
            for (int i = 0; i < 3; ++i) {
                this.finger[i] = this.hand.m_171324_(prefix + "finger" + i);
                this.foreFinger[i] = this.finger[i].m_171324_(prefix + "fore_finger" + i);
            }
            this.thumb = this.hand.m_171324_(prefix + "thumb");
        }

        static void createArmLayer(String prefix, PartDefinition root, boolean right, boolean lower) {
            PartDefinition arm = root.m_171599_(prefix + "arm", CubeListBuilder.m_171558_().m_171514_(92, 0).m_171488_(-1.5f, lower ? 6.0f : 0.0f, -1.5f, 3.0f, 22.0f, 3.0f, new CubeDeformation(0.1f)).m_171555_(!right), PartPose.m_171419_((float)(right ? -4.0f : 4.0f), (float)-14.0f, (float)0.0f));
            PartDefinition foreArm = arm.m_171599_(prefix + "fore_arm", CubeListBuilder.m_171558_().m_171514_(104, 0).m_171481_(-1.5f, 0.0f, -1.5f, 3.0f, 18.0f, 3.0f).m_171555_(!right), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)1.0f));
            PartDefinition hand = foreArm.m_171599_(prefix + "hand", CubeListBuilder.m_171558_().m_171514_(0, 0), PartPose.m_171419_((float)0.0f, (float)17.5f, (float)0.0f));
            for (int i = 0; i < 3; ++i) {
                PartPose partPose = i == 0 ? PartPose.m_171419_((float)(right ? -0.5f : 0.5f), (float)0.0f, (float)-1.0f) : (i == 1 ? PartPose.m_171419_((float)(right ? -0.5f : 0.5f), (float)0.0f, (float)0.0f) : PartPose.m_171419_((float)(right ? -0.5f : 0.5f), (float)0.0f, (float)1.0f));
                PartDefinition finger = hand.m_171599_(prefix + "finger" + i, CubeListBuilder.m_171558_().m_171514_(76, 0).m_171555_(!right).m_171488_(-0.5f, 0.0f, -0.5f, 1.0f, i == 1 ? 6.0f : 5.0f, 1.0f, new CubeDeformation(0.6f)), partPose);
                finger.m_171599_(prefix + "fore_finger" + i, CubeListBuilder.m_171558_().m_171514_(76, 0).m_171555_(!right).m_171488_(-0.5f, 0.0f, -0.5f, 1.0f, i == 1 ? 6.0f : 5.0f, 1.0f, new CubeDeformation(0.59000003f)), PartPose.m_171419_((float)0.0f, (float)(0.5f + (float)(i == 1 ? 6 : 5)), (float)0.0f));
            }
            hand.m_171599_(prefix + "thumb", CubeListBuilder.m_171558_().m_171514_(76, 0).m_171555_(right).m_171488_(-0.5f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.6f)), PartPose.m_171419_((float)(right ? 0.5f : -0.5f), (float)0.0f, (float)-0.5f));
        }

        private void setAngles() {
            Animator.resetAngles(this.arm);
            Animator.resetAngles(this.foreArm);
            Animator.resetAngles(this.hand);
            for (int i = 0; i < this.finger.length; ++i) {
                Animator.resetAngles(this.finger[i]);
                Animator.resetAngles(this.foreFinger[i]);
            }
            Animator.resetAngles(this.thumb);
            if (this.right) {
                this.arm.f_104203_ = -0.5235988f;
                this.arm.f_104205_ = 0.5235988f;
                this.foreArm.f_104203_ = -0.62831855f;
                this.hand.f_104204_ = -0.3926991f;
                this.finger[0].f_104203_ = -0.2617994f;
                this.finger[1].f_104205_ = 0.17453294f;
                this.finger[2].f_104203_ = 0.2617994f;
                this.foreFinger[0].f_104205_ = -0.2617994f;
                this.foreFinger[1].f_104205_ = -0.3926991f;
                this.foreFinger[2].f_104205_ = -0.2617994f;
                this.thumb.f_104203_ = -0.62831855f;
                this.thumb.f_104205_ = -0.3926991f;
            } else {
                this.arm.f_104203_ = -0.5235988f;
                this.arm.f_104205_ = -0.5235988f;
                this.foreArm.f_104203_ = -0.62831855f;
                this.hand.f_104204_ = 0.3926991f;
                this.finger[0].f_104203_ = -0.2617994f;
                this.finger[1].f_104205_ = -0.17453294f;
                this.finger[2].f_104203_ = 0.2617994f;
                this.foreFinger[0].f_104205_ = 0.2617994f;
                this.foreFinger[1].f_104205_ = 0.3926991f;
                this.foreFinger[2].f_104205_ = 0.2617994f;
                this.thumb.f_104203_ = -0.62831855f;
                this.thumb.f_104205_ = 0.3926991f;
            }
        }

        private void translateRotate(PoseStack matrixStackIn) {
            this.arm.m_104299_(matrixStackIn);
            this.foreArm.m_104299_(matrixStackIn);
            this.hand.m_104299_(matrixStackIn);
        }
    }
}

