/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironshulkerbox.common.block.entity;

import com.progwml6.ironshulkerbox.common.block.AbstractIronShulkerBoxBlock;
import com.progwml6.ironshulkerbox.common.block.IronShulkerBoxesTypes;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class AbstractIronShulkerBoxBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private final int[] slots;
    private NonNullList<ItemStack> itemStacks;
    private int openCount;
    private AnimationStatus animationStatus = AnimationStatus.CLOSED;
    private float progress;
    private float progressOld;
    @Nullable
    private final DyeColor color;
    private final IronShulkerBoxesTypes shulkerBoxType;

    public AbstractIronShulkerBoxBlockEntity(BlockEntityType<?> typeIn, BlockPos blockPos, BlockState blockState, @Nullable DyeColor colorIn, IronShulkerBoxesTypes shulkerBoxTypeIn) {
        super(typeIn, blockPos, blockState);
        this.slots = IntStream.range(0, shulkerBoxTypeIn.size).toArray();
        this.itemStacks = NonNullList.m_122780_((int)shulkerBoxTypeIn.size, (Object)ItemStack.f_41583_);
        this.color = colorIn;
        this.shulkerBoxType = shulkerBoxTypeIn;
    }

    public AbstractIronShulkerBoxBlockEntity(BlockEntityType<?> typeIn, BlockPos blockPos, BlockState blockState, IronShulkerBoxesTypes shulkerBoxTypeIn) {
        super(typeIn, blockPos, blockState);
        this.slots = IntStream.range(0, shulkerBoxTypeIn.size).toArray();
        this.itemStacks = NonNullList.m_122780_((int)shulkerBoxTypeIn.size, (Object)ItemStack.f_41583_);
        this.color = AbstractIronShulkerBoxBlock.getColorFromBlock(blockState.m_60734_());
        this.shulkerBoxType = shulkerBoxTypeIn;
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, AbstractIronShulkerBoxBlockEntity pBlockEntity) {
        pBlockEntity.updateAnimation(pLevel, pPos, pState);
    }

    protected void updateAnimation(Level pLevel, BlockPos pPos, BlockState pState) {
        this.progressOld = this.progress;
        switch (this.animationStatus) {
            case CLOSED: {
                this.progress = 0.0f;
                break;
            }
            case OPENING: {
                this.progress += 0.1f;
                if (this.progress >= 1.0f) {
                    this.animationStatus = AnimationStatus.OPENED;
                    this.progress = 1.0f;
                    AbstractIronShulkerBoxBlockEntity.doNeighborUpdates(pLevel, pPos, pState);
                }
                this.moveCollidedEntities(pLevel, pPos, pState);
                break;
            }
            case CLOSING: {
                this.progress -= 0.1f;
                if (!(this.progress <= 0.0f)) break;
                this.animationStatus = AnimationStatus.CLOSED;
                this.progress = 0.0f;
                AbstractIronShulkerBoxBlockEntity.doNeighborUpdates(pLevel, pPos, pState);
                break;
            }
            case OPENED: {
                this.progress = 1.0f;
            }
        }
    }

    public AnimationStatus getAnimationStatus() {
        return this.animationStatus;
    }

    public AABB getBoundingBox(BlockState pState) {
        return Shulker.m_149790_((Direction)((Direction)pState.m_61143_(AbstractIronShulkerBoxBlock.FACING)), (float)(0.5f * this.getProgress(1.0f)));
    }

    private void moveCollidedEntities(Level pLevel, BlockPos pPos, BlockState pState) {
        Direction direction;
        AABB aabb;
        List list;
        if (pState.m_60734_() instanceof AbstractIronShulkerBoxBlock && !(list = pLevel.m_45933_(null, aabb = Shulker.m_149793_((Direction)(direction = (Direction)pState.m_61143_(AbstractIronShulkerBoxBlock.FACING)), (float)this.progressOld, (float)this.progress).m_82338_(pPos))).isEmpty()) {
            for (Entity entity : list) {
                if (entity.m_7752_() == PushReaction.IGNORE) continue;
                entity.m_6478_(MoverType.SHULKER_BOX, new Vec3((aabb.m_82362_() + 0.01) * (double)direction.m_122429_(), (aabb.m_82376_() + 0.01) * (double)direction.m_122430_(), (aabb.m_82385_() + 0.01) * (double)direction.m_122431_()));
            }
        }
    }

    public int m_6643_() {
        return this.itemStacks.size();
    }

    public boolean m_7531_(int pId, int pType) {
        if (pId == 1) {
            this.openCount = pType;
            if (pType == 0) {
                this.animationStatus = AnimationStatus.CLOSING;
                AbstractIronShulkerBoxBlockEntity.doNeighborUpdates(this.m_58904_(), this.f_58858_, this.m_58900_());
            }
            if (pType == 1) {
                this.animationStatus = AnimationStatus.OPENING;
                AbstractIronShulkerBoxBlockEntity.doNeighborUpdates(this.m_58904_(), this.f_58858_, this.m_58900_());
            }
            return true;
        }
        return super.m_7531_(pId, pType);
    }

    private static void doNeighborUpdates(Level pLevel, BlockPos pPos, BlockState pState) {
        pState.m_60701_((LevelAccessor)pLevel, pPos, 3);
    }

    public void m_5856_(Player pPlayer) {
        if (!this.f_58859_ && !pPlayer.m_5833_()) {
            if (this.openCount < 0) {
                this.openCount = 0;
            }
            ++this.openCount;
            this.f_58857_.m_7696_(this.f_58858_, this.m_58900_().m_60734_(), 1, this.openCount);
            if (this.openCount == 1) {
                this.f_58857_.m_142346_((Entity)pPlayer, GameEvent.f_157803_, this.f_58858_);
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12409_, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
            }
        }
    }

    public void m_5785_(Player pPlayer) {
        if (!this.f_58859_ && !pPlayer.m_5833_()) {
            --this.openCount;
            this.f_58857_.m_7696_(this.f_58858_, this.m_58900_().m_60734_(), 1, this.openCount);
            if (this.openCount <= 0) {
                this.f_58857_.m_142346_((Entity)pPlayer, GameEvent.f_157802_, this.f_58858_);
                this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12408_, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
            }
        }
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.shulkerBox");
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.loadFromTag(pTag);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        if (!this.m_59634_(pTag)) {
            ContainerHelper.m_18976_((CompoundTag)pTag, this.itemStacks, (boolean)false);
        }
    }

    public void loadFromTag(CompoundTag pTag) {
        this.itemStacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(pTag) && pTag.m_128425_("Items", 9)) {
            ContainerHelper.m_18980_((CompoundTag)pTag, this.itemStacks);
        }
    }

    public NonNullList<ItemStack> m_7086_() {
        return this.itemStacks;
    }

    public void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.itemStacks = NonNullList.m_122780_((int)this.getShulkerBoxType().size, (Object)ItemStack.f_41583_);
        for (int i = 0; i < itemsIn.size(); ++i) {
            if (i >= this.itemStacks.size()) continue;
            this.m_7086_().set(i, (Object)((ItemStack)itemsIn.get(i)));
        }
    }

    public int[] m_7071_(Direction pSide) {
        return this.slots;
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return !(Block.m_49814_((Item)pItemStack.m_41720_()) instanceof ShulkerBoxBlock) || !(Block.m_49814_((Item)pItemStack.m_41720_()) instanceof AbstractIronShulkerBoxBlock);
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return true;
    }

    public float getProgress(float pPartialTicks) {
        return Mth.m_14179_((float)pPartialTicks, (float)this.progressOld, (float)this.progress);
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public boolean isClosed() {
        return this.animationStatus == AnimationStatus.CLOSED;
    }

    protected IItemHandler createUnSidedHandler() {
        return new SidedInvWrapper((WorldlyContainer)this, Direction.UP);
    }

    public IronShulkerBoxesTypes getShulkerBoxType() {
        IronShulkerBoxesTypes typeNew;
        IronShulkerBoxesTypes type = IronShulkerBoxesTypes.IRON;
        if (this.m_58898_() && (typeNew = AbstractIronShulkerBoxBlock.getTypeFromBlock(this.m_58900_().m_60734_())) != null) {
            type = typeNew;
        }
        return type;
    }

    public abstract Block getBlockToUse();

    public static int getOpenCount(BlockGetter blockGetter, BlockPos blockPos) {
        BlockEntity blockentity;
        BlockState blockstate = blockGetter.m_8055_(blockPos);
        if (blockstate.m_155947_() && (blockentity = blockGetter.m_7702_(blockPos)) instanceof AbstractIronShulkerBoxBlockEntity) {
            return ((AbstractIronShulkerBoxBlockEntity)blockentity).openCount;
        }
        return 0;
    }

    public static enum AnimationStatus {
        CLOSED,
        OPENING,
        OPENED,
        CLOSING;

    }
}

