/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.structure;

import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import net.minecraft.SharedConstants;
import net.minecraft.core.HolderGetter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.embeddedt.modernfix.util.FileUtil;

public class CachingStructureManager {
    private static ThreadLocal<MessageDigest> digestThreadLocal = ThreadLocal.withInitial(() -> {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    });
    private static final File STRUCTURE_CACHE_FOLDER = FileUtil.childFile(ModernFixPlatformHooks.INSTANCE.getGameDirectory().resolve("modernfix").resolve("structureCacheV1").toFile());
    private static final Set<String> laggyStructureMods;
    private static final int MAX_HASH_LENGTH = 9;

    public static StructureTemplate readStructure(ResourceLocation location, DataFixer datafixer, InputStream stream, HolderGetter<Block> blockGetter) throws IOException {
        CompoundTag tag = CachingStructureManager.readStructureTag(location, datafixer, stream);
        StructureTemplate template = new StructureTemplate();
        template.m_246595_(blockGetter, tag);
        return template;
    }

    private static String encodeHex(byte[] byteArray) {
        StringBuilder sb = new StringBuilder();
        for (byte b : byteArray) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private static String truncateHash(String hash) {
        return hash.substring(0, 10);
    }

    public static CompoundTag readStructureTag(ResourceLocation location, DataFixer datafixer, InputStream stream) throws IOException {
        int requiredMinimumDataVersion;
        int currentDataVersion;
        byte[] structureBytes = CachingStructureManager.toBytes(stream);
        CompoundTag currentTag = NbtIo.m_128939_((InputStream)new ByteArrayInputStream(structureBytes));
        if (!currentTag.m_128425_("DataVersion", 99)) {
            currentTag.m_128405_("DataVersion", 500);
        }
        if ((currentDataVersion = currentTag.m_128451_("DataVersion")) < (requiredMinimumDataVersion = SharedConstants.m_183709_().m_183476_().m_193006_())) {
            MessageDigest hasher = digestThreadLocal.get();
            hasher.reset();
            String hash = CachingStructureManager.encodeHex(hasher.digest(structureBytes));
            CompoundTag cachedUpgraded = CachingStructureManager.getCachedUpgraded(location, CachingStructureManager.truncateHash(hash));
            if (cachedUpgraded == null) {
                cachedUpgraded = CachingStructureManager.getCachedUpgraded(location, hash);
            }
            if (cachedUpgraded != null && cachedUpgraded.m_128451_("DataVersion") == requiredMinimumDataVersion) {
                ModernFix.LOGGER.debug("Using cached upgraded version of {}", (Object)location);
                currentTag = cachedUpgraded;
            } else {
                ModernFix.LOGGER.debug("Structure {} is being run through DFU (hash {}), this will cause launch time delays", (Object)location, (Object)hash);
                currentTag = DataFixTypes.STRUCTURE.m_264226_(datafixer, currentTag, currentDataVersion, SharedConstants.m_183709_().m_183476_().m_193006_());
                currentTag.m_128405_("DataVersion", SharedConstants.m_183709_().m_183476_().m_193006_());
                CachingStructureManager.saveCachedUpgraded(location, hash, currentTag);
            }
        }
        return currentTag;
    }

    private static File getCachePath(ResourceLocation location, String hash) {
        String fileName = location.m_135827_() + "_" + location.m_135815_().replace('/', '_') + "_" + hash + ".nbt";
        return new File(STRUCTURE_CACHE_FOLDER, fileName);
    }

    private static synchronized CompoundTag getCachedUpgraded(ResourceLocation location, String hash) {
        File theFile = CachingStructureManager.getCachePath(location, hash);
        try {
            return NbtIo.m_128937_((File)theFile);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static synchronized void saveCachedUpgraded(ResourceLocation location, String hash, CompoundTag tagToSave) {
        File theFile = CachingStructureManager.getCachePath(location, CachingStructureManager.truncateHash(hash));
        try {
            NbtIo.m_128944_((CompoundTag)tagToSave, (File)theFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static byte[] toBytes(InputStream stream) throws IOException {
        int n;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] tmp = new byte[16384];
        while ((n = stream.read(tmp, 0, tmp.length)) != -1) {
            buffer.write(tmp, 0, n);
        }
        return buffer.toByteArray();
    }

    static {
        STRUCTURE_CACHE_FOLDER.mkdirs();
        laggyStructureMods = new ObjectOpenHashSet();
    }
}

