/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FastForgeRegistry<V> {
    private final BiMap<Integer, V> ids;
    private final DataFieldBiMap<ResourceLocation> names;
    private final DataFieldBiMap<ResourceKey<V>> keys;
    private final DataFieldBiMap<?> owners;
    private final ResourceKey<Registry<V>> registryKey;
    private final ObjectArrayList<V> valuesById;
    private final Object2ObjectOpenHashMap<V, RegistryValueData> infoByValue;

    private void storeId(V value, int id) {
        RegistryValueData pair = (RegistryValueData)this.infoByValue.computeIfAbsent(value, k -> new RegistryValueData());
        pair.id = id;
    }

    private void updateInfoPairAndClearIfNull(V v, Consumer<RegistryValueData> consumer) {
        this.infoByValue.compute(v, (oldValue, oldPair) -> {
            if (oldPair == null) {
                oldPair = new RegistryValueData();
            }
            consumer.accept((RegistryValueData)oldPair);
            if (oldPair.isEmpty()) {
                return null;
            }
            return oldPair;
        });
    }

    private void ensureArrayCanFitId(int id) {
        int desiredSize = id + 1;
        while (this.valuesById.size() < desiredSize) {
            this.valuesById.add(null);
        }
    }

    public void clear() {
        this.infoByValue.clear();
        for (int i = 0; i < this.valuesById.size(); ++i) {
            this.valuesById.set(i, null);
        }
        this.names.clearUnsafe();
        this.keys.clearUnsafe();
        this.owners.clearUnsafe();
    }

    public FastForgeRegistry(ResourceKey<Registry<V>> registryKey) {
        this.registryKey = registryKey;
        this.valuesById = new ObjectArrayList();
        this.infoByValue = new Object2ObjectOpenHashMap();
        this.keys = new DataFieldBiMap<ResourceKey>(p -> p.key, (p, k) -> {
            p.key = k;
        });
        this.owners = new DataFieldBiMap<Object>(p -> p.overrideOwner, (p, k) -> {
            p.overrideOwner = k;
        });
        this.names = new DataFieldBiMap<ResourceLocation>(p -> p.location, (p, l) -> {
            p.location = l;
        });
        this.ids = new BiMap<Integer, V>(){

            @Nullable
            public V put(@Nullable Integer key, @Nullable V value) {
                RegistryValueData data = (RegistryValueData)FastForgeRegistry.this.infoByValue.get(value);
                int unboxedKey = key;
                if (data != null && data.id != -1 && data.id != unboxedKey) {
                    throw new IllegalArgumentException("Existing mapping for ID " + data.id + " value " + value + " when new ID " + unboxedKey + " was requested");
                }
                FastForgeRegistry.this.ensureArrayCanFitId(unboxedKey);
                Object oldValue = FastForgeRegistry.this.valuesById.set(unboxedKey, value);
                FastForgeRegistry.this.storeId(value, unboxedKey);
                return oldValue;
            }

            @Nullable
            public V forcePut(@Nullable Integer key, @Nullable V value) {
                FastForgeRegistry.this.ensureArrayCanFitId(key);
                Object oldValue = FastForgeRegistry.this.valuesById.set(key.intValue(), value);
                if (oldValue != null) {
                    FastForgeRegistry.this.updateInfoPairAndClearIfNull(oldValue, pair -> {
                        pair.id = -1;
                    });
                }
                FastForgeRegistry.this.storeId(value, key);
                return oldValue;
            }

            public void putAll(Map<? extends Integer, ? extends V> map) {
                map.forEach(this::put);
            }

            public Set<V> values() {
                return Collections.unmodifiableSet(FastForgeRegistry.this.infoByValue.keySet());
            }

            public BiMap<V, Integer> inverse() {
                return new BiMap<V, Integer>(){

                    @Nullable
                    public Integer put(@Nullable V key, @Nullable Integer value) {
                        throw new UnsupportedOperationException();
                    }

                    @Nullable
                    public Integer forcePut(@Nullable V key, @Nullable Integer value) {
                        throw new UnsupportedOperationException();
                    }

                    public void putAll(Map<? extends V, ? extends Integer> map) {
                        throw new UnsupportedOperationException();
                    }

                    public Set<Integer> values() {
                        throw new UnsupportedOperationException();
                    }

                    public BiMap<Integer, V> inverse() {
                        throw new UnsupportedOperationException();
                    }

                    public int size() {
                        throw new UnsupportedOperationException();
                    }

                    public boolean isEmpty() {
                        throw new UnsupportedOperationException();
                    }

                    public boolean containsKey(Object key) {
                        throw new UnsupportedOperationException();
                    }

                    public boolean containsValue(Object value) {
                        throw new UnsupportedOperationException();
                    }

                    public Integer get(Object key) {
                        RegistryValueData pair = (RegistryValueData)FastForgeRegistry.this.infoByValue.get(key);
                        if (pair == null) {
                            return null;
                        }
                        return pair.id == -1 ? null : Integer.valueOf(pair.id);
                    }

                    public Integer remove(Object key) {
                        RegistryValueData pair = (RegistryValueData)FastForgeRegistry.this.infoByValue.get(key);
                        if (pair == null) {
                            return null;
                        }
                        int id = pair.id;
                        if (id != -1) {
                            FastForgeRegistry.this.valuesById.set(id, null);
                        }
                        FastForgeRegistry.this.updateInfoPairAndClearIfNull(key, p -> {
                            p.id = -1;
                        });
                        return id == -1 ? null : Integer.valueOf(id);
                    }

                    public void clear() {
                        throw new UnsupportedOperationException();
                    }

                    @NotNull
                    public Set<V> keySet() {
                        throw new UnsupportedOperationException();
                    }

                    @NotNull
                    public Set<Map.Entry<V, Integer>> entrySet() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public int size() {
                return FastForgeRegistry.this.infoByValue.size();
            }

            public boolean isEmpty() {
                throw new UnsupportedOperationException();
            }

            public boolean containsKey(Object key) {
                throw new UnsupportedOperationException();
            }

            public boolean containsValue(Object value) {
                throw new UnsupportedOperationException();
            }

            public V get(Object key) {
                int id = (Integer)key;
                if (id < 0 || id >= FastForgeRegistry.this.valuesById.size()) {
                    return null;
                }
                return FastForgeRegistry.this.valuesById.get(id);
            }

            public V remove(Object key) {
                throw new UnsupportedOperationException();
            }

            public void clear() {
                FastForgeRegistry.this.valuesById.clear();
                FastForgeRegistry.this.infoByValue.values().removeIf(pair -> {
                    pair.id = -1;
                    return pair.isEmpty();
                });
            }

            @NotNull
            public Set<Integer> keySet() {
                throw new UnsupportedOperationException();
            }

            @NotNull
            public Set<Map.Entry<Integer, V>> entrySet() {
                throw new UnsupportedOperationException();
            }

            public void forEach(BiConsumer<? super Integer, ? super V> action) {
                for (int i = 0; i < FastForgeRegistry.this.valuesById.size(); ++i) {
                    Object val = FastForgeRegistry.this.valuesById.get(i);
                    if (val == null) continue;
                    action.accept(i, val);
                }
            }
        };
    }

    public void optimize() {
        this.keys.optimize();
        this.owners.optimize();
        this.names.optimize();
        this.infoByValue.trim();
    }

    public BiMap<Integer, V> getIds() {
        return this.ids;
    }

    public BiMap<ResourceKey<V>, V> getKeys() {
        return this.keys;
    }

    public BiMap<ResourceLocation, V> getNames() {
        return this.names;
    }

    public DataFieldBiMap<?> getOwners() {
        return this.owners;
    }

    static class RegistryValueData {
        public ResourceKey<?> key;
        public ResourceLocation location;
        public int id = -1;
        public Object overrideOwner;

        RegistryValueData() {
        }

        boolean isEmpty() {
            return this.key == null && this.location == null && this.id == -1 && this.overrideOwner == null;
        }
    }

    class DataFieldBiMap<K>
    implements BiMap<K, V> {
        public final Object2ObjectOpenHashMap<K, V> valuesByKey = new Object2ObjectOpenHashMap();
        private final Function<RegistryValueData, K> getter;
        private final BiConsumer<RegistryValueData, K> setter;
        private DataFieldBiMapInverse<K> inverse = null;

        public DataFieldBiMap(Function<RegistryValueData, K> getter, BiConsumer<RegistryValueData, K> setter) {
            this.getter = getter;
            this.setter = setter;
        }

        public void optimize() {
            this.valuesByKey.trim();
        }

        public void clearUnsafe() {
            this.valuesByKey.clear();
        }

        private V forcePut(@Nullable K key, @Nullable V value, boolean throwOnExisting) {
            RegistryValueData dataForValue;
            if (throwOnExisting && (dataForValue = (RegistryValueData)FastForgeRegistry.this.infoByValue.get(value)) != null && this.getter.apply(dataForValue) != null && !Objects.equals(this.getter.apply(dataForValue), key)) {
                throw new IllegalArgumentException("Existing mapping for key " + key + " value " + value);
            }
            Object oldValue = this.valuesByKey.put(key, value);
            if (oldValue != null) {
                FastForgeRegistry.this.updateInfoPairAndClearIfNull(oldValue, p -> this.setter.accept((RegistryValueData)p, (K)null));
            }
            FastForgeRegistry.this.updateInfoPairAndClearIfNull(value, p -> this.setter.accept((RegistryValueData)p, key));
            return oldValue;
        }

        @Nullable
        public V put(@Nullable K key, @Nullable V value) {
            return this.forcePut(key, value, true);
        }

        @Nullable
        public V forcePut(@Nullable K key, @Nullable V value) {
            return this.forcePut(key, value, false);
        }

        public void putAll(Map<? extends K, ? extends V> map) {
            map.forEach(this::put);
        }

        public Set<V> values() {
            return Collections.unmodifiableSet(FastForgeRegistry.this.infoByValue.keySet());
        }

        public BiMap<V, K> inverse() {
            if (this.inverse == null) {
                this.inverse = new DataFieldBiMapInverse(this);
            }
            return this.inverse;
        }

        public int size() {
            return this.valuesByKey.size();
        }

        public boolean isEmpty() {
            return this.valuesByKey.isEmpty();
        }

        public boolean containsKey(Object key) {
            return this.valuesByKey.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return FastForgeRegistry.this.infoByValue.containsKey(value);
        }

        public V get(Object key) {
            return this.valuesByKey.get(key);
        }

        public V remove(Object key) {
            Object value = this.get(key);
            if (value == null) {
                return null;
            }
            this.inverse().remove(value);
            return value;
        }

        public void clear() {
            this.valuesByKey.values().forEach(v -> FastForgeRegistry.this.updateInfoPairAndClearIfNull(v, p -> {
                p.key = null;
            }));
            this.valuesByKey.clear();
        }

        @NotNull
        public Set<K> keySet() {
            return Collections.unmodifiableSet(this.valuesByKey.keySet());
        }

        @NotNull
        public Set<Map.Entry<K, V>> entrySet() {
            return Collections.unmodifiableSet(this.valuesByKey.entrySet());
        }
    }

    class FastForgeRegistryLocationSet
    implements Set<ResourceLocation> {
        private final Set<ResourceKey<V>> backingSet;

        public FastForgeRegistryLocationSet(Set<ResourceKey<V>> backingSet) {
            this.backingSet = backingSet;
        }

        @Override
        public int size() {
            return this.backingSet.size();
        }

        @Override
        public boolean isEmpty() {
            return this.backingSet.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.backingSet.contains(ResourceKey.m_135785_(FastForgeRegistry.this.registryKey, (ResourceLocation)((ResourceLocation)o)));
        }

        @Override
        @NotNull
        public Iterator<ResourceLocation> iterator() {
            return Iterators.transform(this.backingSet.iterator(), ResourceKey::m_135782_);
        }

        @Override
        @NotNull
        public Object[] toArray() {
            Object[] keyArray = this.backingSet.toArray();
            for (int i = 0; i < keyArray.length; ++i) {
                keyArray[i] = ((ResourceKey)keyArray[i]).m_135782_();
            }
            return keyArray;
        }

        @Override
        @NotNull
        public <T> T[] toArray(@NotNull T[] a) {
            Object[] keyArray = this.backingSet.toArray();
            T[] finalArray = Arrays.copyOf(a, keyArray.length);
            for (int i = 0; i < keyArray.length; ++i) {
                finalArray[i] = ((ResourceKey)keyArray[i]).m_135782_();
            }
            return finalArray;
        }

        @Override
        public boolean add(ResourceLocation resourceLocation) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(@NotNull Collection<?> c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends ResourceLocation> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@NotNull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@NotNull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    class DataFieldBiMapInverse<K>
    implements BiMap<V, K> {
        private final DataFieldBiMap<K> forward;

        public DataFieldBiMapInverse(DataFieldBiMap<K> forward) {
            this.forward = forward;
        }

        @Nullable
        public K put(@Nullable V key, @Nullable K value) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public K forcePut(@Nullable V key, @Nullable K value) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map<? extends V, ? extends K> map) {
            throw new UnsupportedOperationException();
        }

        public Set<K> values() {
            throw new UnsupportedOperationException();
        }

        public BiMap<K, V> inverse() {
            return this.forward;
        }

        public int size() {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object key) {
            return FastForgeRegistry.this.infoByValue.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.forward.valuesByKey.containsKey(value);
        }

        public K get(Object key) {
            RegistryValueData pair = (RegistryValueData)FastForgeRegistry.this.infoByValue.get(key);
            if (pair == null) {
                return null;
            }
            return this.forward.getter.apply(pair);
        }

        public K remove(Object key) {
            RegistryValueData pair = (RegistryValueData)FastForgeRegistry.this.infoByValue.get(key);
            if (pair == null) {
                return null;
            }
            Object rk = this.forward.getter.apply(pair);
            this.forward.valuesByKey.remove(rk);
            FastForgeRegistry.this.updateInfoPairAndClearIfNull(key, p -> this.forward.setter.accept((RegistryValueData)p, null));
            return rk;
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public Set<V> keySet() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public Set<Map.Entry<V, K>> entrySet() {
            throw new UnsupportedOperationException();
        }
    }
}

