/*
 * Decompiled with CFR 0.152.
 */
package artifacts.forge.platform;

import artifacts.client.item.renderer.ArtifactRenderer;
import artifacts.component.SwimData;
import artifacts.forge.capability.SwimDataCapability;
import artifacts.item.wearable.WearableArtifactItem;
import artifacts.platform.PlatformHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class ForgePlatformHelper
implements PlatformHelper {
    @Override
    public boolean isEquippedBy(@Nullable LivingEntity entity, Item item) {
        return entity != null && CuriosApi.getCuriosHelper().findFirstCurio(entity, item).isPresent();
    }

    @Override
    public Stream<ItemStack> findAllEquippedBy(LivingEntity entity, Item item) {
        return CuriosApi.getCuriosHelper().findCurios(entity, item).stream().map(SlotResult::stack);
    }

    @Override
    public Attribute getStepHeightAttribute() {
        return (Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get();
    }

    @Override
    public Attribute getSwimSpeedAttribute() {
        return (Attribute)ForgeMod.SWIM_SPEED.get();
    }

    @Override
    public Attribute getEntityGravityAttribute() {
        return (Attribute)ForgeMod.ENTITY_GRAVITY.get();
    }

    @Override
    public boolean isCorrectTierForDrops(Tier tier, BlockState state) {
        return TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)state);
    }

    @Override
    @Nullable
    public SwimData getSwimData(LivingEntity player) {
        return (SwimData)player.getCapability(SwimDataCapability.CAPABILITY).orElse(null);
    }

    @Override
    public boolean isEyeInWater(Player player) {
        return player.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get());
    }

    @Override
    public void registerArtifactRenderer(WearableArtifactItem item, Supplier<ArtifactRenderer> rendererSupplier) {
        CuriosRendererRegistry.register((Item)item, () -> new ArtifactCurioRenderer((ArtifactRenderer)rendererSupplier.get()));
    }

    @Override
    @Nullable
    public ArtifactRenderer getArtifactRenderer(Item item) {
        Object t;
        Optional renderer = CuriosRendererRegistry.getRenderer((Item)item);
        if (renderer.isPresent() && (t = renderer.get()) instanceof ArtifactCurioRenderer) {
            ArtifactCurioRenderer artifactTrinketRenderer = (ArtifactCurioRenderer)t;
            return artifactTrinketRenderer.renderer();
        }
        return null;
    }

    private record ArtifactCurioRenderer(ArtifactRenderer renderer) implements ICurioRenderer
    {
        public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            this.renderer.render(stack, slotContext.entity(), slotContext.index(), poseStack, multiBufferSource, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

