/*
 * Decompiled with CFR 0.152.
 */
package artifacts.forge.curio;

import artifacts.item.wearable.WearableArtifactItem;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class WearableArtifactCurio
implements ICurio {
    private final WearableArtifactItem item;
    private final ItemStack stack;

    public WearableArtifactCurio(WearableArtifactItem item, ItemStack stack) {
        this.item = item;
        this.stack = stack;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public final void curioTick(SlotContext slotContext) {
        this.item.wornTick(slotContext.entity(), this.stack);
    }

    public void onEquip(SlotContext slotContext, ItemStack originalStack) {
        this.item.onEquip(slotContext.entity(), this.stack);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack) {
        this.item.onUnequip(slotContext.entity(), this.stack);
    }

    public final ICurio.SoundInfo getEquipSound(SlotContext slotContext) {
        return new ICurio.SoundInfo(this.item.getEquipSound(), 1.0f, 1.0f);
    }

    public boolean canEquipFromUse(SlotContext slotContext) {
        return true;
    }

    public int getFortuneLevel(SlotContext slotContext, @Nullable LootContext lootContext) {
        return this.item.getFortuneLevel();
    }

    public int getLootingLevel(SlotContext slotContext, DamageSource source, LivingEntity target, int baseLooting) {
        return this.item.getLootingLevel();
    }
}

