/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.item.renderer;

import artifacts.Artifacts;
import artifacts.client.item.model.ArmsModel;
import artifacts.client.item.renderer.ArtifactRenderer;
import artifacts.platform.PlatformServices;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class GloveArtifactRenderer
implements ArtifactRenderer {
    private final ResourceLocation defaultTexture;
    private final ResourceLocation slimTexture;
    private final ArmsModel defaultModel;
    private final ArmsModel slimModel;

    public GloveArtifactRenderer(String name, ArmsModel defaultModel, ArmsModel slimModel) {
        this(String.format("glove/%s/%s_default", name, name), String.format("glove/%s/%s_slim", name, name), defaultModel, slimModel);
    }

    public GloveArtifactRenderer(String defaultTexturePath, String slimTexturePath, ArmsModel defaultModel, ArmsModel slimModel) {
        this.defaultTexture = Artifacts.id("textures/entity/curio/%s.png", defaultTexturePath);
        this.slimTexture = Artifacts.id("textures/entity/curio/%s.png", slimTexturePath);
        this.defaultModel = defaultModel;
        this.slimModel = slimModel;
    }

    @Nullable
    public static GloveArtifactRenderer getGloveRenderer(ItemStack stack) {
        ArtifactRenderer artifactRenderer;
        if (!stack.m_41619_() && (artifactRenderer = PlatformServices.platformHelper.getArtifactRenderer(stack.m_41720_())) instanceof GloveArtifactRenderer) {
            GloveArtifactRenderer gloveRenderer = (GloveArtifactRenderer)artifactRenderer;
            return gloveRenderer;
        }
        return null;
    }

    protected ResourceLocation getTexture(boolean hasSlimArms) {
        return hasSlimArms ? this.slimTexture : this.defaultTexture;
    }

    protected ArmsModel getModel(boolean hasSlimArms) {
        return hasSlimArms ? this.slimModel : this.defaultModel;
    }

    protected static boolean hasSlimArms(Entity entity) {
        AbstractClientPlayer player;
        return entity instanceof AbstractClientPlayer && (player = (AbstractClientPlayer)entity).m_108564_().equals("slim");
    }

    @Override
    public void render(ItemStack stack, LivingEntity entity, int slotIndex, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean hasSlimArms = GloveArtifactRenderer.hasSlimArms((Entity)entity);
        ArmsModel model = this.getModel(hasSlimArms);
        InteractionHand hand = slotIndex % 2 == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        HumanoidArm handSide = hand == InteractionHand.MAIN_HAND ? entity.m_5737_() : entity.m_5737_().m_20828_();
        model.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        model.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
        ArtifactRenderer.followBodyRotations(entity, model);
        this.renderArm(model, poseStack, multiBufferSource, handSide, light, hasSlimArms, stack.m_41790_());
    }

    protected void renderArm(ArmsModel model, PoseStack matrixStack, MultiBufferSource buffer, HumanoidArm handSide, int light, boolean hasSlimArms, boolean hasFoil) {
        RenderType renderType = model.m_103119_(this.getTexture(hasSlimArms));
        VertexConsumer vertexBuilder = ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)renderType, (boolean)false, (boolean)hasFoil);
        model.renderArm(handSide, matrixStack, vertexBuilder, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public final void renderFirstPersonArm(PoseStack matrixStack, MultiBufferSource buffer, int light, AbstractClientPlayer player, HumanoidArm side, boolean hasFoil) {
        if (!player.m_5833_()) {
            boolean hasSlimArms = GloveArtifactRenderer.hasSlimArms((Entity)player);
            ArmsModel model = this.getModel(hasSlimArms);
            ModelPart arm = side == HumanoidArm.LEFT ? model.f_102812_ : model.f_102811_;
            model.m_8009_(false);
            arm.f_104207_ = true;
            model.f_102817_ = false;
            model.f_102818_ = 0.0f;
            model.f_102608_ = 0.0f;
            model.m_6973_((LivingEntity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            arm.f_104203_ = 0.0f;
            this.renderFirstPersonArm(model, arm, matrixStack, buffer, light, hasSlimArms, hasFoil);
        }
    }

    protected void renderFirstPersonArm(ArmsModel model, ModelPart arm, PoseStack matrixStack, MultiBufferSource buffer, int light, boolean hasSlimArms, boolean hasFoil) {
        RenderType renderType = model.m_103119_(this.getTexture(hasSlimArms));
        VertexConsumer builder = ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)renderType, (boolean)false, (boolean)hasFoil);
        arm.m_104301_(matrixStack, builder, light, OverlayTexture.f_118083_);
    }
}

