/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.architectury.fluid.FluidStack;
import dev.architectury.registry.registries.RegistrarManager;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.FluidConfig;
import dev.ftb.mods.ftblibrary.config.NBTConfig;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import dev.ftb.mods.ftblibrary.util.client.PositionedIngredient;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class FluidTask
extends Task {
    public static final ResourceLocation TANK_TEXTURE = new ResourceLocation("ftbquests", "textures/tasks/tank.png");
    private Fluid fluid = Fluids.f_76193_;
    private CompoundTag fluidNBT = null;
    private long amount = FluidStack.bucketAmount();
    private FluidStack cachedFluidStack = null;

    public FluidTask(long id, Quest quest) {
        super(id, quest);
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public FluidTask setFluid(Fluid fluid) {
        this.fluid = fluid;
        return this;
    }

    public CompoundTag getFluidNBT() {
        return this.fluidNBT;
    }

    @Override
    public TaskType getType() {
        return TaskTypes.FLUID;
    }

    @Override
    public long getMaxProgress() {
        return this.amount;
    }

    @Override
    public String formatMaxProgress() {
        return FluidTask.getVolumeString(this.amount);
    }

    @Override
    public String formatProgress(TeamData teamData, long progress) {
        return FluidTask.getVolumeString((int)Math.min(Integer.MAX_VALUE, progress));
    }

    @Override
    public boolean consumesResources() {
        return true;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("fluid", RegistrarManager.getId((Object)this.fluid, (ResourceKey)Registries.f_256808_).toString());
        nbt.m_128356_("amount", this.amount);
        if (this.fluidNBT != null) {
            nbt.m_128365_("nbt", (Tag)this.fluidNBT);
        }
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.fluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(nbt.m_128461_("fluid")));
        if (this.fluid == null || this.fluid == Fluids.f_76191_) {
            this.fluid = Fluids.f_76193_;
        }
        this.amount = Math.max(1L, nbt.m_128454_("amount"));
        this.fluidNBT = (CompoundTag)nbt.m_128423_("nbt");
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130085_(RegistrarManager.getId((Object)this.fluid, (ResourceKey)Registries.f_256808_));
        buffer.m_130079_(this.fluidNBT);
        buffer.m_130103_(this.amount);
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.fluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(buffer.m_130281_());
        if (this.fluid == null || this.fluid == Fluids.f_76191_) {
            this.fluid = Fluids.f_76193_;
        }
        this.fluidNBT = buffer.m_130260_();
        this.amount = buffer.m_130258_();
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        this.cachedFluidStack = null;
    }

    public FluidStack createFluidStack() {
        if (this.cachedFluidStack == null) {
            this.cachedFluidStack = FluidStack.create((Fluid)this.fluid, (long)FluidStack.bucketAmount(), (CompoundTag)this.fluidNBT);
        }
        return this.cachedFluidStack;
    }

    public static String getVolumeString(long a) {
        StringBuilder builder = new StringBuilder();
        if (a >= FluidStack.bucketAmount()) {
            if (a % FluidStack.bucketAmount() != 0L) {
                builder.append(StringUtils.formatDouble((double)((double)a / (double)FluidStack.bucketAmount())));
            } else {
                builder.append(a / FluidStack.bucketAmount());
            }
            builder.append(" B");
        } else {
            builder.append(a).append(" mB");
        }
        return builder.toString();
    }

    public MutableComponent getAltTitle() {
        return Component.m_237113_((String)(FluidTask.getVolumeString(this.amount) + " of ")).m_7220_(this.createFluidStack().getName());
    }

    @Override
    public Icon getAltIcon() {
        FluidStack stack = this.createFluidStack();
        return Icon.getIcon((ResourceLocation)ClientUtils.getStillTexture((FluidStack)stack)).withTint(Color4I.rgb((int)ClientUtils.getFluidColor((FluidStack)stack)));
    }

    @Override
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.add("fluid", (ConfigValue)new FluidConfig(false), (Object)FluidStack.create((Fluid)this.fluid, (long)1000L), v -> {
            this.fluid = v.getFluid();
        }, (Object)FluidStack.create((Fluid)Fluids.f_76193_, (long)1000L));
        config.add("fluid_nbt", (ConfigValue)new NBTConfig(), (Object)this.fluidNBT, v -> {
            this.fluidNBT = v;
        }, null);
        config.addLong("amount", this.amount, v -> {
            this.amount = v;
        }, FluidStack.bucketAmount(), 1L, Long.MAX_VALUE);
    }

    @Override
    public boolean canInsertItem() {
        return true;
    }

    @Override
    @Nullable
    public Optional<PositionedIngredient> getIngredient(Widget widget) {
        return PositionedIngredient.of((Object)this.createFluidStack(), (Widget)widget);
    }
}

