/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.elytraslot;

import com.illusivesoulworks.elytraslot.client.ElytraRenderResult;
import com.illusivesoulworks.elytraslot.common.IElytraProvider;
import com.illusivesoulworks.elytraslot.common.SimpleCompatibilityProvider;
import com.illusivesoulworks.elytraslot.common.VanillaElytraProvider;
import com.illusivesoulworks.elytraslot.platform.Services;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class ElytraSlotCommonMod {
    public static final Predicate<ItemStack> IS_ELYTRA = new Predicate<ItemStack>(){

        @Override
        public boolean test(ItemStack stack) {
            for (IElytraProvider provider : PROVIDERS) {
                if (!provider.matches(stack)) continue;
                return true;
            }
            return false;
        }
    };
    private static final List<IElytraProvider> PROVIDERS = new LinkedList<IElytraProvider>();

    public static void init() {
        PROVIDERS.add(new VanillaElytraProvider());
        PROVIDERS.add(new SimpleCompatibilityProvider());
    }

    public static Optional<ElytraRenderResult> getElytraRender(LivingEntity livingEntity) {
        AtomicReference result = new AtomicReference();
        Services.ELYTRA.processSlots(livingEntity, stack -> {
            if (!stack.m_41619_()) {
                for (IElytraProvider provider : PROVIDERS) {
                    if (!provider.matches((ItemStack)stack)) continue;
                    result.set(provider.getRender((ItemStack)stack));
                    return true;
                }
            }
            return false;
        });
        return Optional.ofNullable((ElytraRenderResult)result.get());
    }

    public static boolean canFly(LivingEntity livingEntity, boolean doTick) {
        AtomicBoolean result = new AtomicBoolean();
        Services.ELYTRA.processSlots(livingEntity, stack -> {
            if (!stack.m_41619_()) {
                for (IElytraProvider provider : PROVIDERS) {
                    if (!provider.matches((ItemStack)stack)) continue;
                    result.set(provider.canFly((ItemStack)stack, livingEntity, doTick));
                    return true;
                }
            }
            return false;
        });
        return result.get();
    }

    public static boolean isEquipped(LivingEntity livingEntity) {
        return Services.ELYTRA.isEquipped(livingEntity);
    }

    public static boolean canEquip(LivingEntity livingEntity) {
        return !IS_ELYTRA.test(livingEntity.m_6844_(EquipmentSlot.CHEST)) && !Services.ELYTRA.isEquipped(livingEntity);
    }
}

