/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbteams.FTBTeams;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamManager;
import dev.ftb.mods.ftbteams.api.TeamRank;
import dev.ftb.mods.ftbteams.api.event.PlayerLoggedInAfterTeamEvent;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import dev.ftb.mods.ftbteams.api.event.TeamManagerEvent;
import dev.ftb.mods.ftbteams.api.property.TeamProperties;
import dev.ftb.mods.ftbteams.data.AbstractTeam;
import dev.ftb.mods.ftbteams.data.ClientTeamManagerImpl;
import dev.ftb.mods.ftbteams.data.FTBTUtils;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.ServerTeam;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.net.SyncMessageHistoryMessage;
import dev.ftb.mods.ftbteams.net.SyncTeamsMessage;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class TeamManagerImpl
implements TeamManager {
    public static final LevelResource FOLDER_NAME = new LevelResource("ftbteams");
    public static TeamManagerImpl INSTANCE;
    private final MinecraftServer server;
    private UUID id;
    private boolean shouldSave;
    private final Map<UUID, PlayerTeam> knownPlayers;
    private final Map<UUID, AbstractTeam> teamMap;
    Map<String, Team> nameMap;
    private CompoundTag extraData;

    public TeamManagerImpl(MinecraftServer s) {
        this.server = s;
        this.knownPlayers = new LinkedHashMap<UUID, PlayerTeam>();
        this.teamMap = new LinkedHashMap<UUID, AbstractTeam>();
        this.extraData = new CompoundTag();
    }

    @Override
    public MinecraftServer getServer() {
        return this.server;
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = UUID.randomUUID();
        }
        return this.id;
    }

    @Override
    public Map<UUID, ? extends Team> getKnownPlayerTeams() {
        return Collections.unmodifiableMap(this.knownPlayers);
    }

    public Map<UUID, AbstractTeam> getTeamMap() {
        return this.teamMap;
    }

    @Override
    public Collection<Team> getTeams() {
        ImmutableList.Builder b = ImmutableList.builderWithExpectedSize((int)this.getTeamMap().size());
        this.teamMap.values().forEach(arg_0 -> ((ImmutableList.Builder)b).add(arg_0));
        return b.build();
    }

    public Map<String, Team> getTeamNameMap() {
        if (this.nameMap == null) {
            this.nameMap = new HashMap<String, Team>();
            for (AbstractTeam team : this.teamMap.values()) {
                this.nameMap.put(team.getShortName(), team);
            }
        }
        return this.nameMap;
    }

    @Override
    public Optional<Team> getTeamByID(UUID teamId) {
        return Optional.of((Team)this.teamMap.get(teamId));
    }

    @Override
    public Optional<Team> getTeamByName(String name) {
        return Optional.ofNullable(this.getTeamNameMap().get(name));
    }

    @Override
    public Optional<Team> getPlayerTeamForPlayerID(UUID uuid) {
        return Optional.ofNullable(this.getPersonalTeamForPlayerID(uuid));
    }

    public PlayerTeam getPersonalTeamForPlayerID(UUID uuid) {
        return this.knownPlayers.get(uuid);
    }

    @Override
    public Optional<Team> getTeamForPlayerID(UUID uuid) {
        PlayerTeam t = this.knownPlayers.get(uuid);
        return t == null ? Optional.empty() : Optional.ofNullable(t.getEffectiveTeam());
    }

    @Override
    public Optional<Team> getTeamForPlayer(ServerPlayer player) {
        return this.getTeamForPlayerID(player.m_20148_());
    }

    @Override
    public boolean arePlayersInSameTeam(UUID id1, UUID id2) {
        return this.getTeamForPlayerID(id1).map(team1 -> this.getTeamForPlayerID(id2).map(team2 -> team1.getId().equals(team2.getId())).orElse(false)).orElse(false);
    }

    public void load() {
        this.id = null;
        Path directory = this.server.m_129843_(FOLDER_NAME);
        if (Files.notExists(directory, new LinkOption[0]) || !Files.isDirectory(directory, new LinkOption[0])) {
            return;
        }
        SNBTCompoundTag dataFileTag = SNBT.read((Path)directory.resolve("ftbteams.snbt"));
        if (dataFileTag != null) {
            if (dataFileTag.m_128441_("id")) {
                this.id = UUID.fromString(dataFileTag.m_128461_("id"));
            }
            this.extraData = dataFileTag.m_128469_("extra");
            ((Consumer)TeamManagerEvent.LOADED.invoker()).accept(new TeamManagerEvent(this));
        }
        for (TeamType type : TeamType.values()) {
            Path dir = directory.resolve(type.m_7912_());
            if (!Files.exists(dir, new LinkOption[0]) || !Files.isDirectory(dir, new LinkOption[0])) continue;
            try (Stream<Path> s = Files.list(dir);){
                s.filter(path -> path.getFileName().toString().endsWith(".snbt")).forEach(file -> {
                    SNBTCompoundTag nbt = SNBT.read((Path)file);
                    if (nbt != null) {
                        AbstractTeam team = type.createTeam(this, UUID.fromString(nbt.m_128461_("id")));
                        this.teamMap.put(team.id, team);
                        team.deserializeNBT((CompoundTag)nbt);
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (AbstractTeam team : this.teamMap.values()) {
            if (!(team instanceof PlayerTeam)) continue;
            this.knownPlayers.put(team.id, (PlayerTeam)team);
        }
        for (AbstractTeam team : this.teamMap.values()) {
            if (!(team instanceof PartyTeam)) continue;
            for (UUID member : team.getMembers()) {
                PlayerTeam t = this.knownPlayers.get(member);
                if (t == null) continue;
                t.setEffectiveTeam(team);
            }
        }
        FTBTeams.LOGGER.info("loaded team data: {} known players, {} teams total", (Object)this.knownPlayers.size(), (Object)this.teamMap.size());
    }

    @Override
    public void markDirty() {
        this.shouldSave = true;
        this.nameMap = null;
    }

    public void saveNow() {
        Path directory = this.server.m_129843_(FOLDER_NAME);
        if (Files.notExists(directory, new LinkOption[0])) {
            try {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.shouldSave) {
            ((Consumer)TeamManagerEvent.SAVED.invoker()).accept(new TeamManagerEvent(this));
            SNBT.write((Path)directory.resolve("ftbteams.snbt"), (CompoundTag)this.serializeNBT());
            this.shouldSave = false;
        }
        for (TeamType type : TeamType.values()) {
            Path path = directory.resolve(type.m_7912_());
            if (!Files.notExists(path, new LinkOption[0])) continue;
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (AbstractTeam team : this.teamMap.values()) {
            team.saveIfNeeded(directory);
        }
    }

    public SNBTCompoundTag serializeNBT() {
        SNBTCompoundTag nbt = new SNBTCompoundTag();
        nbt.m_128359_("id", this.getId().toString());
        nbt.m_128365_("extra", (Tag)this.extraData);
        return nbt;
    }

    private ServerTeam createServerTeam(ServerPlayer player, String name) {
        ServerTeam team = new ServerTeam(this, UUID.randomUUID());
        this.teamMap.put(team.id, team);
        team.setProperty(TeamProperties.DISPLAY_NAME, name.isEmpty() ? team.id.toString().substring(0, 8) : name);
        team.setProperty(TeamProperties.COLOR, FTBTUtils.randomColor());
        team.onCreated(player);
        return team;
    }

    private PartyTeam createPartyTeam(ServerPlayer player, String name) {
        PartyTeam team = new PartyTeam(this, UUID.randomUUID());
        team.owner = player.m_20148_();
        this.teamMap.put(team.id, team);
        team.setProperty(TeamProperties.DISPLAY_NAME, name.isEmpty() ? player.m_36316_().getName() + "'s Party" : name);
        team.setProperty(TeamProperties.COLOR, FTBTUtils.randomColor());
        team.onCreated(player);
        return team;
    }

    private PlayerTeam createPlayerTeam(@Nullable ServerPlayer player, UUID playerId, String playerName) {
        PlayerTeam team = new PlayerTeam(this, playerId);
        team.setPlayerName(playerName);
        team.setProperty(TeamProperties.DISPLAY_NAME, playerName);
        team.setProperty(TeamProperties.COLOR, FTBTUtils.randomColor());
        team.addMember(playerId, TeamRank.OWNER);
        return team;
    }

    public void playerLoggedIn(@Nullable ServerPlayer player, UUID id, String name) {
        PlayerTeam team = this.knownPlayers.get(id);
        boolean syncToAll = false;
        FTBTeams.LOGGER.debug("player {} logged in, player team = {}", (Object)id, (Object)team);
        if (team == null) {
            FTBTeams.LOGGER.debug("creating new player team for player {}", (Object)id);
            team = this.createPlayerTeam(player, id, name);
            this.teamMap.put(id, team);
            this.knownPlayers.put(id, team);
            team.onCreated(player);
            syncToAll = true;
            team.onPlayerChangeTeam(null, id, player, false);
            FTBTeams.LOGGER.debug("  - team created");
        } else if (!team.getPlayerName().equals(name)) {
            FTBTeams.LOGGER.debug("updating player name: {} -> {}", (Object)team.getPlayerName(), (Object)name);
            team.setPlayerName(name);
            team.markDirty();
            this.markDirty();
            syncToAll = true;
        }
        FTBTeams.LOGGER.debug("syncing player team data, all = {}", (Object)syncToAll);
        if (player != null) {
            this.syncAllToPlayer(player, team.getEffectiveTeam());
        }
        if (syncToAll) {
            this.syncToAll(team.getEffectiveTeam());
        }
        FTBTeams.LOGGER.debug("updating team presence");
        team.setOnline(true);
        team.updatePresence();
        if (player != null) {
            FTBTeams.LOGGER.debug("sending team login event for {}...", (Object)player.m_20148_());
            ((Consumer)TeamEvent.PLAYER_LOGGED_IN.invoker()).accept(new PlayerLoggedInAfterTeamEvent(team.getEffectiveTeam(), player));
            FTBTeams.LOGGER.debug("team login event for {} sent", (Object)player.m_20148_());
        }
    }

    public void playerLoggedOut(ServerPlayer player) {
        PlayerTeam team = this.knownPlayers.get(player.m_20148_());
        if (team != null) {
            team.setOnline(false);
            team.updatePresence();
        }
    }

    public void syncAllToPlayer(ServerPlayer player, AbstractTeam selfTeam) {
        ClientTeamManagerImpl manager = ClientTeamManagerImpl.forSyncing(this, this.teamMap.values());
        new SyncTeamsMessage(manager, selfTeam, true).sendTo(player);
        new SyncMessageHistoryMessage(selfTeam).sendTo(player);
        this.server.m_6846_().m_11289_(player);
    }

    public void syncToAll(Team ... teams) {
        if (teams.length == 0) {
            return;
        }
        ClientTeamManagerImpl manager = ClientTeamManagerImpl.forSyncing(this, Arrays.stream(teams).toList());
        for (ServerPlayer player : this.server.m_6846_().m_11314_()) {
            this.getTeamForPlayer(player).ifPresent(selfTeam -> {
                new SyncTeamsMessage(manager, (Team)selfTeam, false).sendTo(player);
                if (teams.length > 1) {
                    new SyncMessageHistoryMessage((Team)selfTeam).sendTo(player);
                }
            });
        }
    }

    public Pair<Integer, PartyTeam> createParty(ServerPlayer player, String name) throws CommandSyntaxException {
        return this.createParty(player, name, null, null);
    }

    public Pair<Integer, PartyTeam> createParty(ServerPlayer player, String name, @Nullable String description, @Nullable Color4I color) throws CommandSyntaxException {
        if (FTBTeamsAPI.api().getCustomPartyCreationHandler() != null) {
            throw TeamArgument.API_OVERRIDE.create();
        }
        if (!FTBTUtils.canPlayerUseCommand(player, "ftbteams.party.create")) {
            throw TeamArgument.NO_PERMISSION.create();
        }
        UUID id = player.m_20148_();
        Team oldTeam = this.getTeamForPlayer(player).orElseThrow(() -> TeamArgument.TEAM_NOT_FOUND.create((Object)player.m_20148_()));
        if (!(oldTeam instanceof PlayerTeam)) {
            throw TeamArgument.ALREADY_IN_PARTY.create();
        }
        PlayerTeam playerTeam = (PlayerTeam)oldTeam;
        PartyTeam team = this.createPartyTeam(player, name);
        if (description != null) {
            team.setProperty(TeamProperties.DESCRIPTION, description);
        }
        if (color != null) {
            team.setProperty(TeamProperties.COLOR, color);
        }
        playerTeam.setEffectiveTeam(team);
        team.addMember(id, TeamRank.OWNER);
        team.sendMessage(Util.f_137441_, (Component)Component.m_237110_((String)"ftbteams.message.joined", (Object[])new Object[]{player.m_7755_()}).m_130940_(ChatFormatting.YELLOW));
        team.markDirty();
        playerTeam.removeMember(id);
        playerTeam.markDirty();
        playerTeam.updatePresence();
        this.syncToAll(team, playerTeam);
        team.onPlayerChangeTeam(playerTeam, id, player, false);
        return Pair.of((Object)1, (Object)team);
    }

    public Pair<Integer, ServerTeam> createServer(CommandSourceStack source, String name) throws CommandSyntaxException {
        if (name.length() < 3) {
            throw TeamArgument.NAME_TOO_SHORT.create();
        }
        ServerTeam team = this.createServerTeam(source.m_81375_(), name);
        source.m_288197_(() -> Component.m_237110_((String)"ftbteams.message.created_server_team", (Object[])new Object[]{team.getName()}), true);
        this.syncToAll(team);
        return Pair.of((Object)1, (Object)team);
    }

    public Component getPlayerName(@Nullable UUID id) {
        if (id == null || id.equals(Util.f_137441_)) {
            return Component.m_237113_((String)"System").m_130940_(ChatFormatting.LIGHT_PURPLE);
        }
        PlayerTeam team = this.knownPlayers.get(id);
        return Component.m_237113_((String)(team == null ? "Unknown" : team.getPlayerName())).m_130940_(ChatFormatting.YELLOW);
    }

    @Override
    public CompoundTag getExtraData() {
        return this.extraData;
    }

    void deleteTeam(Team team) {
        this.teamMap.remove(team.getId());
        this.markDirty();
    }

    void tryDeleteTeamFile(String teamFileName, String subfolderName) {
        Path deletedPath = this.getServer().m_129843_(FOLDER_NAME).resolve("deleted");
        Path teamFilePath = this.getServer().m_129843_(FOLDER_NAME).resolve(subfolderName).resolve(teamFileName);
        try {
            if (Files.notExists(deletedPath, new LinkOption[0])) {
                Files.createDirectories(deletedPath, new FileAttribute[0]);
            }
            Files.move(teamFilePath, deletedPath.resolve(teamFileName), new CopyOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                Files.deleteIfExists(teamFilePath);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }
}

