/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.GlobalRailwayManager;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import com.simibubi.create.content.trains.signal.SignalBoundary;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.foundation.utility.Components;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DumpRailwaysCommand {
    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"trains").requires(cs -> cs.m_6761_(2))).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            DumpRailwaysCommand.fillReport(source.m_81372_(), source.m_81371_(), (s, f) -> source.m_288197_(() -> Components.literal(s).m_130938_(st -> st.m_178520_(f.intValue())), false), c -> source.m_288197_(() -> c, false));
            return 1;
        });
    }

    static void fillReport(ServerLevel level, Vec3 location, BiConsumer<String, Integer> chat, Consumer<Component> chatRaw) {
        GlobalRailwayManager railways = Create.RAILWAYS;
        int white = ChatFormatting.WHITE.m_126665_();
        int blue = 13885148;
        int darkBlue = 9611709;
        int bright = 0xFFEFEF;
        int orange = 16756064;
        chat.accept("", white);
        chat.accept("-+------<< Train Summary: >>------+-", white);
        int graphCount = railways.trackNetworks.size();
        chat.accept("Track Networks: " + graphCount, blue);
        chat.accept("Signal Groups: " + railways.signalEdgeGroups.size(), blue);
        int trainCount = railways.trains.size();
        chat.accept("Trains: " + trainCount, blue);
        chat.accept("", white);
        List<TrackGraph> nearest = railways.trackNetworks.values().stream().sorted((tg1, tg2) -> Float.compare(tg1.distanceToLocationSqr((Level)level, location), tg2.distanceToLocationSqr((Level)level, location))).limit(5L).toList();
        if (graphCount > 0) {
            chat.accept("Nearest Graphs: ", orange);
            chat.accept("", white);
            for (TrackGraph graph : nearest) {
                Collection<GlobalStation> stations;
                chat.accept(graph.id.toString().substring(0, 5) + " with " + graph.getNodes().size() + " Nodes", white);
                Collection<SignalBoundary> signals = graph.getPoints(EdgePointType.SIGNAL);
                if (!signals.isEmpty()) {
                    chat.accept(" -> " + signals.size() + " Signals", blue);
                }
                if ((stations = graph.getPoints(EdgePointType.STATION)).isEmpty()) continue;
                chat.accept(" -> " + stations.size() + " Stations", blue);
            }
            chat.accept("", white);
            if (graphCount > 5) {
                chat.accept("[...]", white);
                chat.accept("", white);
            }
        }
        List<Train> nearestTrains = railways.trains.values().stream().sorted((t1, t2) -> Float.compare(t1.distanceToLocationSqr((Level)level, location), t2.distanceToLocationSqr((Level)level, location))).limit(5L).toList();
        if (trainCount > 0 && !nearestTrains.isEmpty()) {
            chat.accept("Nearest Trains: ", orange);
            chat.accept("", white);
            for (Train train : nearestTrains) {
                GlobalStation currentStation;
                chat.accept(train.id.toString().substring(0, 5) + ": " + train.name.getString() + ", " + train.carriages.size() + " Wagons", bright);
                if (train.derailed) {
                    chat.accept(" -> Derailed", orange);
                } else if (train.graph != null) {
                    chat.accept(" -> On Track: " + train.graph.id.toString().substring(0, 5), blue);
                }
                LivingEntity owner = train.getOwner((Level)level);
                if (owner != null) {
                    chat.accept(" -> Owned by " + owner.m_7755_().getString(), blue);
                }
                if ((currentStation = train.getCurrentStation()) != null) {
                    chat.accept(" -> Waiting at: " + currentStation.name, blue);
                } else if (train.navigation.destination != null) {
                    chat.accept(" -> Travelling to " + train.navigation.destination.name + " (" + Mth.m_14107_((double)train.navigation.distanceToDestination) + "m away)", darkBlue);
                }
                ScheduleRuntime runtime = train.runtime;
                if (runtime.getSchedule() != null) {
                    chat.accept(" -> Schedule, Entry " + runtime.currentEntry + ", " + (runtime.paused ? "Paused" : runtime.state.name().replaceAll("_", " ")), runtime.paused ? darkBlue : blue);
                } else {
                    chat.accept(" -> Idle, No Schedule", darkBlue);
                }
                chatRaw.accept(DumpRailwaysCommand.createDeleteButton(train));
                chat.accept("", white);
            }
            if (trainCount > 5) {
                chat.accept("[...]", white);
                chat.accept("", white);
            }
        }
        chat.accept("-+--------------------------------+-", white);
    }

    private static Component createDeleteButton(Train train) {
        return ComponentUtils.m_130748_((Component)Components.literal("Remove").m_130938_(p_180514_ -> p_180514_.m_178520_(16756064).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/c killTrain " + train.id.toString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Components.literal("Click to remove ").m_7220_(train.name))).m_131138_("/c killTrain " + train.id.toString())));
    }
}

