/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.advancement;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllFluids;
import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.advancements.Advancement;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class AllAdvancements
implements DataProvider {
    public static final List<CreateAdvancement> ENTRIES = new ArrayList<CreateAdvancement>();
    public static final CreateAdvancement START = null;
    public static final CreateAdvancement ROOT = AllAdvancements.create("root", b -> b.icon((ItemProviderEntry<?>)AllItems.BRASS_HAND).title("Welcome to Create").description("Here Be Contraptions").awardedForFree().special(CreateAdvancement.TaskType.SILENT));
    public static final CreateAdvancement ANDESITE = AllAdvancements.create("andesite_alloy", b -> b.icon((ItemProviderEntry<?>)AllItems.ANDESITE_ALLOY).title("Sturdier Rocks").description("Obtain some Andesite Alloy, Create's most important resource").after(ROOT).whenIconCollected());
    public static final CreateAdvancement ANDESITE_CASING = AllAdvancements.create("andesite_casing", b -> b.icon((ItemProviderEntry<?>)AllBlocks.ANDESITE_CASING).title("The Andesite Age").description("Apply Andesite Alloy to stripped wood, creating a basic casing for your machines").after(ANDESITE).special(CreateAdvancement.TaskType.NOISY));
    public static final CreateAdvancement PRESS = AllAdvancements.create("mechanical_press", b -> b.icon((ItemProviderEntry<?>)AllBlocks.MECHANICAL_PRESS).title("Bonk!").description("Create some sheets in a Mechanical Press").after(ANDESITE_CASING).special(CreateAdvancement.TaskType.NOISY));
    public static final CreateAdvancement ENCASED_FAN = AllAdvancements.create("encased_fan", b -> b.icon((ItemProviderEntry<?>)AllBlocks.ENCASED_FAN).title("Wind Maker").description("Place and power an Encased Fan").after(PRESS));
    public static final CreateAdvancement FAN_PROCESSING = AllAdvancements.create("fan_processing", b -> b.icon((ItemProviderEntry<?>)AllItems.PROPELLER).title("Processing by Particle").description("Use an Encased Fan to process materials").after(ENCASED_FAN));
    public static final CreateAdvancement SAW_PROCESSING = AllAdvancements.create("saw_processing", b -> b.icon((ItemProviderEntry<?>)AllBlocks.MECHANICAL_SAW).title("Workshop's Most Feared").description("Use an upright Mechanical Saw to process materials").after(FAN_PROCESSING));
    public static final CreateAdvancement COMPACTING = AllAdvancements.create("compacting", b -> b.icon((ItemLike)Blocks.f_50075_).title("Compactification").description("Use a Mechanical Press and a Basin to create fewer items from more").after(SAW_PROCESSING));
    public static final CreateAdvancement BELT = AllAdvancements.create("belt", b -> b.icon((ItemProviderEntry<?>)AllItems.BELT_CONNECTOR).title("Kelp Drive").description("Connect two Shafts with a Mechanical Belt").after(COMPACTING));
    public static final CreateAdvancement FUNNEL = AllAdvancements.create("funnel", b -> b.icon((ItemProviderEntry<?>)AllBlocks.ANDESITE_FUNNEL).title("Airport Aesthetic").description("Extract or insert items into a container using a Funnel").after(BELT));
    public static final CreateAdvancement CHUTE = AllAdvancements.create("chute", b -> b.icon((ItemProviderEntry<?>)AllBlocks.CHUTE).title("Vertical Logistics").description("Transport some items by Chute").after(FUNNEL));
    public static final CreateAdvancement MIXER = AllAdvancements.create("mechanical_mixer", b -> b.icon((ItemProviderEntry<?>)AllBlocks.MECHANICAL_MIXER).title("Mixing It Up").description("Combine ingredients in a Mechanical Mixer").after(CHUTE));
    public static final CreateAdvancement BLAZE_BURNER = AllAdvancements.create("burner", b -> b.icon((ItemProviderEntry<?>)AllBlocks.BLAZE_BURNER).title("Sentient Fireplace").description("Obtain a Blaze Burner").whenIconCollected().after(MIXER));
    public static final CreateAdvancement WATER_WHEEL = AllAdvancements.create("water_wheel", b -> b.icon((ItemProviderEntry<?>)AllBlocks.WATER_WHEEL).title("Harnessed Hydraulics").description("Place a Water Wheel and use it to generate torque").after(ANDESITE));
    public static final CreateAdvancement WINDMILL = AllAdvancements.create("windmill", b -> b.icon((ItemProviderEntry<?>)AllBlocks.SAIL_FRAME).title("A Mild Breeze").description("Assemble a windmill and use it to generate torque").after(WATER_WHEEL));
    public static final CreateAdvancement COGS = AllAdvancements.create("shifting_gears", b -> b.icon((ItemProviderEntry<?>)AllBlocks.COGWHEEL).title("Shifting Gears").description("Connect a Large Cogwheel to a Small Cogwheel, allowing you to change the speed of your Contraption").after(WINDMILL));
    public static final CreateAdvancement MILLSTONE = AllAdvancements.create("millstone", b -> b.icon((ItemProviderEntry<?>)AllBlocks.MILLSTONE).title("Embrace the Grind").description("Use a Millstone to pulverise materials").after(COGS));
    public static final CreateAdvancement SUPER_GLUE = AllAdvancements.create("super_glue", b -> b.icon((ItemProviderEntry<?>)AllItems.SUPER_GLUE).title("Area of Connect").description("Super Glue some blocks into a group").after(MILLSTONE));
    public static final CreateAdvancement CONTRAPTION_ACTORS = AllAdvancements.create("contraption_actors", b -> b.icon((ItemProviderEntry<?>)AllBlocks.MECHANICAL_HARVESTER).title("Moving with Purpose").description("Create a Contraption with drills, saws, or harvesters on board").after(SUPER_GLUE));
    public static final CreateAdvancement PSI = AllAdvancements.create("portable_storage_interface", b -> b.icon((ItemProviderEntry<?>)AllBlocks.PORTABLE_STORAGE_INTERFACE).title("Drive-By Exchange").description("Use a Portable Storage Interface to take or insert items into a Contraption").after(CONTRAPTION_ACTORS));
    public static final CreateAdvancement WRENCH_GOGGLES = AllAdvancements.create("wrench_goggles", b -> b.icon((ItemProviderEntry<?>)AllItems.WRENCH).title("Kitted Out").description("Equip Engineer's Goggles and a Wrench").whenIconCollected().whenItemCollected((ItemProviderEntry<?>)AllItems.GOGGLES).after(PSI));
    public static final CreateAdvancement STRESSOMETER = AllAdvancements.create("stressometer", b -> b.icon((ItemProviderEntry<?>)AllBlocks.STRESSOMETER).title("Stress for Nerds").description("Get an exact readout with the help of Engineer's Goggles and a Stressometer").after(WRENCH_GOGGLES));
    public static final CreateAdvancement CUCKOO_CLOCK = AllAdvancements.create("cuckoo_clock", b -> b.icon((ItemProviderEntry<?>)AllBlocks.CUCKOO_CLOCK).title("Is It Time?").description("Witness your Cuckoo Clock announce bedtime").after(STRESSOMETER).special(CreateAdvancement.TaskType.NOISY));
    public static final CreateAdvancement WINDMILL_MAXED = AllAdvancements.create("windmill_maxed", b -> b.icon((ItemProviderEntry<?>)AllBlocks.SAIL).title("A Strong Breeze").description("Assemble a windmill of maximum strength").after(ANDESITE).special(CreateAdvancement.TaskType.EXPERT));
    public static final CreateAdvancement EJECTOR_MAXED = AllAdvancements.create("ejector_maxed", b -> b.icon((ItemProviderEntry<?>)AllBlocks.WEIGHTED_EJECTOR).title("Springboard Champion").description("Get launched more than 30 blocks by a Weighted Ejector").after(WINDMILL_MAXED).special(CreateAdvancement.TaskType.EXPERT));
    public static final CreateAdvancement PULLEY_MAXED = AllAdvancements.create("pulley_maxed", b -> b.icon((ItemProviderEntry<?>)AllBlocks.ROPE_PULLEY).title("Rope to Nowhere").description("Extend a Rope Pulley over 200 blocks deep").after(EJECTOR_MAXED).special(CreateAdvancement.TaskType.EXPERT));
    public static final CreateAdvancement CART_PICKUP = AllAdvancements.create("cart_pickup", b -> b.icon((ItemProviderEntry<?>)AllItems.CHEST_MINECART_CONTRAPTION).title("Strong Arms").description("Pick up a Minecart Contraption with at least 200 attached blocks").after(PULLEY_MAXED).special(CreateAdvancement.TaskType.EXPERT));
    public static final CreateAdvancement ANVIL_PLOUGH = AllAdvancements.create("anvil_plough", b -> b.icon((ItemLike)Blocks.f_50323_).title("Blacksmith Artillery").description("Launch an Anvil with Mechanical Ploughs").after(CART_PICKUP).special(CreateAdvancement.TaskType.EXPERT));
    public static final CreateAdvancement LAVA_WHEEL = AllAdvancements.create("lava_wheel_00000", b -> b.icon((ItemProviderEntry<?>)AllBlocks.WATER_WHEEL).title("Magma Wheel").description("This shouldn't have worked").after(MIXER).special(CreateAdvancement.TaskType.SECRET));
    public static final CreateAdvancement HAND_CRANK = AllAdvancements.create("hand_crank_000", b -> b.icon((ItemProviderEntry<?>)AllBlocks.HAND_CRANK).title("Workout Session").description("Use a Hand Crank until fully exhausted").after(MIXER).special(CreateAdvancement.TaskType.SECRET));
    public static final CreateAdvancement FUNNEL_KISS = AllAdvancements.create("belt_funnel_kiss", b -> b.icon((ItemProviderEntry<?>)AllBlocks.BRASS_FUNNEL).title("The Parrots and the Flaps").description("Make two Belt-mounted Funnels kiss").after(MIXER).special(CreateAdvancement.TaskType.SECRET));
    public static final CreateAdvancement STRESSOMETER_MAXED = AllAdvancements.create("stressometer_maxed", b -> b.icon((ItemProviderEntry<?>)AllBlocks.STRESSOMETER).title("Perfectly Stressed").description("Get a 100% readout from a Stressometer").after(MIXER).special(CreateAdvancement.TaskType.SECRET));
    public static final CreateAdvancement COPPER = AllAdvancements.create("copper", b -> b.icon((ItemLike)Items.f_151052_).title("Cuprum Bokum").description("Amass some Copper Ingots for your exploits in fluid manipulation").whenIconCollected().after(BLAZE_BURNER).special(CreateAdvancement.TaskType.SILENT));
    public static final CreateAdvancement COPPER_CASING = AllAdvancements.create("copper_casing", b -> b.icon((ItemProviderEntry<?>)AllBlocks.COPPER_CASING).title("The Copper Age").description("Apply Copper Ingots to stripped wood, creating a waterproof casing for your machines").after(COPPER).special(CreateAdvancement.TaskType.NOISY));
    public static final CreateAdvancement SPOUT = AllAdvancements.create("spout", b -> b.icon((ItemProviderEntry<?>)AllBlocks.SPOUT).title("Sploosh").description("Watch a fluid-containing item be filled by a Spout").after(COPPER_CASING));
    public static final CreateAdvancement DRAIN = AllAdvancements.create("drain", b -> b.icon((ItemProviderEntry<?>)AllBlocks.ITEM_DRAIN).title("Tumble Draining").description("Watch a fluid-containing item be emptied by an Item Drain").after(SPOUT));
    public static final CreateAdvancement STEAM_ENGINE = AllAdvancements.create("steam_engine", b -> b.icon((ItemProviderEntry<?>)AllBlocks.STEAM_ENGINE).title("The Powerhouse").description("Use a Steam Engine to generate torque").after(DRAIN));
    public static final CreateAdvancement STEAM_WHISTLE = AllAdvancements.create("steam_whistle", b -> b.icon((ItemProviderEntry<?>)AllBlocks.STEAM_WHISTLE).title("Voice of an Angel").description("Activate a Steam Whistle").after(STEAM_ENGINE));
    public static final CreateAdvancement BACKTANK = AllAdvancements.create("backtank", b -> b.icon((ItemProviderEntry<?>)AllItems.COPPER_BACKTANK).title("Pressure to Go").description("Create a Copper Backtank and make it accumulate air pressure").after(STEAM_WHISTLE));
    public static final CreateAdvancement DIVING_SUIT = AllAdvancements.create("diving_suit", b -> b.icon((ItemProviderEntry<?>)AllItems.COPPER_DIVING_HELMET).title("Ready for the Depths").description("Equip a Diving Helmet and a Copper Backtank, then jump into water").after(BACKTANK));
    public static final CreateAdvancement PUMP = AllAdvancements.create("mechanical_pump_0", b -> b.icon((ItemProviderEntry<?>)AllBlocks.MECHANICAL_PUMP).title("Under Pressure").description("Place and power a Mechanical Pump").after(COPPER));
    public static final CreateAdvancement GLASS_PIPE = AllAdvancements.create("glass_pipe", b -> b.icon((ItemProviderEntry<?>)AllBlocks.FLUID_PIPE).title("Flow Discovery").description("Use your Wrench on a pipe that contains a fluid").after(PUMP));
    public static final CreateAdvancement WATER_SUPPLY = AllAdvancements.create("water_supply", b -> b.icon((ItemLike)Items.f_42447_).title("Puddle Collector").description("Use the pulling end of a Fluid Pipe or Mechanical Pump to collect water").after(GLASS_PIPE));
    public static final CreateAdvancement HOSE_PULLEY = AllAdvancements.create("hose_pulley", b -> b.icon((ItemProviderEntry<?>)AllBlocks.HOSE_PULLEY).title("Industrial Spillage").description("Lower a Hose Pulley and watch it drain or fill a body of fluid").after(WATER_SUPPLY));
    public static final CreateAdvancement CHOCOLATE_BUCKET = AllAdvancements.create("chocolate_bucket", b -> b.icon((ItemLike)((ForgeFlowingFluid.Flowing)AllFluids.CHOCOLATE.get()).m_6859_()).title("A World of Imagination").description("Obtain a bucket of molten chocolate").whenIconCollected().after(HOSE_PULLEY));
    public static final CreateAdvancement HONEY_DRAIN = AllAdvancements.create("honey_drain", b -> b.icon((ItemLike)Items.f_42786_).title("Autonomous Bee-Keeping").description("Use pipes to pull honey from a Bee Nest or Beehive").after(CHOCOLATE_BUCKET));
    public static final CreateAdvancement HOSE_PULLEY_LAVA = AllAdvancements.create("hose_pulley_lava", b -> b.icon((ItemProviderEntry<?>)AllBlocks.HOSE_PULLEY).title("Tapping the Mantle").description("Pump from a body of lava large enough to be considered infinite").after(COPPER).special(CreateAdvancement.TaskType.EXPERT));
    public static final CreateAdvancement STEAM_ENGINE_MAXED = AllAdvancements.create("steam_engine_maxed", b -> b.icon((ItemProviderEntry<?>)AllBlocks.STEAM_ENGINE).title("Full Steam").description("Run a boiler at the maximum level of power").after(HOSE_PULLEY_LAVA).special(CreateAdvancement.TaskType.EXPERT));
    public static final CreateAdvancement FOODS = AllAdvancements.create("foods", b -> b.icon((ItemProviderEntry<?>)AllItems.CHOCOLATE_BERRIES).title("Balanced Diet").description("Create Chocolate Glazed Berries, a Honeyed Apple, and a Sweet Roll all from the same Spout").after(STEAM_ENGINE_MAXED).special(CreateAdvancement.TaskType.EXPERT));
    public static final CreateAdvancement DIVING_SUIT_LAVA = AllAdvancements.create("diving_suit_lava", b -> b.icon((ItemProviderEntry<?>)AllItems.NETHERITE_DIVING_HELMET).title("Swimming with the Striders").description("Attempt to take a dive in lava with your netherite diving gear").after(FOODS).special(CreateAdvancement.TaskType.EXPERT));
    public static final CreateAdvancement CHAINED_DRAIN = AllAdvancements.create("chained_drain", b -> b.icon((ItemProviderEntry<?>)AllBlocks.ITEM_DRAIN).title("On a Roll").description("Watch an item move across a row of Item Drains").after(BACKTANK).special(CreateAdvancement.TaskType.SECRET));
    public static final CreateAdvancement CROSS_STREAMS = AllAdvancements.create("cross_streams", b -> b.icon((ItemLike)Blocks.f_50652_).title("Don't Cross the Streams!").description("Watch two fluids meet in your pipe network").after(BACKTANK).special(CreateAdvancement.TaskType.SECRET));
    public static final CreateAdvancement PIPE_ORGAN = AllAdvancements.create("pipe_organ", b -> b.icon((ItemProviderEntry<?>)AllBlocks.STEAM_WHISTLE).title("The Pipe Organ").description("Attach 12 uniquely pitched Steam Whistles to a single Fluid Tank").after(BACKTANK).special(CreateAdvancement.TaskType.SECRET));
    public static final CreateAdvancement BRASS = AllAdvancements.create("brass", b -> b.icon((ItemProviderEntry<?>)AllItems.BRASS_INGOT).title("Real Alloys").description("Create Brass Ingots by alloying Copper and Zinc Ingots in your Blaze-heated Mechanical Mixer").whenIconCollected().after(DIVING_SUIT));
    public static final CreateAdvancement BRASS_CASING = AllAdvancements.create("brass_casing", b -> b.icon((ItemProviderEntry<?>)AllBlocks.BRASS_CASING).title("The Brass Age").description("Apply Brass Ingots to stripped wood, creating a casing for more sophisticated machines").after(BRASS).special(CreateAdvancement.TaskType.NOISY));
    public static final CreateAdvancement ROSE_QUARTZ = AllAdvancements.create("rose_quartz", b -> b.icon((ItemProviderEntry<?>)AllItems.POLISHED_ROSE_QUARTZ).title("Pink Diamonds").description("Polish some Rose Quartz").whenIconCollected().after(BRASS_CASING));
    public static final CreateAdvancement DEPLOYER = AllAdvancements.create("deployer", b -> b.icon((ItemProviderEntry<?>)AllBlocks.DEPLOYER).title("Artificial Intelligence").description("Place and power a Deployer, the perfect reflection of yourself").after(ROSE_QUARTZ));
    public static final CreateAdvancement MECHANISM = AllAdvancements.create("precision_mechanism", b -> b.icon((ItemProviderEntry<?>)AllItems.PRECISION_MECHANISM).title("Complex Curiosities").description("Assemble a Precision Mechanism").whenIconCollected().after(DEPLOYER).special(CreateAdvancement.TaskType.NOISY));
    public static final CreateAdvancement SPEED_CONTROLLER = AllAdvancements.create("speed_controller", b -> b.icon((ItemProviderEntry<?>)AllBlocks.ROTATION_SPEED_CONTROLLER).title("Engineers hate this simple trick!").description("Fine-tune your Contraption with a Rotation Speed Controller").after(MECHANISM));
    public static final CreateAdvancement MECHANICAL_ARM = AllAdvancements.create("mechanical_arm", b -> b.icon((ItemProviderEntry<?>)AllBlocks.MECHANICAL_ARM).title("Busy Hands").description("Watch your Mechanical Arm transport its first item").after(SPEED_CONTROLLER).special(CreateAdvancement.TaskType.NOISY));
    public static final CreateAdvancement CRAFTER = AllAdvancements.create("mechanical_crafter", b -> b.icon((ItemProviderEntry<?>)AllBlocks.MECHANICAL_CRAFTER).title("Automated Assembly").description("Place and power some Mechanical Crafters").after(MECHANICAL_ARM));
    public static final CreateAdvancement CRUSHING_WHEEL = AllAdvancements.create("crushing_wheel", b -> b.icon((ItemProviderEntry<?>)AllBlocks.CRUSHING_WHEEL).title("A Pair of Giants").description("Place and power a set of Crushing Wheels").after(CRAFTER).special(CreateAdvancement.TaskType.NOISY));
    public static final CreateAdvancement HAUNTED_BELL = AllAdvancements.create("haunted_bell", b -> b.icon((ItemProviderEntry<?>)AllBlocks.HAUNTED_BELL).title("Shadow Sense").description("Toll a Haunted Bell").after(BRASS).special(CreateAdvancement.TaskType.NOISY));
    public static final CreateAdvancement CLOCKWORK_BEARING = AllAdvancements.create("clockwork_bearing", b -> b.icon((ItemProviderEntry<?>)AllBlocks.CLOCKWORK_BEARING).title("Contraption O'Clock").description("Assemble a structure mounted on a Clockwork Bearing").after(HAUNTED_BELL).special(CreateAdvancement.TaskType.NOISY));
    public static final CreateAdvancement DISPLAY_LINK = AllAdvancements.create("display_link", b -> b.icon((ItemProviderEntry<?>)AllBlocks.DISPLAY_LINK).title("Big Data").description("Use a Display Link to visualise information").after(CLOCKWORK_BEARING).special(CreateAdvancement.TaskType.NOISY));
    public static final CreateAdvancement POTATO_CANNON = AllAdvancements.create("potato_cannon", b -> b.icon((ItemProviderEntry<?>)AllItems.POTATO_CANNON).title("Fwoomp!").description("Defeat an enemy with your Potato Cannon").after(DISPLAY_LINK).special(CreateAdvancement.TaskType.NOISY));
    public static final CreateAdvancement EXTENDO_GRIP = AllAdvancements.create("extendo_grip", b -> b.icon((ItemProviderEntry<?>)AllItems.EXTENDO_GRIP).title("Boioioing!").description("Get hold of an Extendo Grip").after(POTATO_CANNON));
    public static final CreateAdvancement LINKED_CONTROLLER = AllAdvancements.create("linked_controller", b -> b.icon((ItemProviderEntry<?>)AllItems.LINKED_CONTROLLER).title("Remote Activation").description("Activate a Redstone Link using a Linked Controller").after(EXTENDO_GRIP));
    public static final CreateAdvancement ARM_BLAZE_BURNER = AllAdvancements.create("arm_blaze_burner", b -> b.icon((ItemProviderEntry<?>)AllBlocks.BLAZE_BURNER).title("Combust-o-Tron").description("Instruct a Mechanical Arm to feed your Blaze Burner").after(LINKED_CONTROLLER));
    public static final CreateAdvancement CRUSHER_MAXED = AllAdvancements.create("crusher_maxed_0000", b -> b.icon((ItemProviderEntry<?>)AllBlocks.CRUSHING_WHEEL).title("Crushing It").description("Operate a pair of Crushing Wheels at maximum speed").after(BRASS).special(CreateAdvancement.TaskType.EXPERT));
    public static final CreateAdvancement ARM_MANY_TARGETS = AllAdvancements.create("arm_many_targets", b -> b.icon((ItemProviderEntry<?>)AllBlocks.MECHANICAL_ARM).title("Organize-o-Tron").description("Program a Mechanical Arm with 10 or more output locations").after(CRUSHER_MAXED).special(CreateAdvancement.TaskType.EXPERT));
    public static final CreateAdvancement POTATO_CANNON_COLLIDE = AllAdvancements.create("potato_cannon_collide", b -> b.icon((ItemLike)Items.f_42619_).title("Veggie Fireworks").description("Cause Potato Cannon projectiles of different types to collide with each other").after(ARM_MANY_TARGETS).special(CreateAdvancement.TaskType.EXPERT));
    public static final CreateAdvancement SELF_DEPLOYING = AllAdvancements.create("self_deploying", b -> b.icon((ItemLike)Items.f_41964_).title("Self-Driving Cart").description("Create a Minecart Contraption that places tracks in front of itself").after(POTATO_CANNON_COLLIDE).special(CreateAdvancement.TaskType.EXPERT));
    public static final CreateAdvancement FIST_BUMP = AllAdvancements.create("fist_bump", b -> b.icon((ItemProviderEntry<?>)AllBlocks.DEPLOYER).title("Pound It, Bro!").description("Make two Deployers fist-bump").after(CRAFTER).special(CreateAdvancement.TaskType.SECRET));
    public static final CreateAdvancement CRAFTER_LAZY = AllAdvancements.create("crafter_lazy_000", b -> b.icon((ItemProviderEntry<?>)AllBlocks.MECHANICAL_CRAFTER).title("Desperate Measures").description("Drastically slow down a Mechanical Crafter to procrastinate on proper infrastructure").after(CRAFTER).special(CreateAdvancement.TaskType.SECRET));
    public static final CreateAdvancement EXTENDO_GRIP_DUAL = AllAdvancements.create("extendo_grip_dual", b -> b.icon((ItemProviderEntry<?>)AllItems.EXTENDO_GRIP).title("To Full Extent").description("Dual-wield Extendo Grips for superhuman reach").after(CRAFTER).special(CreateAdvancement.TaskType.SECRET));
    public static final CreateAdvancement MUSICAL_ARM = AllAdvancements.create("musical_arm", b -> b.icon((ItemLike)Blocks.f_50131_).title("DJ Mechanico").description("Watch a Mechanical Arm operate your Jukebox").after(CRAFTER).special(CreateAdvancement.TaskType.SECRET));
    public static final CreateAdvancement STURDY_SHEET = AllAdvancements.create("sturdy_sheet", b -> b.icon((ItemProviderEntry<?>)AllItems.STURDY_SHEET).title("The Sturdiest Rocks").description("Assemble a Sturdy Sheet by refining Powdered Obsidian").whenIconCollected().after(CRUSHING_WHEEL));
    public static final CreateAdvancement TRAIN_CASING = AllAdvancements.create("train_casing_00", b -> b.icon((ItemProviderEntry<?>)AllBlocks.RAILWAY_CASING).title("The Logistical Age").description("Use Sturdy Sheets to create a casing for railway components").after(STURDY_SHEET).special(CreateAdvancement.TaskType.NOISY));
    public static final CreateAdvancement TRAIN = AllAdvancements.create("train", b -> b.icon((ItemProviderEntry<?>)AllBlocks.TRACK_STATION).title("All Aboard!").description("Assemble your first Train").after(TRAIN_CASING).special(CreateAdvancement.TaskType.NOISY));
    public static final CreateAdvancement CONDUCTOR = AllAdvancements.create("conductor", b -> b.icon((ItemProviderEntry<?>)AllItems.SCHEDULE).title("Conductor Instructor").description("Instruct a Train driver with a Train Schedule").after(TRAIN));
    public static final CreateAdvancement SIGNAL = AllAdvancements.create("track_signal", b -> b.icon((ItemProviderEntry<?>)AllBlocks.TRACK_SIGNAL).title("Traffic Control").description("Place a Train Signal").after(CONDUCTOR));
    public static final CreateAdvancement DISPLAY_BOARD = AllAdvancements.create("display_board_0", b -> b.icon((ItemProviderEntry<?>)AllBlocks.DISPLAY_BOARD).title("Dynamic Timetables").description("Forecast a Train's arrival on your Display Board with the help of Display Links").after(SIGNAL).special(CreateAdvancement.TaskType.NOISY));
    public static final CreateAdvancement TRAIN_TRACK = AllAdvancements.create("track_0", b -> b.icon((ItemProviderEntry<?>)AllBlocks.TRACK).title("A New Gauge").description("Obtain some Train Tracks").whenIconCollected().after(STURDY_SHEET));
    public static final CreateAdvancement TRAIN_WHISTLE = AllAdvancements.create("train_whistle", b -> b.icon((ItemProviderEntry<?>)AllBlocks.STEAM_WHISTLE).title("Choo Choo!").description("Assemble a Steam Whistle to your Train and activate it while driving").after(TRAIN_TRACK));
    public static final CreateAdvancement TRAIN_PORTAL = AllAdvancements.create("train_portal", b -> b.icon((ItemLike)Blocks.f_152490_).title("Dimensional Commuter").description("Ride a Train through a portal").after(TRAIN_WHISTLE).special(CreateAdvancement.TaskType.NOISY));
    public static final CreateAdvancement TRACK_CRAFTING = AllAdvancements.create("track_crafting_factory", b -> b.icon((ItemProviderEntry<?>)AllBlocks.MECHANICAL_PRESS).title("Track Factory").description("Produce more than 1000 Train Tracks with the same Mechanical Press").after(STURDY_SHEET).special(CreateAdvancement.TaskType.EXPERT));
    public static final CreateAdvancement LONG_TRAIN = AllAdvancements.create("long_train", b -> b.icon((ItemLike)Items.f_42449_).title("Ambitious Endeavours").description("Create a Train with at least 6 carriages").after(TRACK_CRAFTING).special(CreateAdvancement.TaskType.EXPERT));
    public static final CreateAdvancement LONG_TRAVEL = AllAdvancements.create("long_travel", b -> b.icon((ItemProviderEntry<?>)AllBlocks.SEATS.get(DyeColor.GREEN)).title("Field Trip").description("Leave a Train Seat over 5000 blocks away from where you started travelling").after(LONG_TRAIN).special(CreateAdvancement.TaskType.EXPERT));
    public static final CreateAdvancement TRAIN_ROADKILL = AllAdvancements.create("train_roadkill", b -> b.icon((ItemLike)Items.f_42388_).title("Road Kill").description("Run over an enemy with your Train").after(SIGNAL).special(CreateAdvancement.TaskType.SECRET));
    public static final CreateAdvancement RED_SIGNAL = AllAdvancements.create("red_signal", b -> b.icon((ItemProviderEntry<?>)AllBlocks.TRACK_SIGNAL).title("Expert Driver").description("Run a red Train Signal").after(SIGNAL).special(CreateAdvancement.TaskType.SECRET));
    public static final CreateAdvancement TRAIN_CRASH = AllAdvancements.create("train_crash", b -> b.icon((ItemProviderEntry<?>)AllItems.INCOMPLETE_TRACK).title("Terrible Service").description("Witness a Train crash as a passenger").after(SIGNAL).special(CreateAdvancement.TaskType.SECRET));
    public static final CreateAdvancement TRAIN_CRASH_BACKWARDS = AllAdvancements.create("train_crash_backwards", b -> b.icon((ItemProviderEntry<?>)AllItems.INCOMPLETE_TRACK).title("Blind Spot").description("Crash into another Train while driving backwards").after(SIGNAL).special(CreateAdvancement.TaskType.SECRET));
    public static final CreateAdvancement END = null;
    private final PackOutput output;

    private static CreateAdvancement create(String id, UnaryOperator<CreateAdvancement.Builder> b) {
        return new CreateAdvancement(id, b);
    }

    public AllAdvancements(PackOutput output) {
        this.output = output;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        PackOutput.PathProvider pathProvider = this.output.m_245269_(PackOutput.Target.DATA_PACK, "advancements");
        ArrayList futures = new ArrayList();
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = advancement -> {
            ResourceLocation id = advancement.m_138327_();
            if (!set.add(id)) {
                throw new IllegalStateException("Duplicate advancement " + id);
            }
            Path path = pathProvider.m_245731_(id);
            futures.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)advancement.m_138313_().m_138400_(), (Path)path));
        };
        for (CreateAdvancement advancement2 : ENTRIES) {
            advancement2.save(consumer);
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public String m_6055_() {
        return "Create's Advancements";
    }

    public static void provideLang(BiConsumer<String, String> consumer) {
        for (CreateAdvancement advancement : ENTRIES) {
            advancement.provideLang(consumer);
        }
    }

    public static void register() {
    }
}

