/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.inventory.container;

import com.mrcrayfish.furniture.core.ModContainers;
import com.mrcrayfish.furniture.core.ModRecipeTypes;
import com.mrcrayfish.furniture.inventory.container.slot.FreezerFuelSlot;
import com.mrcrayfish.furniture.inventory.container.slot.FreezerResultSlot;
import com.mrcrayfish.furniture.tileentity.FreezerBlockEntity;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class FreezerMenu
extends AbstractContainerMenu {
    private final FreezerBlockEntity blockEntity;
    private final ContainerData data;
    private final Level level;

    public FreezerMenu(int windowId, Inventory playerInventory, FreezerBlockEntity blockEntity) {
        super((MenuType)ModContainers.FREEZER.get(), windowId);
        int i;
        FreezerMenu.m_38869_((Container)blockEntity, (int)3);
        FreezerMenu.m_38886_((ContainerData)blockEntity.getFreezerData(), (int)4);
        blockEntity.m_5856_(playerInventory.f_35978_);
        this.blockEntity = blockEntity;
        this.data = blockEntity.getFreezerData();
        this.level = playerInventory.f_35978_.m_9236_();
        this.m_38897_(new Slot((Container)blockEntity, 0, 56, 17));
        this.m_38897_(new FreezerFuelSlot(this, (Container)blockEntity, 1, 56, 53));
        this.m_38897_(new FreezerResultSlot(playerInventory.f_35978_, (Container)blockEntity, 2, 116, 35));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
        this.m_38884_(this.data);
    }

    public FreezerBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public boolean m_6875_(Player playerIn) {
        return this.blockEntity.m_6542_(playerIn);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack copyStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            copyStack = slotStack.m_41777_();
            if (index == 2) {
                if (!this.m_38903_(slotStack, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(slotStack, copyStack);
            } else if (index != 1 && index != 0 ? (this.isIngredient(slotStack) ? !this.m_38903_(slotStack, 0, 1, false) : (this.isFuel(slotStack) ? !this.m_38903_(slotStack, 1, 2, false) : (index < 30 ? !this.m_38903_(slotStack, 30, 39, false) : index < 39 && !this.m_38903_(slotStack, 3, 30, false)))) : !this.m_38903_(slotStack, 3, 39, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == copyStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return copyStack;
    }

    public boolean isFuel(ItemStack stack) {
        return this.blockEntity.getFreezeTime(stack) > 0;
    }

    private boolean isIngredient(ItemStack stack) {
        return this.level.m_7465_().m_44015_((RecipeType)ModRecipeTypes.FREEZER_SOLIDIFY.get(), (Container)new SimpleContainer(new ItemStack[]{stack}), this.level).isPresent();
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.blockEntity.m_5785_(player);
    }

    public int getSolidifyProgressionScaled() {
        int freezeTime = this.data.m_6413_(2);
        int freezeTimeTotal = this.data.m_6413_(3);
        return freezeTimeTotal != 0 && freezeTime != 0 ? freezeTime * 24 / freezeTimeTotal : 0;
    }

    public int getFuelLeftScaled() {
        int fuelTimeTotal = this.data.m_6413_(1);
        if (fuelTimeTotal == 0) {
            fuelTimeTotal = 200;
        }
        return this.data.m_6413_(0) * 13 / fuelTimeTotal;
    }

    public boolean isFueling() {
        return this.data.m_6413_(0) > 0;
    }
}

