/*
 * Decompiled with CFR 0.152.
 */
package com.cosmicdan.sleepingoverhaul.server;

import com.cosmicdan.sleepingoverhaul.IClientState;
import com.cosmicdan.sleepingoverhaul.SleepingOverhaul;
import com.cosmicdan.sleepingoverhaul.mixin.proxy.PlayerMixinProxy;
import com.cosmicdan.sleepingoverhaul.server.ServerConfig;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ServerState {
    public static final ResourceLocation PACKET_REALLY_SLEEPING = new ResourceLocation("sleepingoverhaul", "is_really_sleeping");
    private long timelapseEnd = -1L;
    private long timelapseStartNanos = 0L;
    private long timelapseTickCount = 0L;

    public ServerState() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)PACKET_REALLY_SLEEPING, this::onReallySleepingRecv);
    }

    public void onTimelapseStart() {
        if (((Boolean)SleepingOverhaul.serverConfig.logTimelapsePerformanceStats.get()).booleanValue()) {
            this.timelapseStartNanos = Util.m_137569_();
            this.timelapseTickCount = 0L;
        }
    }

    public void onTimelapseEnd() {
        if (((Boolean)SleepingOverhaul.serverConfig.logTimelapsePerformanceStats.get()).booleanValue()) {
            double timelapseSeconds = (double)(Util.m_137569_() - this.timelapseStartNanos) / 1000000.0 / 1000.0;
            double ticksPerSecond = (double)this.timelapseTickCount / timelapseSeconds;
            SleepingOverhaul.LOGGER.info("Timelapse finished. Average TPS = {}; total time = {} seconds; total ticks = {}", new Object[]{ticksPerSecond, timelapseSeconds, this.timelapseTickCount});
        }
    }

    public void onServerTickPost() {
        if (this.timelapseEnd > 0L && ((Boolean)SleepingOverhaul.serverConfig.logTimelapsePerformanceStats.get()).booleanValue()) {
            ++this.timelapseTickCount;
        }
    }

    public boolean tickTimelapse(ServerLevel level) {
        boolean timelapseActive = true;
        if (this.timelapseEnd == -1L) {
            this.notifyPlayersTimelapseChange(level.m_6907_(), true);
            this.timelapseEnd = ServerState.getNextMorning(level);
            this.onTimelapseStart();
        } else if (this.timelapseEnd == -2L) {
            timelapseActive = false;
            this.notifyPlayersTimelapseChange(level.m_6907_(), false);
            this.timelapseEnd = -1L;
            this.onTimelapseEnd();
        }
        return timelapseActive;
    }

    public static long getNextMorning(ServerLevel level) {
        long oneDayAhead = level.m_6106_().m_6792_() + 24000L;
        long nextMorning = oneDayAhead - oneDayAhead % 24000L;
        return nextMorning;
    }

    private void notifyPlayersTimelapseChange(Iterable<ServerPlayer> players, boolean timelapseActive) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeBoolean(timelapseActive);
        NetworkManager.sendToPlayers(players, (ResourceLocation)IClientState.PACKET_TIMELAPSE_CHANGE, (FriendlyByteBuf)buf);
    }

    private void onReallySleepingRecv(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        if (this.canSleepNow(player.m_9236_())) {
            boolean reallySleeping = buf.readBoolean();
            ((PlayerMixinProxy)player).setReallySleeping(reallySleeping);
        } else {
            FriendlyByteBuf bufPong = new FriendlyByteBuf(Unpooled.buffer());
            bufPong.writeBoolean(true);
            NetworkManager.sendToPlayer((ServerPlayer)((ServerPlayer)player), (ResourceLocation)IClientState.PACKET_SLEEPERROR_TIME, (FriendlyByteBuf)bufPong);
        }
    }

    private boolean canSleepNow(Level level) {
        return !level.m_46461_();
    }

    public void onBeforeTickTime(ServerLevel level) {
        if (this.timelapseEnd > 0L && level.m_46468_() >= this.timelapseEnd) {
            this.timelapseEnd = -2L;
        }
    }

    public boolean shouldPreventLivingTravel() {
        return (Boolean)SleepingOverhaul.serverConfig.disableLivingEntityTravel.get() != false && this.timelapseEnd > 0L;
    }

    public boolean timelapsePending() {
        return this.timelapseEnd > 0L;
    }

    public float getPlayerHurtAdj(ServerPlayer player, DamageSource source, float amount) {
        float amountAdjusted = amount;
        if (this.timelapsePending()) {
            if (((Boolean)SleepingOverhaul.serverConfig.sleepPreventMagicDamage.get()).booleanValue() && source.m_269014_()) {
                amountAdjusted = Float.NaN;
            } else {
                switch ((ServerConfig.AttackedWhileSleepingAction)((Object)SleepingOverhaul.serverConfig.sleepAttackedAction.get())) {
                    case NoChange: {
                        break;
                    }
                    case InstantKill: {
                        amountAdjusted = Float.POSITIVE_INFINITY;
                        break;
                    }
                    case Invincible: {
                        amountAdjusted = Float.NaN;
                    }
                }
            }
        }
        return amountAdjusted;
    }
}

