/*
 * Decompiled with CFR 0.152.
 */
package com.cosmicdan.sleepingoverhaul.server;

import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfig {
    private static final String sectionGeneral = "general";
    public final ForgeConfigSpec.EnumValue<SleepAction> sleepAction;
    private static final String sleepActionTxt = " The action to perform when all players are sleeping";
    private static final String sectionMorning = "morning";
    public final ForgeConfigSpec.BooleanValue morningResetWeather;
    private static final String morningResetWeatherTxt = " Reset the weather on morning (when players wake) if raining.";
    private static final String sectionTimelapse = "timelapse";
    public final ForgeConfigSpec.EnumValue<AttackedWhileSleepingAction> sleepAttackedAction;
    private static final String sleepAttackedActionTxt = " The action to perform on a player if they are attacked during timelapse sleep, for damage sources that do *not* match any preventions below.";
    public final ForgeConfigSpec.BooleanValue sleepPreventMagicDamage;
    private static final String sleepPreventMagicDamageTxt = " If true, damage type of 'Magic' (pre-1.19.4) or 'Indirect' (1.19.4+) will not apply to players during timelapse. This includes DoT's like Poison.";
    public final ForgeConfigSpec.BooleanValue logTimelapsePerformanceStats;
    private static final String logTimelapsePerformanceStatsTxt = " If true, will performance stats will be logged on timelapse end (average TPS, total time, total ticks)";
    public final ForgeConfigSpec.BooleanValue disableNaturalSpawning;
    private static final String disableNaturalSpawningTxt = " If true, natural spawning will be disabled during timelapse.\n Gives a minor speed boost.";
    public final ForgeConfigSpec.BooleanValue disableLivingEntityTravel;
    private static final String disableLivingEntityTravelTxt = " If true, LivingEntity type mobs will not travel during timelapse. Gives a minor speed boost.\n Disabled by default since it could result in undesired loss, e.g. mobs drowning.\n Note that this does NOT seem to include Villager movement.";
    private static final String sectionBedrest = "bedRest";
    public final ForgeConfigSpec.BooleanValue bedRestEnabled;
    private static final String bedRestEnabledTxt = " Allows players to rest in a bed without sleeping, adding a 'Sleep' button next to 'Leave Bed'";
    public final ForgeConfigSpec.BooleanValue bedRestOnEnter;
    private static final String bedRestOnEnterTxt = " Allows pressing Enter with no chat text to activate Sleep while resting. Requires the above bedRestEnabled to be true.";

    public ServerConfig(ForgeConfigSpec.Builder builder) {
        builder.push(sectionGeneral);
        this.sleepAction = builder.comment(sleepActionTxt).defineEnum("sleepAction", (Enum)SleepAction.Timelapse);
        builder.pop();
        builder.push(sectionMorning);
        this.morningResetWeather = builder.comment(morningResetWeatherTxt).define("morningResetWeather", true);
        builder.pop();
        builder.push(sectionTimelapse);
        this.sleepAttackedAction = builder.comment(sleepAttackedActionTxt).defineEnum("sleepAttackedAction", (Enum)AttackedWhileSleepingAction.NoChange);
        this.sleepPreventMagicDamage = builder.comment(sleepPreventMagicDamageTxt).define("sleepPreventMagicDamage", false);
        this.logTimelapsePerformanceStats = builder.comment(logTimelapsePerformanceStatsTxt).define("logTimelapsePerformanceStats", true);
        this.disableNaturalSpawning = builder.comment(disableNaturalSpawningTxt).define("disableNaturalSpawning", true);
        this.disableLivingEntityTravel = builder.comment(disableLivingEntityTravelTxt).define("disableLivingEntityTravel", false);
        builder.pop();
        builder.push(sectionBedrest);
        this.bedRestEnabled = builder.comment(bedRestEnabledTxt).define("bedRestEnabled", true);
        this.bedRestOnEnter = builder.comment(bedRestOnEnterTxt).define("bedRestWithChatEnter", true);
        builder.pop();
    }

    public static enum SleepAction {
        Timelapse,
        SkipToDay,
        Nothing;

    }

    public static enum AttackedWhileSleepingAction {
        NoChange,
        InstantKill,
        Invincible;

    }
}

