/*
 * Decompiled with CFR 0.152.
 */
package com.cosmicdan.sleepingoverhaul.client;

import com.cosmicdan.sleepingoverhaul.IClientState;
import dev.architectury.networking.NetworkManager;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.InBedChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ClientState
implements IClientState {
    private Button leaveButton = null;
    private Button sleepButton = null;
    private int timelapseCinematicStage = 0;

    public ClientState() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)IClientState.PACKET_SLEEPERROR_TIME, this::recvSleepErrorTime);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)IClientState.PACKET_TIMELAPSE_CHANGE, this::recvTimelapseChange);
    }

    private void recvSleepErrorTime(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        context.getPlayer().m_5661_(Player.BedSleepingProblem.NOT_POSSIBLE_NOW.m_36423_(), true);
        this.doSleepButtonCooldown();
    }

    private void recvTimelapseChange(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        boolean timelapseEnabled = buf.readBoolean();
        this.setTimelapseEnabled(timelapseEnabled);
    }

    @Override
    public boolean isSleepButtonActive() {
        return this.sleepButton != null && this.sleepButton.m_142518_();
    }

    @Override
    public <T> void leaveBedButtonAssign(T buttonRaw) {
        if (buttonRaw instanceof Button) {
            Button button;
            this.leaveButton = button = (Button)buttonRaw;
        }
    }

    @Override
    public <T> void sleepButtonAssign(T buttonRaw) {
        if (buttonRaw instanceof Button) {
            Button button;
            this.sleepButton = button = (Button)buttonRaw;
        }
    }

    @Override
    public void sleepButtonDisable() {
        if (this.sleepButton != null) {
            this.sleepButton.f_93623_ = false;
        }
    }

    @Override
    public void doSleepButtonCooldown() {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                if (ClientState.this.sleepButton != null) {
                    ClientState.this.sleepButton.f_93623_ = true;
                }
            }
        }, 2000L);
    }

    @Override
    public void setTimelapseEnabled(boolean timelapseEnabled) {
        Screen screen;
        if (timelapseEnabled) {
            Minecraft.m_91087_().f_91063_.m_172779_(true);
            if (this.timelapseCinematicStage == 0) {
                this.timelapseCinematicStage = 1;
            }
        } else {
            Minecraft.m_91087_().f_91063_.m_172779_(false);
            this.timelapseCinematicStage = 3;
        }
        if (Minecraft.m_91087_().f_91080_ != null && (screen = Minecraft.m_91087_().f_91080_) instanceof InBedChatScreen) {
            InBedChatScreen screenBedChat = (InBedChatScreen)screen;
            if (timelapseEnabled) {
                this.removeBedScreenButtons();
            }
        }
    }

    @Override
    public int getTimelapseCinematicStage() {
        return this.timelapseCinematicStage;
    }

    @Override
    public void advanceTimelapseCinematicStage() {
        this.timelapseCinematicStage = this.timelapseCinematicStage == 3 ? 0 : ++this.timelapseCinematicStage;
    }

    @Override
    public void removeBedScreenButtons() {
        if (this.leaveButton != null) {
            this.leaveButton.f_93624_ = false;
        }
        if (this.sleepButton != null) {
            this.sleepButton.f_93624_ = false;
        }
    }

    @Override
    public void onSleepingCheck(boolean isInBed) {
        if (!isInBed && this.timelapseCinematicStage != 0) {
            this.timelapseCinematicStage = 0;
        }
    }
}

