/*
 * Decompiled with CFR 0.152.
 */
package com.cosmicdan.sleepingoverhaul;

import com.cosmicdan.sleepingoverhaul.IClientState;
import com.cosmicdan.sleepingoverhaul.ModConfigHelper;
import com.cosmicdan.sleepingoverhaul.TimelapseKillDamageSource;
import com.cosmicdan.sleepingoverhaul.client.ClientConfig;
import com.cosmicdan.sleepingoverhaul.client.ClientState;
import com.cosmicdan.sleepingoverhaul.server.ClientStateDummy;
import com.cosmicdan.sleepingoverhaul.server.ServerConfig;
import com.cosmicdan.sleepingoverhaul.server.ServerState;
import com.mojang.logging.LogUtils;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public class SleepingOverhaul {
    public static final String MOD_ID = "sleepingoverhaul";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static ServerState serverState = null;
    public static IClientState clientState = null;
    public static ServerConfig serverConfig = null;
    public static ClientConfig clientConfig = null;

    public SleepingOverhaul() {
        Pair specPairServer = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        serverConfig = (ServerConfig)specPairServer.getLeft();
        ModConfigHelper.registerConfig(ModConfig.Type.SERVER, (IConfigSpec<ForgeConfigSpec>)((IConfigSpec)specPairServer.getRight()));
        serverState = new ServerState();
        if (Platform.getEnvironment() == Env.CLIENT) {
            clientState = new ClientState();
            Pair specPairClient = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
            clientConfig = (ClientConfig)specPairClient.getLeft();
            ModConfigHelper.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec<ForgeConfigSpec>)((IConfigSpec)specPairClient.getRight()));
        } else {
            clientState = new ClientStateDummy();
        }
        EntityEvent.LIVING_HURT.register(SleepingOverhaul::onLivingHurt);
    }

    private static EventResult onLivingHurt(LivingEntity entity, DamageSource source, float amount) {
        EventResult eventResult = EventResult.pass();
        if (serverState.timelapsePending() && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (!source.m_19385_().equals("sleepingoverhaul2.timelapseKill")) {
                float adjustedDamage = serverState.getPlayerHurtAdj(player, source, amount);
                if (Float.isNaN(adjustedDamage)) {
                    eventResult = EventResult.interruptFalse();
                } else if (Float.isInfinite(adjustedDamage)) {
                    eventResult = EventResult.interruptFalse();
                    player.m_6469_((DamageSource)new TimelapseKillDamageSource(), Float.MAX_VALUE);
                }
            }
        }
        return eventResult;
    }
}

