/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.command;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.server.ServerLifecycleHooks;
import noobanidus.mods.lootr.api.blockentity.ILootBlockEntity;
import noobanidus.mods.lootr.block.LootrBarrelBlock;
import noobanidus.mods.lootr.block.LootrChestBlock;
import noobanidus.mods.lootr.block.LootrInventoryBlock;
import noobanidus.mods.lootr.block.LootrShulkerBlock;
import noobanidus.mods.lootr.block.entities.LootrInventoryBlockEntity;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.data.DataStorage;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;
import noobanidus.mods.lootr.init.ModBlocks;
import noobanidus.mods.lootr.util.ChestUtil;

public class CommandLootr {
    private final CommandDispatcher<CommandSourceStack> dispatcher;
    private static List<ResourceLocation> tables = null;
    private static List<String> tableNames = null;
    private static final Map<String, UUID> profileMap = new HashMap<String, UUID>();

    public CommandLootr(CommandDispatcher<CommandSourceStack> dispatcher) {
        this.dispatcher = dispatcher;
    }

    public CommandLootr register() {
        this.dispatcher.register(this.builder((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.m_82127_((String)"lootr").requires(p -> p.m_6761_(2)))));
        return this;
    }

    private static List<ResourceLocation> getTables() {
        if (tables == null) {
            tables = new ArrayList<ResourceLocation>(BuiltInLootTables.m_78766_());
            tableNames = tables.stream().map(ResourceLocation::toString).collect(Collectors.toList());
        }
        return tables;
    }

    private static List<String> getProfiles() {
        return Lists.newArrayList(ServerLifecycleHooks.getCurrentServer().m_129927_().f_10966_.keySet());
    }

    private static List<String> getTableNames() {
        CommandLootr.getTables();
        return tableNames;
    }

    public static void createBlock(CommandSourceStack c, @Nullable Block block, @Nullable ResourceLocation incomingTable) {
        ServerLevel world = c.m_81372_();
        Vec3 incomingPos = c.m_81371_();
        BlockPos pos = new BlockPos((int)incomingPos.f_82479_, (int)incomingPos.f_82480_, (int)incomingPos.f_82481_);
        ResourceLocation table = incomingTable == null ? CommandLootr.getTables().get(world.m_213780_().m_188503_(CommandLootr.getTables().size())) : incomingTable;
        if (block == null) {
            LootrChestMinecartEntity cart = new LootrChestMinecartEntity((Level)world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            Entity e = c.m_81373_();
            if (e != null) {
                cart.m_146922_(e.m_146908_());
            }
            cart.m_38236_(table, world.m_213780_().m_188505_());
            world.m_7967_((Entity)cart);
            c.m_288197_(() -> Component.m_237110_((String)"lootr.commands.summon", (Object[])new Object[]{ComponentUtils.m_130748_((Component)Component.m_237110_((String)"lootr.commands.blockpos", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GREEN)).m_131136_(Boolean.valueOf(true)))), table.toString()}), false);
        } else {
            BlockState placementState = block.m_49966_();
            Entity e = c.m_81373_();
            if (e != null) {
                DirectionProperty prop = null;
                Direction dir = Direction.m_122382_((Entity)e)[0].m_122424_();
                if (placementState.m_61138_((Property)LootrBarrelBlock.f_49042_)) {
                    prop = LootrBarrelBlock.f_49042_;
                } else if (placementState.m_61138_((Property)LootrChestBlock.f_51478_)) {
                    prop = LootrChestBlock.f_51478_;
                    dir = e.m_6350_().m_122424_();
                } else if (placementState.m_61138_((Property)LootrShulkerBlock.f_56183_)) {
                    prop = LootrShulkerBlock.f_56183_;
                }
                if (prop != null) {
                    placementState = (BlockState)placementState.m_61124_((Property)prop, (Comparable)dir);
                }
            }
            world.m_7731_(pos, placementState, 2);
            RandomizableContainerBlockEntity.m_222766_((BlockGetter)world, (RandomSource)world.m_213780_(), (BlockPos)pos, (ResourceLocation)table);
            c.m_288197_(() -> Component.m_237110_((String)"lootr.commands.create", (Object[])new Object[]{Component.m_237115_((String)block.m_7705_()), ComponentUtils.m_130748_((Component)Component.m_237110_((String)"lootr.commands.blockpos", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GREEN)).m_131136_(Boolean.valueOf(true)))), table.toString()}), false);
        }
    }

    private RequiredArgumentBuilder<CommandSourceStack, ResourceLocation> suggestTables() {
        return Commands.m_82129_((String)"table", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((c, build) -> SharedSuggestionProvider.m_82970_(CommandLootr.getTableNames(), (SuggestionsBuilder)build));
    }

    private RequiredArgumentBuilder<CommandSourceStack, String> suggestProfiles() {
        return Commands.m_82129_((String)"profile", (ArgumentType)StringArgumentType.string()).suggests((c, build) -> SharedSuggestionProvider.m_82970_(CommandLootr.getProfiles(), (SuggestionsBuilder)build));
    }

    public LiteralArgumentBuilder<CommandSourceStack> builder(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.executes(c -> {
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237115_((String)"lootr.commands.usage"), false);
            return 1;
        });
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"barrel").executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), (Block)ModBlocks.BARREL.get(), null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), (Block)ModBlocks.BARREL.get(), ResourceLocationArgument.m_107011_((CommandContext)c, (String)"table"));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"trapped_chest").executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), (Block)ModBlocks.TRAPPED_CHEST.get(), null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), (Block)ModBlocks.TRAPPED_CHEST.get(), ResourceLocationArgument.m_107011_((CommandContext)c, (String)"table"));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"chest").executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), (Block)ModBlocks.CHEST.get(), null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), (Block)ModBlocks.CHEST.get(), ResourceLocationArgument.m_107011_((CommandContext)c, (String)"table"));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"shulker").executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), (Block)ModBlocks.SHULKER.get(), null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), (Block)ModBlocks.SHULKER.get(), ResourceLocationArgument.m_107011_((CommandContext)c, (String)"table"));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").executes(c -> {
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Must provide player name."), true);
            return 1;
        })).then(this.suggestProfiles().executes(c -> {
            String playerName = StringArgumentType.getString((CommandContext)c, (String)"profile");
            Optional opt_profile = ((CommandSourceStack)c.getSource()).m_81377_().m_129927_().m_10996_(playerName);
            if (!opt_profile.isPresent()) {
                ((CommandSourceStack)c.getSource()).m_81352_((Component)Component.m_237113_((String)("Invalid player name: " + playerName + ", profile not found in the cache.")));
                return 0;
            }
            GameProfile profile = (GameProfile)opt_profile.get();
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)(DataStorage.clearInventories(profile.getId()) ? "Cleared stored inventories for " + playerName : "No stored inventories for " + playerName + " to clear")), true);
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"cart").executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), null, null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((CommandSourceStack)c.getSource(), null, ResourceLocationArgument.m_107011_((CommandContext)c, (String)"table"));
            return 1;
        })));
        builder.then(Commands.m_82127_((String)"custom").executes(c -> {
            BlockPos pos = BlockPos.m_274446_((Position)((CommandSourceStack)c.getSource()).m_81371_());
            ServerLevel world = ((CommandSourceStack)c.getSource()).m_81372_();
            BlockState state = world.m_8055_(pos);
            if (!state.m_60713_(Blocks.f_50087_) && !state.m_60713_(Blocks.f_50618_)) {
                pos = pos.m_7495_();
                state = world.m_8055_(pos);
            }
            if (!state.m_60713_(Blocks.f_50087_) && !state.m_60713_(Blocks.f_50618_)) {
                ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Please stand on the chest or barrel you wish to convert."), false);
            } else {
                BlockState newState;
                NonNullList reference;
                if (state.m_60713_(Blocks.f_50087_)) {
                    reference = ((ChestBlockEntity)Objects.requireNonNull(world.m_7702_((BlockPos)pos))).f_59073_;
                    newState = (BlockState)((BlockState)((LootrInventoryBlock)((Object)((Object)ModBlocks.INVENTORY.get()))).m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)((Direction)state.m_61143_((Property)ChestBlock.f_51478_)))).m_61124_((Property)ChestBlock.f_51480_, (Comparable)((Boolean)state.m_61143_((Property)ChestBlock.f_51480_)));
                } else {
                    Direction facing = (Direction)state.m_61143_((Property)BarrelBlock.f_49042_);
                    if (facing == Direction.UP || facing == Direction.DOWN) {
                        facing = Direction.NORTH;
                    }
                    reference = ((BarrelBlockEntity)Objects.requireNonNull(world.m_7702_((BlockPos)pos))).f_58591_;
                    newState = (BlockState)((LootrInventoryBlock)((Object)((Object)ModBlocks.INVENTORY.get()))).m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)facing);
                }
                NonNullList<ItemStack> custom = ChestUtil.copyItemList((NonNullList<ItemStack>)reference);
                world.m_46747_(pos);
                world.m_46597_(pos, newState);
                BlockEntity te = world.m_7702_(pos);
                if (!(te instanceof LootrInventoryBlockEntity)) {
                    ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Unable to convert chest, BlockState is not a Lootr Inventory block."), false);
                } else {
                    LootrInventoryBlockEntity inventory = (LootrInventoryBlockEntity)te;
                    inventory.setCustomInventory(custom);
                    inventory.m_6596_();
                }
            }
            return 1;
        }));
        builder.then(Commands.m_82127_((String)"id").executes(c -> {
            BlockPos pos = BlockPos.m_274446_((Position)((CommandSourceStack)c.getSource()).m_81371_());
            ServerLevel world = ((CommandSourceStack)c.getSource()).m_81372_();
            BlockEntity te = world.m_7702_(pos);
            if (!(te instanceof ILootBlockEntity)) {
                pos = pos.m_7495_();
                te = world.m_7702_(pos);
            }
            if (!(te instanceof ILootBlockEntity)) {
                ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Please stand on a valid Lootr container."), false);
            } else {
                ILootBlockEntity ibe = (ILootBlockEntity)te;
                ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)("The ID of this inventory is: " + ibe.getTileId().toString())), false);
            }
            return 1;
        }));
        builder.then(Commands.m_82127_((String)"refresh").executes(c -> {
            BlockPos pos = BlockPos.m_274446_((Position)((CommandSourceStack)c.getSource()).m_81371_());
            ServerLevel level = ((CommandSourceStack)c.getSource()).m_81372_();
            BlockEntity be = level.m_7702_(pos);
            if (!(be instanceof ILootBlockEntity)) {
                pos = pos.m_7495_();
                be = level.m_7702_(pos);
            }
            if (be instanceof ILootBlockEntity) {
                ILootBlockEntity ibe = (ILootBlockEntity)be;
                DataStorage.setRefreshing(((ILootBlockEntity)be).getTileId(), (Integer)ConfigManager.REFRESH_VALUE.get());
                ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)("Container with ID " + ibe.getTileId() + " has been set to refresh with a delay of " + ConfigManager.REFRESH_VALUE.get())), false);
            } else {
                ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Please stand on a valid Lootr container."), false);
            }
            return 1;
        }));
        builder.then(Commands.m_82127_((String)"decay").executes(c -> {
            BlockPos pos = BlockPos.m_274446_((Position)((CommandSourceStack)c.getSource()).m_81371_());
            ServerLevel level = ((CommandSourceStack)c.getSource()).m_81372_();
            BlockEntity be = level.m_7702_(pos);
            if (!(be instanceof ILootBlockEntity)) {
                pos = pos.m_7495_();
                be = level.m_7702_(pos);
            }
            if (be instanceof ILootBlockEntity) {
                ILootBlockEntity ibe = (ILootBlockEntity)be;
                DataStorage.setDecaying(ibe.getTileId(), (Integer)ConfigManager.DECAY_VALUE.get());
                ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)("Container with ID " + ibe.getTileId() + " has been set to decay with a delay of " + ConfigManager.DECAY_VALUE.get())), false);
            } else {
                ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Please stand on a valid Lootr container."), false);
            }
            return 1;
        }));
        builder.then(Commands.m_82127_((String)"openers").then(Commands.m_82129_((String)"location", (ArgumentType)Vec3Argument.m_120841_()).executes(c -> {
            BlockPos position = Vec3Argument.m_120849_((CommandContext)c, (String)"location").m_119568_((CommandSourceStack)c.getSource());
            ServerLevel world = ((CommandSourceStack)c.getSource()).m_81372_();
            BlockEntity tile = world.m_7702_(position);
            if (tile instanceof ILootBlockEntity) {
                ILootBlockEntity ibe = (ILootBlockEntity)tile;
                Set<UUID> openers = ((ILootBlockEntity)tile).getOpeners();
                ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)("Tile at location " + position + " has " + openers.size() + " openers. UUIDs as follows:")), true);
                for (UUID uuid : openers) {
                    Optional prof = ((CommandSourceStack)c.getSource()).m_81377_().m_129927_().m_11002_(uuid);
                    ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)("UUID: " + uuid.toString() + ", user profile: " + (prof.isPresent() ? ((GameProfile)prof.get()).getName() : "null"))), true);
                }
            } else {
                ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)("No Lootr tile exists at location: " + position)), false);
            }
            return 1;
        })));
        return builder;
    }
}

