/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import noobanidus.mods.lootr.block.entities.LootrShulkerBlockEntity;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.init.ModBlockEntities;
import noobanidus.mods.lootr.init.ModItems;
import noobanidus.mods.lootr.util.ChestUtil;

public class LootrShulkerBlock
extends ShulkerBoxBlock {
    public LootrShulkerBlock(BlockBehaviour.Properties pProperties) {
        super(DyeColor.YELLOW, pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_56183_, (Comparable)Direction.UP));
    }

    public float m_7325_() {
        if (((Boolean)ConfigManager.BLAST_IMMUNE.get()).booleanValue()) {
            return Float.MAX_VALUE;
        }
        if (((Boolean)ConfigManager.BLAST_RESISTANT.get()).booleanValue()) {
            return 16.0f;
        }
        return super.m_7325_();
    }

    private static boolean canOpen(BlockState pState, Level pLevel, BlockPos pPos, LootrShulkerBlockEntity pBlockEntity) {
        if (pBlockEntity.getAnimationStatus() != ShulkerBoxBlockEntity.AnimationStatus.CLOSED) {
            return true;
        }
        AABB aabb = Shulker.m_149793_((Direction)((Direction)pState.m_61143_((Property)f_56183_)), (float)0.0f, (float)0.5f).m_82338_(pPos).m_82406_(1.0E-6);
        return pLevel.m_45772_(aabb);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (pPlayer.m_5833_()) {
            return InteractionResult.CONSUME;
        }
        BlockEntity blockentity = pLevel.m_7702_(pPos);
        if (blockentity instanceof LootrShulkerBlockEntity) {
            LootrShulkerBlockEntity shulkerboxblockentity = (LootrShulkerBlockEntity)blockentity;
            if (LootrShulkerBlock.canOpen(pState, pLevel, pPos, shulkerboxblockentity)) {
                if (pPlayer.m_6144_()) {
                    ChestUtil.handleLootSneak((Block)this, pLevel, pPos, pPlayer);
                } else {
                    ChestUtil.handleLootChest((Block)this, pLevel, pPos, pPlayer);
                }
                pPlayer.m_36220_(Stats.f_12970_);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        this.m_142387_(pLevel, pPlayer, pPos, pState);
        if (pState.m_204336_(BlockTags.f_13088_)) {
            PiglinAi.m_34873_((Player)pPlayer, (boolean)false);
        }
        pLevel.m_142346_((Entity)pPlayer, GameEvent.f_157794_, pPos);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            BlockEntity blockentity = pLevel.m_7702_(pPos);
            if (blockentity instanceof LootrShulkerBlockEntity) {
                pLevel.m_46717_(pPos, pState.m_60734_());
            }
            if (!(!pState.m_155947_() || pState.m_60713_(pNewState.m_60734_()) && pNewState.m_155947_())) {
                pLevel.m_46747_(pPos);
            }
        }
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        BlockEntity blockentity = pLevel.m_7702_(pPos);
        return blockentity instanceof LootrShulkerBlockEntity ? Shapes.m_83064_((AABB)((LootrShulkerBlockEntity)blockentity).getBoundingBox(pState)) : Shapes.m_83144_();
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        if (((Boolean)ConfigManager.POWER_COMPARATORS.get()).booleanValue()) {
            return 1;
        }
        return 0;
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return new ItemStack((ItemLike)ModItems.SHULKER.get());
    }

    @Nullable
    public DyeColor m_56261_() {
        return DyeColor.YELLOW;
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new LootrShulkerBlockEntity((BlockEntityType)ModBlockEntities.LOOTR_SHULKER.get(), pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return LootrShulkerBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.LOOTR_SHULKER.get()), LootrShulkerBlockEntity::tick);
    }
}

