/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.worldgen.utils;

import com.mojang.serialization.DataResult;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.plaaasma.vortexmod.worldgen.biome.surface.ModSurfaceRules;

public record ModNoiseGenerator(NoiseSettings noiseSettings, BlockState defaultBlock, BlockState defaultFluid, NoiseRouter noiseRouter, SurfaceRules.RuleSource surfaceRule, List<Climate.ParameterPoint> spawnTarget, int seaLevel, boolean disableMobGeneration, boolean aquifersEnabled, boolean oreVeinsEnabled, boolean useLegacyRandomSource) {
    public static final ResourceKey<NoiseGeneratorSettings> VORTEX_CAVES = ResourceKey.m_135785_((ResourceKey)Registries.f_256932_, (ResourceLocation)new ResourceLocation("vortexmod", "vortex_caves"));
    public static final ResourceKey<NoiseGeneratorSettings> VOID = ResourceKey.m_135785_((ResourceKey)Registries.f_256932_, (ResourceLocation)new ResourceLocation("vortexmod", "tardis_void"));
    public static final ResourceKey<NoiseGeneratorSettings> OVERWORLD = ResourceKey.m_135785_((ResourceKey)Registries.f_256932_, (ResourceLocation)new ResourceLocation("vortexmod", "overworld"));
    static final NoiseSettings OVERWORLD_NOISE_SETTINGS = ModNoiseGenerator.create(-256, 1600, 1, 2);
    public static final float GLOBAL_OFFSET = -0.50375f;
    private static final float ORE_THICKNESS = 0.08f;
    private static final double VEININESS_FREQUENCY = 1.5;
    private static final double NOODLE_SPACING_AND_STRAIGHTNESS = 1.5;
    private static final double SURFACE_DENSITY_THRESHOLD = 1.5625;
    private static final double CHEESE_NOISE_TARGET = -0.703125;
    public static final int ISLAND_CHUNK_DISTANCE = 64;
    public static final long ISLAND_CHUNK_DISTANCE_SQR = 4096L;
    private static final DensityFunction BLENDING_FACTOR = DensityFunctions.m_208264_((double)10.0);
    private static final DensityFunction BLENDING_JAGGEDNESS = DensityFunctions.m_208263_();
    private static final ResourceKey<DensityFunction> ZERO = ModNoiseGenerator.createKey("zero");
    private static final ResourceKey<DensityFunction> Y = ModNoiseGenerator.createKey("y");
    private static final ResourceKey<DensityFunction> SHIFT_X = ModNoiseGenerator.createKey("shift_x");
    private static final ResourceKey<DensityFunction> SHIFT_Z = ModNoiseGenerator.createKey("shift_z");
    private static final ResourceKey<DensityFunction> BASE_3D_NOISE_OVERWORLD = ModNoiseGenerator.createKey("overworld/base_3d_noise");
    private static final ResourceKey<DensityFunction> BASE_3D_NOISE_NETHER = ModNoiseGenerator.createKey("nether/base_3d_noise");
    private static final ResourceKey<DensityFunction> BASE_3D_NOISE_END = ModNoiseGenerator.createKey("end/base_3d_noise");
    public static final ResourceKey<DensityFunction> CONTINENTS = ModNoiseGenerator.createKey("overworld/continents");
    public static final ResourceKey<DensityFunction> EROSION = ModNoiseGenerator.createKey("overworld/erosion");
    public static final ResourceKey<DensityFunction> RIDGES = ModNoiseGenerator.createKey("overworld/ridges");
    public static final ResourceKey<DensityFunction> RIDGES_FOLDED = ModNoiseGenerator.createKey("overworld/ridges_folded");
    public static final ResourceKey<DensityFunction> OFFSET = ModNoiseGenerator.createKey("overworld/offset");
    public static final ResourceKey<DensityFunction> FACTOR = ModNoiseGenerator.createKey("overworld/factor");
    public static final ResourceKey<DensityFunction> JAGGEDNESS = ModNoiseGenerator.createKey("overworld/jaggedness");
    public static final ResourceKey<DensityFunction> DEPTH = ModNoiseGenerator.createKey("overworld/depth");
    private static final ResourceKey<DensityFunction> SLOPED_CHEESE = ModNoiseGenerator.createKey("overworld/sloped_cheese");
    public static final ResourceKey<DensityFunction> CONTINENTS_LARGE = ModNoiseGenerator.createKey("overworld_large_biomes/continents");
    public static final ResourceKey<DensityFunction> EROSION_LARGE = ModNoiseGenerator.createKey("overworld_large_biomes/erosion");
    private static final ResourceKey<DensityFunction> OFFSET_LARGE = ModNoiseGenerator.createKey("overworld_large_biomes/offset");
    private static final ResourceKey<DensityFunction> FACTOR_LARGE = ModNoiseGenerator.createKey("overworld_large_biomes/factor");
    private static final ResourceKey<DensityFunction> JAGGEDNESS_LARGE = ModNoiseGenerator.createKey("overworld_large_biomes/jaggedness");
    private static final ResourceKey<DensityFunction> DEPTH_LARGE = ModNoiseGenerator.createKey("overworld_large_biomes/depth");
    private static final ResourceKey<DensityFunction> SLOPED_CHEESE_LARGE = ModNoiseGenerator.createKey("overworld_large_biomes/sloped_cheese");
    private static final ResourceKey<DensityFunction> OFFSET_AMPLIFIED = ModNoiseGenerator.createKey("overworld_amplified/offset");
    private static final ResourceKey<DensityFunction> FACTOR_AMPLIFIED = ModNoiseGenerator.createKey("overworld_amplified/factor");
    private static final ResourceKey<DensityFunction> JAGGEDNESS_AMPLIFIED = ModNoiseGenerator.createKey("overworld_amplified/jaggedness");
    private static final ResourceKey<DensityFunction> DEPTH_AMPLIFIED = ModNoiseGenerator.createKey("overworld_amplified/depth");
    private static final ResourceKey<DensityFunction> SLOPED_CHEESE_AMPLIFIED = ModNoiseGenerator.createKey("overworld_amplified/sloped_cheese");
    private static final ResourceKey<DensityFunction> SLOPED_CHEESE_END = ModNoiseGenerator.createKey("end/sloped_cheese");
    private static final ResourceKey<DensityFunction> SPAGHETTI_ROUGHNESS_FUNCTION = ModNoiseGenerator.createKey("overworld/caves/spaghetti_roughness_function");
    private static final ResourceKey<DensityFunction> ENTRANCES = ModNoiseGenerator.createKey("overworld/caves/entrances");
    private static final ResourceKey<DensityFunction> NOODLE = ModNoiseGenerator.createKey("overworld/caves/noodle");
    private static final ResourceKey<DensityFunction> PILLARS = ModNoiseGenerator.createKey("overworld/caves/pillars");
    private static final ResourceKey<DensityFunction> SPAGHETTI_2D_THICKNESS_MODULATOR = ModNoiseGenerator.createKey("overworld/caves/spaghetti_2d_thickness_modulator");
    private static final ResourceKey<DensityFunction> SPAGHETTI_2D = ModNoiseGenerator.createKey("overworld/caves/spaghetti_2d");

    public static void bootstrap(BootstapContext<NoiseGeneratorSettings> pContext) {
        pContext.m_255272_(VORTEX_CAVES, (Object)ModNoiseGenerator.dummy(pContext));
        pContext.m_255272_(VOID, (Object)ModNoiseGenerator.void_dummy(pContext));
        pContext.m_255272_(OVERWORLD, (Object)ModNoiseGenerator.overworld(pContext, true, false));
    }

    private static DataResult<NoiseSettings> guardY(NoiseSettings p_158721_) {
        if (p_158721_.f_158688_() + p_158721_.f_64508_() > DimensionType.f_156652_ + 1) {
            return DataResult.error(() -> "min_y + height cannot be higher than: " + (DimensionType.f_156652_ + 1));
        }
        if (p_158721_.f_64508_() % 16 != 0) {
            return DataResult.error(() -> "height has to be a multiple of 16");
        }
        return p_158721_.f_158688_() % 16 != 0 ? DataResult.error(() -> "min_y has to be a multiple of 16") : DataResult.success((Object)p_158721_);
    }

    public static NoiseSettings create(int pMinY, int pHeight, int pNoiseSizeHorizontal, int pNoiseSizeVertical) {
        NoiseSettings noisesettings = new NoiseSettings(pMinY, pHeight, pNoiseSizeHorizontal, pNoiseSizeVertical);
        ModNoiseGenerator.guardY(noisesettings).error().ifPresent(p_158719_ -> {
            throw new IllegalStateException(p_158719_.message());
        });
        return noisesettings;
    }

    private static DensityFunction getFunction(HolderGetter<DensityFunction> pDensityFunctions, ResourceKey<DensityFunction> pKey) {
        return new DensityFunctions.HolderHolder((Holder)pDensityFunctions.m_255043_(pKey));
    }

    private static ResourceKey<DensityFunction> createKey(String pLocation) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_257040_, (ResourceLocation)new ResourceLocation(pLocation));
    }

    private static DensityFunction slide(DensityFunction pDensityFunction, int pMinY, int pMaxY, int p_224447_, int p_224448_, double p_224449_, int p_224450_, int p_224451_, double p_224452_) {
        DensityFunction densityfunction1 = DensityFunctions.m_208266_((int)(pMinY + pMaxY - p_224447_), (int)(pMinY + pMaxY - p_224448_), (double)1.0, (double)0.0);
        DensityFunction $$9 = DensityFunctions.m_224030_((DensityFunction)densityfunction1, (double)p_224449_, (DensityFunction)pDensityFunction);
        DensityFunction densityfunction2 = DensityFunctions.m_208266_((int)(pMinY + p_224450_), (int)(pMinY + p_224451_), (double)0.0, (double)1.0);
        return DensityFunctions.m_224030_((DensityFunction)densityfunction2, (double)p_224452_, (DensityFunction)$$9);
    }

    private static DensityFunction postProcess(DensityFunction pDensityFunction) {
        DensityFunction densityfunction = DensityFunctions.m_208389_((DensityFunction)pDensityFunction);
        return DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208281_((DensityFunction)densityfunction), (DensityFunction)DensityFunctions.m_208264_((double)0.64)).m_208234_();
    }

    private static NoiseRouter noNewCaves(HolderGetter<DensityFunction> pDensityFunctions, HolderGetter<NormalNoise.NoiseParameters> pNoiseParameters, DensityFunction p_256378_) {
        DensityFunction densityfunction = ModNoiseGenerator.getFunction(pDensityFunctions, SHIFT_X);
        DensityFunction densityfunction1 = ModNoiseGenerator.getFunction(pDensityFunctions, SHIFT_Z);
        DensityFunction densityfunction2 = DensityFunctions.m_208296_((DensityFunction)densityfunction, (DensityFunction)densityfunction1, (double)0.25, (Holder)pNoiseParameters.m_255043_(Noises.f_189269_));
        DensityFunction densityfunction3 = DensityFunctions.m_208296_((DensityFunction)densityfunction, (DensityFunction)densityfunction1, (double)0.25, (Holder)pNoiseParameters.m_255043_(Noises.f_189278_));
        DensityFunction densityfunction4 = ModNoiseGenerator.postProcess(p_256378_);
        return new NoiseRouter(DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), densityfunction2, densityfunction3, DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), densityfunction4, DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_());
    }

    private static DensityFunction noiseGradientDensity(DensityFunction pMinFunction, DensityFunction pMaxFunction) {
        DensityFunction densityfunction = DensityFunctions.m_208363_((DensityFunction)pMaxFunction, (DensityFunction)pMinFunction);
        return DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)4.0), (DensityFunction)densityfunction.m_208233_());
    }

    private static DensityFunction slideOverworld(boolean pAmplified, DensityFunction pDensityFunction) {
        return ModNoiseGenerator.slide(pDensityFunction, -64, 384, pAmplified ? 16 : 80, pAmplified ? 0 : 64, -0.078125, 0, 24, pAmplified ? 0.4 : 0.1171875);
    }

    private static DensityFunction underground(HolderGetter<DensityFunction> pDensityFunctions, HolderGetter<NormalNoise.NoiseParameters> pNoiseParameters, DensityFunction p_256658_) {
        DensityFunction densityfunction = ModNoiseGenerator.getFunction(pDensityFunctions, SPAGHETTI_2D);
        DensityFunction densityfunction1 = ModNoiseGenerator.getFunction(pDensityFunctions, SPAGHETTI_ROUGHNESS_FUNCTION);
        DensityFunction densityfunction2 = DensityFunctions.m_208324_((Holder)pNoiseParameters.m_255043_(Noises.f_189245_), (double)8.0);
        DensityFunction densityfunction3 = DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)4.0), (DensityFunction)densityfunction2.m_208230_());
        DensityFunction densityfunction4 = DensityFunctions.m_208324_((Holder)pNoiseParameters.m_255043_(Noises.f_189246_), (double)0.6666666666666666);
        DensityFunction densityfunction5 = DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)0.27), (DensityFunction)densityfunction4).m_208220_(-1.0, 1.0), (DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)1.5), (DensityFunction)DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)-0.64), (DensityFunction)p_256658_)).m_208220_(0.0, 0.5));
        DensityFunction densityfunction6 = DensityFunctions.m_208293_((DensityFunction)densityfunction3, (DensityFunction)densityfunction5);
        DensityFunction densityfunction7 = DensityFunctions.m_208375_((DensityFunction)DensityFunctions.m_208375_((DensityFunction)densityfunction6, (DensityFunction)ModNoiseGenerator.getFunction(pDensityFunctions, ENTRANCES)), (DensityFunction)DensityFunctions.m_208293_((DensityFunction)densityfunction, (DensityFunction)densityfunction1));
        DensityFunction densityfunction8 = ModNoiseGenerator.getFunction(pDensityFunctions, PILLARS);
        DensityFunction densityfunction9 = DensityFunctions.m_208287_((DensityFunction)densityfunction8, (double)-1000000.0, (double)0.03, (DensityFunction)DensityFunctions.m_208264_((double)-1000000.0), (DensityFunction)densityfunction8);
        return DensityFunctions.m_208382_((DensityFunction)densityfunction7, (DensityFunction)densityfunction9);
    }

    private static DensityFunction yLimitedInterpolatable(DensityFunction p_209472_, DensityFunction p_209473_, int p_209474_, int p_209475_, int p_209476_) {
        return DensityFunctions.m_208281_((DensityFunction)DensityFunctions.m_208287_((DensityFunction)p_209472_, (double)p_209474_, (double)(p_209475_ + 1), (DensityFunction)p_209473_, (DensityFunction)DensityFunctions.m_208264_((double)p_209476_)));
    }

    static NoiseRouter overworld(HolderGetter<DensityFunction> pDensityFunctions, HolderGetter<NormalNoise.NoiseParameters> pNoiseParameters, boolean pLarge, boolean pAmplified) {
        DensityFunction densityfunction = DensityFunctions.m_208324_((Holder)pNoiseParameters.m_255043_(Noises.f_189287_), (double)0.5);
        DensityFunction densityfunction1 = DensityFunctions.m_208324_((Holder)pNoiseParameters.m_255043_(Noises.f_189288_), (double)0.67);
        DensityFunction densityfunction2 = DensityFunctions.m_208324_((Holder)pNoiseParameters.m_255043_(Noises.f_189290_), (double)0.7142857142857143);
        DensityFunction densityfunction3 = DensityFunctions.m_208322_((Holder)pNoiseParameters.m_255043_(Noises.f_189289_));
        DensityFunction densityfunction4 = ModNoiseGenerator.getFunction(pDensityFunctions, SHIFT_X);
        DensityFunction densityfunction5 = ModNoiseGenerator.getFunction(pDensityFunctions, SHIFT_Z);
        DensityFunction densityfunction6 = DensityFunctions.m_208296_((DensityFunction)densityfunction4, (DensityFunction)densityfunction5, (double)0.25, (Holder)pNoiseParameters.m_255043_(pLarge ? Noises.f_189281_ : Noises.f_189269_));
        DensityFunction densityfunction7 = DensityFunctions.m_208296_((DensityFunction)densityfunction4, (DensityFunction)densityfunction5, (double)0.25, (Holder)pNoiseParameters.m_255043_(pLarge ? Noises.f_189282_ : Noises.f_189278_));
        DensityFunction densityfunction8 = ModNoiseGenerator.getFunction(pDensityFunctions, pLarge ? FACTOR_LARGE : (pAmplified ? FACTOR_AMPLIFIED : FACTOR));
        DensityFunction densityfunction9 = ModNoiseGenerator.getFunction(pDensityFunctions, pLarge ? DEPTH_LARGE : (pAmplified ? DEPTH_AMPLIFIED : DEPTH));
        DensityFunction densityfunction10 = ModNoiseGenerator.noiseGradientDensity(DensityFunctions.m_208373_((DensityFunction)densityfunction8), densityfunction9);
        DensityFunction densityfunction11 = ModNoiseGenerator.getFunction(pDensityFunctions, pLarge ? SLOPED_CHEESE_LARGE : (pAmplified ? SLOPED_CHEESE_AMPLIFIED : SLOPED_CHEESE));
        DensityFunction densityfunction12 = DensityFunctions.m_208375_((DensityFunction)densityfunction11, (DensityFunction)DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)5.0), (DensityFunction)ModNoiseGenerator.getFunction(pDensityFunctions, ENTRANCES)));
        DensityFunction densityfunction13 = DensityFunctions.m_208287_((DensityFunction)densityfunction11, (double)-1000000.0, (double)1.5625, (DensityFunction)densityfunction12, (DensityFunction)ModNoiseGenerator.underground(pDensityFunctions, pNoiseParameters, densityfunction11));
        DensityFunction densityfunction14 = DensityFunctions.m_208375_((DensityFunction)ModNoiseGenerator.postProcess(ModNoiseGenerator.slideOverworld(pAmplified, densityfunction13)), (DensityFunction)ModNoiseGenerator.getFunction(pDensityFunctions, NOODLE));
        DensityFunction densityfunction15 = ModNoiseGenerator.getFunction(pDensityFunctions, Y);
        int i = Stream.of(VeinType.values()).mapToInt(p_224495_ -> p_224495_.minY).min().orElse(-DimensionType.f_156653_ * 2);
        int j = Stream.of(VeinType.values()).mapToInt(p_224457_ -> p_224457_.maxY).max().orElse(-DimensionType.f_156653_ * 2);
        DensityFunction densityfunction16 = ModNoiseGenerator.yLimitedInterpolatable(densityfunction15, DensityFunctions.m_208368_((Holder)pNoiseParameters.m_255043_(Noises.f_189247_), (double)1.5, (double)1.5), i, j, 0);
        float f = 4.0f;
        DensityFunction densityfunction17 = ModNoiseGenerator.yLimitedInterpolatable(densityfunction15, DensityFunctions.m_208368_((Holder)pNoiseParameters.m_255043_(Noises.f_189248_), (double)4.0, (double)4.0), i, j, 0).m_208229_();
        DensityFunction densityfunction18 = ModNoiseGenerator.yLimitedInterpolatable(densityfunction15, DensityFunctions.m_208368_((Holder)pNoiseParameters.m_255043_(Noises.f_189249_), (double)4.0, (double)4.0), i, j, 0).m_208229_();
        DensityFunction densityfunction19 = DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)-0.08f), (DensityFunction)DensityFunctions.m_208382_((DensityFunction)densityfunction17, (DensityFunction)densityfunction18));
        DensityFunction densityfunction20 = DensityFunctions.m_208322_((Holder)pNoiseParameters.m_255043_(Noises.f_189250_));
        return new NoiseRouter(densityfunction, densityfunction1, densityfunction2, densityfunction3, densityfunction6, densityfunction7, ModNoiseGenerator.getFunction(pDensityFunctions, pLarge ? CONTINENTS_LARGE : CONTINENTS), ModNoiseGenerator.getFunction(pDensityFunctions, pLarge ? EROSION_LARGE : EROSION), densityfunction9, ModNoiseGenerator.getFunction(pDensityFunctions, RIDGES), ModNoiseGenerator.slideOverworld(pAmplified, DensityFunctions.m_208293_((DensityFunction)densityfunction10, (DensityFunction)DensityFunctions.m_208264_((double)-0.703125)).m_208220_(-64.0, 64.0)), densityfunction14, densityfunction16, densityfunction19, densityfunction20);
    }

    private static DensityFunction slideNetherLike(HolderGetter<DensityFunction> pDensityFunctions, int pMinY, int pMaxY) {
        return ModNoiseGenerator.slide(ModNoiseGenerator.getFunction(pDensityFunctions, BASE_3D_NOISE_NETHER), pMinY, pMaxY, 24, 0, 0.9375, -8, 24, 2.5);
    }

    public static NoiseGeneratorSettings dummy(BootstapContext<?> pContext) {
        return new NoiseGeneratorSettings(OVERWORLD_NOISE_SETTINGS, Blocks.f_50386_.m_49966_(), Blocks.f_50016_.m_49966_(), ModNoiseGenerator.noNewCaves((HolderGetter<DensityFunction>)pContext.m_255420_(Registries.f_257040_), (HolderGetter<NormalNoise.NoiseParameters>)pContext.m_255420_(Registries.f_256865_), ModNoiseGenerator.slideNetherLike((HolderGetter<DensityFunction>)pContext.m_255420_(Registries.f_257040_), -256, 256)), ModSurfaceRules.makeRules(), List.of(), -256, false, false, false, false);
    }

    public static NoiseGeneratorSettings overworld(BootstapContext<?> pContext, boolean pAmplified, boolean pLarge) {
        return new NoiseGeneratorSettings(OVERWORLD_NOISE_SETTINGS, Blocks.f_50730_.m_49966_(), Blocks.f_49990_.m_49966_(), ModNoiseGenerator.overworld((HolderGetter<DensityFunction>)pContext.m_255420_(Registries.f_257040_), (HolderGetter<NormalNoise.NoiseParameters>)pContext.m_255420_(Registries.f_256865_), pLarge, pAmplified), ModSurfaceRules.makeRules(), new OverworldBiomeBuilder().m_187154_(), 64, false, true, false, false);
    }

    public static NoiseGeneratorSettings void_dummy(BootstapContext<?> pContext) {
        return new NoiseGeneratorSettings(OVERWORLD_NOISE_SETTINGS, Blocks.f_50016_.m_49966_(), Blocks.f_50016_.m_49966_(), ModNoiseGenerator.noNewCaves((HolderGetter<DensityFunction>)pContext.m_255420_(Registries.f_257040_), (HolderGetter<NormalNoise.NoiseParameters>)pContext.m_255420_(Registries.f_256865_), ModNoiseGenerator.slideNetherLike((HolderGetter<DensityFunction>)pContext.m_255420_(Registries.f_257040_), -256, 256)), ModSurfaceRules.makeRules(), List.of(), -256, false, false, false, false);
    }

    static enum VeinType {
        COPPER(Blocks.f_152505_.m_49966_(), Blocks.f_152599_.m_49966_(), Blocks.f_50122_.m_49966_(), 0, 50),
        IRON(Blocks.f_152468_.m_49966_(), Blocks.f_152598_.m_49966_(), Blocks.f_152496_.m_49966_(), -60, -8);

        final BlockState ore;
        final BlockState rawOreBlock;
        final BlockState filler;
        protected final int minY;
        protected final int maxY;

        private VeinType(BlockState pOre, BlockState pRawOreBlock, BlockState pFiller, int pMinY, int pMaxY) {
            this.ore = pOre;
            this.rawOreBlock = pRawOreBlock;
            this.filler = pFiller;
            this.minY = pMinY;
            this.maxY = pMaxY;
        }
    }
}

