/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.worldgen.biome;

import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.plaaasma.vortexmod.entities.ModEntities;
import net.plaaasma.vortexmod.worldgen.ModPlacedFeatures;

public class ModBiomes {
    public static final ResourceKey<Biome> BLUE_VORTEX_BIOME = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("vortexmod", "blue_vortex_biome"));
    public static final ResourceKey<Biome> ORANGE_VORTEX_BIOME = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("vortexmod", "orange_vortex_biome"));
    public static final ResourceKey<Biome> PURPLE_VORTEX_BIOME = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("vortexmod", "purple_vortex_biome"));
    public static final ResourceKey<Biome> BLACK_VORTEX_BIOME = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("vortexmod", "black_vortex_biome"));
    public static final ResourceKey<Biome> TARDIS_BIOME = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("vortexmod", "tardis_biome"));
    public static final ResourceKey<Biome> IRRADIATED_FOREST_BIOME = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("vortexmod", "irradiated_forest_biome"));
    public static final ResourceKey<Biome> SUPER_IRRADIATED_FOREST_BIOME = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("vortexmod", "super_irradiated_forest_biome"));
    public static final ResourceKey<Biome> IRRADIATED_DESERT_BIOME = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("vortexmod", "irradiated_desert_biome"));
    public static final ResourceKey<Biome> IRRADIATED_BADLANDS_BIOME = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("vortexmod", "irradiated_badlands_biome"));

    public static void bootstrap(BootstapContext<Biome> context) {
        context.m_255272_(BLUE_VORTEX_BIOME, (Object)ModBiomes.vortexBiome(context, BiomeColor.BLUE));
        context.m_255272_(ORANGE_VORTEX_BIOME, (Object)ModBiomes.vortexBiome(context, BiomeColor.ORANGE));
        context.m_255272_(PURPLE_VORTEX_BIOME, (Object)ModBiomes.vortexBiome(context, BiomeColor.PURPLE));
        context.m_255272_(BLACK_VORTEX_BIOME, (Object)ModBiomes.vortexBiome(context, BiomeColor.BLACK));
        context.m_255272_(TARDIS_BIOME, (Object)ModBiomes.tardisBiome(context));
        context.m_255272_(IRRADIATED_FOREST_BIOME, (Object)ModBiomes.irradiatedForest(context));
        context.m_255272_(SUPER_IRRADIATED_FOREST_BIOME, (Object)ModBiomes.irradiatedForest(context));
        context.m_255272_(IRRADIATED_DESERT_BIOME, (Object)ModBiomes.irradiatedDesert(context));
        context.m_255272_(IRRADIATED_BADLANDS_BIOME, (Object)ModBiomes.irradiatedDesert(context));
    }

    public static Biome vortexBiome(BootstapContext<Biome> context, BiomeColor biomeColor) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        switch (biomeColor) {
            case BLUE: {
                biomeBuilder.m_255155_(GenerationStep.Decoration.RAW_GENERATION, ModPlacedFeatures.BLUE_BIOME_1_PlACED);
                biomeBuilder.m_255155_(GenerationStep.Decoration.RAW_GENERATION, ModPlacedFeatures.BLUE_BIOME_2_PlACED);
                break;
            }
            case ORANGE: {
                biomeBuilder.m_255155_(GenerationStep.Decoration.RAW_GENERATION, ModPlacedFeatures.ORANGE_BIOME_1_PlACED);
                biomeBuilder.m_255155_(GenerationStep.Decoration.RAW_GENERATION, ModPlacedFeatures.ORANGE_BIOME_2_PlACED);
                break;
            }
            case PURPLE: {
                biomeBuilder.m_255155_(GenerationStep.Decoration.RAW_GENERATION, ModPlacedFeatures.PURPLE_BIOME_1_PlACED);
                biomeBuilder.m_255155_(GenerationStep.Decoration.RAW_GENERATION, ModPlacedFeatures.PURPLE_BIOME_2_PlACED);
                break;
            }
            case BLACK: {
                biomeBuilder.m_255155_(GenerationStep.Decoration.RAW_GENERATION, ModPlacedFeatures.BLACK_BIOME_1_PlACED);
                biomeBuilder.m_255155_(GenerationStep.Decoration.RAW_GENERATION, ModPlacedFeatures.BLACK_BIOME_2_PlACED);
            }
        }
        return new Biome.BiomeBuilder().m_264558_(false).m_47611_(0.8f).m_47609_(1.0f).m_47601_(biomeBuilder.m_255380_()).m_47605_(spawnBuilder.m_48381_()).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(11045682).m_48037_(8343039).m_48040_(11045682).m_48045_(11045682).m_48043_(11045682).m_48019_(8343039).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47592_();
    }

    public static Biome tardisBiome(BootstapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        return new Biome.BiomeBuilder().m_264558_(false).m_47611_(0.8f).m_47609_(1.0f).m_47601_(biomeBuilder.m_255380_()).m_47605_(spawnBuilder.m_48381_()).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(0xFFFFFF).m_48040_(0xFFFFFF).m_48045_(9551193).m_48043_(7842607).m_48019_(0xFFFFFF).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47592_();
    }

    public static Biome irradiatedForest(BootstapContext<Biome> context) {
        BiomeGenerationSettings.Builder biomeGenerationSettings = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        Music music = Musics.m_263184_((Holder)SoundEvents.f_12113_);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeGenerationSettings);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeGenerationSettings);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeGenerationSettings);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)biomeGenerationSettings);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeGenerationSettings);
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)biomeGenerationSettings);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeGenerationSettings);
        BiomeDefaultFeatures.m_194716_((BiomeGenerationSettings.Builder)biomeGenerationSettings);
        BiomeDefaultFeatures.m_126773_((BiomeGenerationSettings.Builder)biomeGenerationSettings);
        MobSpawnSettings.Builder mobSpawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)mobSpawnBuilder);
        mobSpawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.GOLD_DALEK.get(), 1000, 1, 2));
        mobSpawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.SILVER_DALEK.get(), 1000, 1, 2));
        mobSpawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.BLACK_DALEK.get(), 1000, 1, 2));
        mobSpawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.SILVER_BLACK_DALEK.get(), 1000, 1, 2));
        return new Biome.BiomeBuilder().m_264558_(false).m_47611_(0.0f).m_47609_(-10.0f).m_47601_(biomeGenerationSettings.m_255380_()).m_47605_(mobSpawnBuilder.m_48381_()).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(0x2D323D).m_48037_(0x333232).m_48040_(0x292828).m_48045_(3158829).m_48043_(2699296).m_48019_(0x242323).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123790_, 0.118093334f)).m_48023_((Holder)SoundEvents.f_11795_).m_48027_(new AmbientMoodSettings((Holder)SoundEvents.f_11848_, 6000, 8, 2.0)).m_48025_(new AmbientAdditionsSettings((Holder)SoundEvents.f_11742_, 0.0111)).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_12154_)).m_48018_()).m_47592_();
    }

    public static Biome irradiatedDesert(BootstapContext<Biome> context) {
        BiomeGenerationSettings.Builder biomeGenerationSettings = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeGenerationSettings);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeGenerationSettings);
        BiomeDefaultFeatures.m_126773_((BiomeGenerationSettings.Builder)biomeGenerationSettings);
        BiomeDefaultFeatures.m_126716_((BiomeGenerationSettings.Builder)biomeGenerationSettings);
        BiomeDefaultFeatures.m_126751_((BiomeGenerationSettings.Builder)biomeGenerationSettings);
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)biomeGenerationSettings);
        MobSpawnSettings.Builder mobSpawnBuilder = new MobSpawnSettings.Builder();
        mobSpawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.GOLD_DALEK.get(), 1000, 1, 2));
        mobSpawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.SILVER_DALEK.get(), 1000, 1, 2));
        mobSpawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.BLACK_DALEK.get(), 1000, 1, 2));
        mobSpawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.SILVER_BLACK_DALEK.get(), 1000, 1, 2));
        return new Biome.BiomeBuilder().m_264558_(false).m_47611_(0.0f).m_47609_(-10.0f).m_47601_(biomeGenerationSettings.m_255380_()).m_47605_(mobSpawnBuilder.m_48381_()).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(0x2D323D).m_48037_(0x333232).m_48040_(0x292828).m_48045_(3158829).m_48043_(2699296).m_48019_(0x242323).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123790_, 0.118093334f)).m_48023_((Holder)SoundEvents.f_11795_).m_48027_(new AmbientMoodSettings((Holder)SoundEvents.f_11848_, 6000, 8, 2.0)).m_48025_(new AmbientAdditionsSettings((Holder)SoundEvents.f_11742_, 0.0111)).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_12154_)).m_48018_()).m_47592_();
    }

    private static enum BiomeColor {
        BLUE,
        ORANGE,
        PURPLE,
        BLACK;

    }
}

